/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.tokensource;

import com.google.jenkins.plugins.credentials.oauth.GoogleOAuth2ScopeRequirement;
import com.google.jenkins.plugins.credentials.oauth.GoogleRobotCredentials;
import hudson.Extension;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import jenkins.authentication.tokens.api.AuthenticationTokenSource;
import org.jenkinsci.plugins.kubernetes.auth.impl.KubernetesAuthToken;

@Extension(optional=true)
public class GoogleRobotCredentialsTokenSource
extends AuthenticationTokenSource<KubernetesAuthToken, GoogleRobotCredentials> {
    public GoogleRobotCredentialsTokenSource() {
        super(KubernetesAuthToken.class, GoogleRobotCredentials.class);
    }

    @Nonnull
    public KubernetesAuthToken convert(@Nonnull GoogleRobotCredentials credential) {
        return new KubernetesAuthToken((serviceAddress, caCertData, skipTlsVerify) -> credential.getAccessToken(new GoogleOAuth2ScopeRequirement(){

            public Collection<String> getScopes() {
                return Collections.singleton("https://www.googleapis.com/auth/cloud-platform");
            }
        }).getPlainText());
    }
}

