/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.auth.impl;

import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.ConfigBuilder;
import io.fabric8.kubernetes.client.internal.KubeConfigUtils;
import java.io.IOException;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuth;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthConfig;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;

public class KubernetesAuthKubeconfig
implements KubernetesAuth {
    private final String kubeconfig;

    public KubernetesAuthKubeconfig(String kubeconfig) {
        this.kubeconfig = kubeconfig;
    }

    @Override
    public String buildKubeConfig(KubernetesAuthConfig config) {
        return this.getKubeconfig();
    }

    @Override
    public io.fabric8.kubernetes.client.ConfigBuilder decorate(io.fabric8.kubernetes.client.ConfigBuilder builder, KubernetesAuthConfig config) {
        return new io.fabric8.kubernetes.client.ConfigBuilder(io.fabric8.kubernetes.client.Config.fromKubeconfig((String)this.getKubeconfig()));
    }

    @Override
    public ConfigBuilder buildConfigBuilder(KubernetesAuthConfig config, String context, String clusterName, String username) throws KubernetesAuthException {
        try {
            Config kubeConfig = KubeConfigUtils.parseConfigFromString((String)this.getKubeconfig());
            return new ConfigBuilder(kubeConfig);
        }
        catch (IOException e) {
            throw new KubernetesAuthException(e.getMessage(), e);
        }
    }

    public String getKubeconfig() {
        return this.kubeconfig;
    }
}

