/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.auth.impl;

import hudson.util.Secret;
import io.fabric8.kubernetes.api.model.AuthInfoBuilder;
import io.fabric8.kubernetes.client.ConfigBuilder;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuth;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthConfig;
import org.jenkinsci.plugins.kubernetes.auth.impl.AbstractKubernetesAuth;
import org.jenkinsci.plugins.kubernetes.credentials.Utils;

public class KubernetesAuthCertificate
extends AbstractKubernetesAuth
implements KubernetesAuth {
    private final String certificate;
    private final Secret key;

    public KubernetesAuthCertificate(String certificate, Secret key) {
        this.certificate = certificate;
        this.key = key;
    }

    public KubernetesAuthCertificate(String certificate, String key) {
        this(certificate, Secret.fromString((String)key));
    }

    @Override
    public AuthInfoBuilder decorate(AuthInfoBuilder builder, KubernetesAuthConfig config) {
        return (AuthInfoBuilder)((AuthInfoBuilder)builder.withClientCertificateData(Utils.encodeBase64(this.certificate))).withClientKeyData(Utils.encodeBase64(this.key.getPlainText()));
    }

    @Override
    public ConfigBuilder decorate(ConfigBuilder builder, KubernetesAuthConfig config) {
        return (ConfigBuilder)((ConfigBuilder)builder.withClientCertData(Utils.encodeBase64(this.certificate))).withClientKeyData(Utils.encodeBase64(this.key.getPlainText()));
    }

    public String getCertificate() {
        return this.certificate;
    }

    @Deprecated
    public String getKey() {
        return this.key.getPlainText();
    }

    public Secret getKeySecret() {
        return this.key;
    }
}

