/*
 * Decompiled with CFR 0.152.
 */
package winstone.accesslog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import winstone.Logger;
import winstone.WinstoneResourceBundle;
import winstone.cmdline.Option;

public class SimpleAccessLogger
extends AbstractLifeCycle
implements RequestLog {
    public static final WinstoneResourceBundle ACCESSLOG_RESOURCES = new WinstoneResourceBundle("winstone.accesslog.LocalStrings");
    private static final DateFormat DF = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
    private static final String COMMON = "###ip### - ###user### ###time### \"###uriLine###\" ###status### ###size###";
    private static final String COMBINED = "###ip### - ###user### ###time### \"###uriLine###\" ###status### ###size### \"###referer###\" \"###userAgent###\"";
    private static final String RPROXYCOMBINED = "###x-forwarded-for### ###ip### - ###user### ###time### \"###uriLine###\" ###status### ###size### \"###referer###\" \"###userAgent###\"";
    private static final String RESIN = "###ip### - ###user### ###time### \"###uriLine###\" ###status### ###size### \"###userAgent###\"";
    private OutputStream outStream;
    private PrintWriter outWriter;
    private String pattern;
    private String fileName;

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="false positive, webAppName come from command line")
    public SimpleAccessLogger(String webAppName, Map<String, String> startupArgs) throws IOException {
        String patternType = Option.SIMPLE_ACCESS_LOGGER_FORMAT.get(startupArgs);
        this.pattern = patternType.equalsIgnoreCase("combined") ? COMBINED : (patternType.equalsIgnoreCase("common") ? COMMON : (patternType.equalsIgnoreCase("resin") ? RESIN : (patternType.equalsIgnoreCase("rproxycombined") ? RPROXYCOMBINED : patternType)));
        String filePattern = Option.SIMPLE_ACCESS_LOGGER_FILE.get(startupArgs);
        this.fileName = WinstoneResourceBundle.globalReplace(filePattern, new String[][]{{"###webapp###", webAppName}});
        File file = new File(this.fileName);
        File parentFile = file.getParentFile();
        try {
            Files.createDirectories(parentFile.toPath(), new FileAttribute[0]);
        }
        catch (Exception ex) {
            Logger.logDirectMessage(Level.WARNING, null, "Failed to mkdirs " + parentFile.getAbsolutePath(), ex);
        }
        try {
            this.outStream = Files.newOutputStream(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        }
        catch (InvalidPathException e) {
            throw new IOException(e);
        }
        this.outWriter = new PrintWriter((Writer)new OutputStreamWriter(this.outStream, StandardCharsets.UTF_8), true);
        Logger.log(Level.FINER, ACCESSLOG_RESOURCES, "SimpleAccessLogger.Init", this.fileName, patternType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Request request, Response response) {
        String date;
        String uriLine = request.getMethod() + " " + request.getHttpURI().getPath() + " " + request.getConnectionMetaData().getProtocol();
        int status = response.getStatus();
        long size = Response.getContentBytesWritten(response);
        DateFormat dateFormat = DF;
        synchronized (dateFormat) {
            date = DF.format(new Date());
        }
        Request.AuthenticationState authenticationState = Request.getAuthenticationState(request);
        Principal principal = authenticationState == null ? null : authenticationState.getUserPrincipal();
        String remoteUser = principal == null ? "-" : principal.getName();
        HttpFields httpFields = request.getHeaders();
        String logLine = WinstoneResourceBundle.globalReplace(this.pattern, new String[][]{{"###x-forwarded-for###", SimpleAccessLogger.nvl(httpFields.get("X-Forwarded-For"))}, {"###x-forwarded-host###", SimpleAccessLogger.nvl(httpFields.get("X-Forwarded-Host"))}, {"###x-forwarded-proto###", SimpleAccessLogger.nvl(httpFields.get("X-Forwarded-Proto"))}, {"###x-forwarded-protocol###", SimpleAccessLogger.nvl(httpFields.get("X-Forwarded-Protocol"))}, {"###x-forwarded-server###", SimpleAccessLogger.nvl(httpFields.get("X-Forwarded-Server"))}, {"###x-forwarded-ssl###", SimpleAccessLogger.nvl(httpFields.get("X-Forwarded-Ssl"))}, {"###x-requested-with###", SimpleAccessLogger.nvl(httpFields.get("X-Requested-With"))}, {"###x-do-not-track###", SimpleAccessLogger.nvl(httpFields.get("X-Do-Not-Track"))}, {"###dnt###", SimpleAccessLogger.nvl(httpFields.get("DNT"))}, {"###via###", SimpleAccessLogger.nvl(httpFields.get("Via"))}, {"###ip###", Request.getRemoteAddr(request)}, {"###user###", SimpleAccessLogger.nvl(remoteUser)}, {"###time###", "[" + date + "]"}, {"###uriLine###", uriLine}, {"###status###", "" + status}, {"###size###", "" + size}, {"###referer###", SimpleAccessLogger.nvl(httpFields.get("Referer"))}, {"###userAgent###", SimpleAccessLogger.nvl(httpFields.get("User-Agent"))}});
        this.outWriter.println(logLine);
    }

    private static String nvl(String input) {
        return input == null ? "-" : input;
    }

    @Override
    protected void doStop() throws Exception {
        Logger.log(Level.FINER, ACCESSLOG_RESOURCES, "SimpleAccessLogger.Close", (Object)this.fileName);
        if (this.outWriter != null) {
            this.outWriter.flush();
            this.outWriter.close();
            this.outWriter = null;
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException err) {
                Logger.logDirectMessage(Level.WARNING, null, "Failed to close access logger output stream", err);
            }
            this.outStream = null;
        }
        this.fileName = null;
    }
}

