/*
 * Decompiled with CFR 0.152.
 */
package winstone.realm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.util.security.Credential;
import winstone.Logger;
import winstone.WinstoneResourceBundle;
import winstone.cmdline.Option;

public class ArgumentsRealm
extends HashLoginService {
    private static final WinstoneResourceBundle REALM_RESOURCES = new WinstoneResourceBundle("winstone.realm.LocalStrings");

    public ArgumentsRealm(Map<String, String> args) {
        UserStore userStore = new UserStore();
        this.setUserStore(userStore);
        int count = 0;
        for (String key : args.keySet()) {
            if (!key.startsWith(Option.ARGUMENTS_REALM_PASSWORD.name)) continue;
            String userName = key.substring(Option.ARGUMENTS_REALM_PASSWORD.name.length());
            String password = args.get(key);
            String roleList = Option.stringArg(args, Option.ARGUMENTS_REALM_ROLES.name + userName, "");
            Object[] roleArray = new String[]{};
            if (roleList.equals("")) {
                Logger.log(Logger.WARNING, REALM_RESOURCES, "ArgumentsRealm.UndeclaredRoles", (Object)userName);
            } else {
                StringTokenizer st = new StringTokenizer(roleList, ",");
                ArrayList<String> rl = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String currentRole = st.nextToken();
                    rl.add(currentRole);
                }
                roleArray = rl.toArray(new String[0]);
                Arrays.sort(roleArray);
            }
            userStore.addUser(userName, Credential.getCredential(password), (String[])roleArray);
            ++count;
        }
        Logger.log(Logger.DEBUG, REALM_RESOURCES, "ArgumentsRealm.Initialised", (Object)("" + count));
    }
}

