/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import winstone.ConnectorFactory;
import winstone.Logger;
import winstone.WinstoneException;
import winstone.WinstoneResourceBundle;
import winstone.cmdline.Option;

public abstract class AbstractSecuredConnectorFactory
implements ConnectorFactory {
    protected static final WinstoneResourceBundle SSL_RESOURCES = new WinstoneResourceBundle("winstone.LocalStrings");
    protected KeyStore keystore;
    protected String keystorePassword;

    protected void configureSsl(Map<String, String> args, Server server) throws IOException {
        block9: {
            try {
                File keyStore = Option.HTTPS_KEY_STORE.get(args);
                String pwd = Option.HTTPS_KEY_STORE_PASSWORD.get(args);
                if (keyStore != null) {
                    if (!keyStore.exists() || !keyStore.isFile()) {
                        throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.KeyStoreNotFound", keyStore.getPath()));
                    }
                    this.keystorePassword = pwd;
                    this.keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (FileInputStream inputStream = new FileInputStream(keyStore);){
                        this.keystore.load(inputStream, this.keystorePassword.toCharArray());
                        break block9;
                    }
                }
                throw new WinstoneException(MessageFormat.format("Please set --{0}", Option.HTTPS_KEY_STORE));
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Failed to handle keys", e);
            }
        }
    }

    protected SslContextFactory.Server getSSLContext(Map<String, String> args) {
        try {
            String privateKeyPassword = Option.HTTPS_PRIVATE_KEY_PASSWORD.get(args, this.keystorePassword);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(Option.HTTPS_KEY_MANAGER_TYPE.get(args));
            kmf.init(this.keystore, this.keystorePassword.toCharArray());
            Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyCount", (Object)("" + this.keystore.size()));
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyFound", alias, "" + this.keystore.getCertificate(alias));
            }
            SslContextFactory.Server ssl = new SslContextFactory.Server();
            ssl.setKeyStore(this.keystore);
            ssl.setKeyStorePassword(this.keystorePassword);
            ssl.setKeyManagerPassword(privateKeyPassword);
            ssl.setKeyManagerFactoryAlgorithm(Option.HTTPS_KEY_MANAGER_TYPE.get(args));
            ssl.setCertAlias(Option.HTTPS_CERTIFICATE_ALIAS.get(args));
            ssl.setExcludeProtocols("SSLv3", "SSLv2", "SSLv2Hello");
            String excludeCiphers = Option.HTTPS_EXCLUDE_CIPHER_SUITES.get(args);
            if (excludeCiphers != null && excludeCiphers.length() > 0) {
                String[] cipherSuites = excludeCiphers.split(",");
                ssl.setExcludeCipherSuites(cipherSuites);
            }
            Logger.log(Logger.INFO, SSL_RESOURCES, "HttpsListener.ExcludeCiphers", Arrays.asList(ssl.getExcludeCipherSuites()));
            ssl.setNeedClientAuth(Option.HTTPS_VERIFY_CLIENT.get(args));
            return ssl;
        }
        catch (Throwable err) {
            throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.ErrorGettingContext"), err);
        }
    }
}

