/*
 * Decompiled with CFR 0.152.
 */
package winstone.tools;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import winstone.Logger;
import winstone.WinstoneResourceBundle;
import winstone.cmdline.CmdLineParser;
import winstone.cmdline.Option;

public class WinstoneControl {
    private static final WinstoneResourceBundle TOOLS_RESOURCES = new WinstoneResourceBundle("winstone.tools.LocalStrings");
    static final String OPERATION_SHUTDOWN = "shutdown";
    static final String OPERATION_RELOAD = "reload:";
    static int TIMEOUT = 10000;
    public static Option.OInt CONTROL_PORT = Option.integer("controlPort");
    public static Option.OInt PORT = Option.integer("port");
    public static Option.OInt DEBUG = new Option.OInt("debug", 5){

        @Override
        public int get(Map args) {
            switch (super.get(args)) {
                case 1: {
                    return Logger.MIN.intValue();
                }
                case 2: {
                    return Logger.ERROR.intValue();
                }
                case 3: {
                    return Logger.WARNING.intValue();
                }
                case 4: {
                    return Logger.INFO.intValue();
                }
                case 6: {
                    return Logger.SPEED.intValue();
                }
                case 7: {
                    return Logger.DEBUG.intValue();
                }
                case 8: {
                    return Logger.FULL_DEBUG.intValue();
                }
                case 9: {
                    return Logger.MAX.intValue();
                }
            }
            return Logger.INFO.intValue();
        }
    };
    public static Option.OString HOST = Option.string("host", "localhost");

    public static void main(String[] argv) throws Exception {
        Map<String, String> options = new CmdLineParser(Option.all(WinstoneControl.class)).parse(argv, "operation");
        String operation = options.get("operation");
        if (operation.equals("")) {
            WinstoneControl.printUsage();
            return;
        }
        Logger.setCurrentDebugLevel(DEBUG.get(options));
        String host = HOST.get(options);
        int port = PORT.get(options, CONTROL_PORT.get(options));
        Logger.log(Logger.INFO, TOOLS_RESOURCES, "WinstoneControl.UsingHostPort", host, port);
        if (operation.equalsIgnoreCase(OPERATION_SHUTDOWN)) {
            Socket socket = new Socket(host, port);
            socket.setSoTimeout(TIMEOUT);
            try (OutputStream out = socket.getOutputStream();){
                out.write(48);
                Logger.log(Logger.INFO, TOOLS_RESOURCES, "WinstoneControl.ShutdownOK", host, port);
            }
        }
        if (operation.toLowerCase().startsWith(OPERATION_RELOAD.toLowerCase())) {
            String webappName = operation.substring(OPERATION_RELOAD.length());
            Socket socket = new Socket(host, port);
            socket.setSoTimeout(TIMEOUT);
            try (OutputStream out = socket.getOutputStream();
                 ObjectOutputStream objOut = new ObjectOutputStream(out);){
                out.write(52);
                objOut.writeUTF(host);
                objOut.writeUTF(webappName);
            }
            Logger.log(Logger.INFO, TOOLS_RESOURCES, "WinstoneControl.ReloadOK", host, port);
        } else {
            WinstoneControl.printUsage();
        }
    }

    private static void printUsage() {
        System.out.println(TOOLS_RESOURCES.getString("WinstoneControl.Usage"));
    }
}

