/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import io.jenkins.lib.support_log_formatter.SupportLogFormatter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.JavaUtilLog;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import winstone.ConnectorFactory;
import winstone.HostConfiguration;
import winstone.HostGroup;
import winstone.Logger;
import winstone.ShutdownHook;
import winstone.WinstoneResourceBundle;
import winstone.cmdline.CmdLineParser;
import winstone.cmdline.Option;

public class Launcher
implements Runnable {
    static final String HTTP_LISTENER_CLASS = "winstone.HttpConnectorFactory";
    static final String HTTPS_LISTENER_CLASS = "winstone.HttpsConnectorFactory";
    static final String HTTP2_LISTENER_CLASS = "winstone.Http2ConnectorFactory";
    static final String AJP_LISTENER_CLASS = "winstone.Ajp13ConnectorFactory";
    public static final byte SHUTDOWN_TYPE = 48;
    public static final byte RELOAD_TYPE = 52;
    private int CONTROL_TIMEOUT = 2000;
    private Thread controlThread;
    public static final WinstoneResourceBundle RESOURCES = new WinstoneResourceBundle("winstone.LocalStrings");
    private int controlPort;
    private HostGroup hostGroup;
    private Map args;
    public final Server server;
    public static String USAGE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Launcher(Map args) throws IOException {
        boolean success = false;
        try {
            int qtpMaxThread;
            File javaHome2;
            File toolsJar2;
            Logger.log(Logger.MAX, RESOURCES, "Launcher.StartupArgs", (Object)(args + ""));
            this.args = args;
            this.controlPort = Option.CONTROL_PORT.get(args);
            if (Option.HANDLER_COUNT_MAX.get(args, -1) != -1) {
                Logger.log(Logger.WARNING, RESOURCES, Option.HANDLER_COUNT_MAX.name);
            }
            if (Option.HANDLER_COUNT_MAX_IDLE.get(args, -1) != -1) {
                Logger.log(Logger.WARNING, RESOURCES, Option.HANDLER_COUNT_MAX_IDLE.name);
            }
            ArrayList<URL> jars = new ArrayList<URL>();
            ArrayList<File> commonLibCLPaths = new ArrayList<File>();
            String defaultJavaHome = System.getProperty("java.home");
            File javaHome = Option.JAVA_HOME.get(args, new File(defaultJavaHome));
            Logger.log(Logger.DEBUG, RESOURCES, "Launcher.UsingJavaHome", (Object)javaHome.getPath());
            File toolsJar = Option.TOOLS_JAR.get(args);
            if (toolsJar == null && !(toolsJar = new File(javaHome, "lib/tools.jar")).exists() && (toolsJar2 = new File(javaHome2 = javaHome.getParentFile(), "lib/tools.jar")).exists()) {
                javaHome = javaHome2;
                toolsJar = toolsJar2;
            }
            if (toolsJar.exists()) {
                jars.add(toolsJar.toURL());
                commonLibCLPaths.add(toolsJar);
                Logger.log(Logger.DEBUG, RESOURCES, "Launcher.AddedCommonLibJar", (Object)toolsJar.getName());
            } else if (Option.USE_JASPER.get(args)) {
                Logger.log(Logger.WARNING, RESOURCES, "Launcher.ToolsJarNotFound");
            }
            File libFolder = Option.COMMON_LIB_FOLDER.get(args, new File("lib"));
            if (libFolder.exists() && libFolder.isDirectory()) {
                File[] children;
                Logger.log(Logger.DEBUG, RESOURCES, "Launcher.UsingCommonLib", (Object)libFolder.getCanonicalPath());
                for (File aChildren : children = libFolder.listFiles()) {
                    if (!aChildren.getName().endsWith(".jar") && !aChildren.getName().endsWith(".zip")) continue;
                    jars.add(aChildren.toURL());
                    commonLibCLPaths.add(aChildren);
                    Logger.log(Logger.DEBUG, RESOURCES, "Launcher.AddedCommonLibJar", (Object)aChildren.getName());
                }
            } else {
                Logger.log(Logger.DEBUG, RESOURCES, "Launcher.NoCommonLib");
            }
            File extraLibFolder = Option.EXTRA_LIB_FOLDER.get(args);
            ArrayList<URL> extraJars = new ArrayList<URL>();
            if (extraLibFolder != null && extraLibFolder.exists()) {
                File[] children;
                for (File aChildren : children = extraLibFolder.listFiles()) {
                    if (!aChildren.getName().endsWith(".jar") && !aChildren.getName().endsWith(".zip")) continue;
                    extraJars.add(aChildren.toURL());
                }
            }
            URLClassLoader commonLibCL = new URLClassLoader(jars.toArray(new URL[jars.size()]), this.getClass().getClassLoader());
            Logger.log(Logger.MAX, RESOURCES, "Launcher.CLClassLoader", (Object)commonLibCL.toString());
            Logger.log(Logger.MAX, RESOURCES, "Launcher.CLClassLoader", (Object)((Object)commonLibCLPaths).toString());
            if (!extraJars.isEmpty()) {
                URLClassLoader extraClassLoader = new URLClassLoader(extraJars.toArray(new URL[extraJars.size()]), this.getClass().getClassLoader());
                Thread.currentThread().setContextClassLoader(extraClassLoader);
            }
            QueuedThreadPool queuedThreadPool = (qtpMaxThread = Option.QTP_MAXTHREADS.get(args)) > 0 ? new QueuedThreadPool(qtpMaxThread) : new QueuedThreadPool();
            this.server = new Server(queuedThreadPool);
            int maxParameterCount = Option.MAX_PARAM_COUNT.get(args);
            if (maxParameterCount > 0) {
                this.server.setAttribute("org.eclipse.jetty.server.Request.maxFormKeys", maxParameterCount);
            }
            this.server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", Option.REQUEST_FORM_CONTENT_SIZE.get(args));
            this.hostGroup = new HostGroup(this.server, commonLibCL, commonLibCLPaths.toArray(new File[0]), args);
            this.spawnListener(HTTP_LISTENER_CLASS);
            this.spawnListener(AJP_LISTENER_CLASS);
            this.spawnListener(HTTPS_LISTENER_CLASS);
            this.spawnListener(HTTP2_LISTENER_CLASS);
            if (Option.USE_JMX.get(args)) {
                MBeanContainer mbeanContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
                this.server.addBean(mbeanContainer);
            }
            try {
                this.server.start();
            }
            catch (Exception e) {
                throw new IOException("Failed to start Jetty", e);
            }
            this.controlThread = new Thread((Runnable)this, RESOURCES.getString("Launcher.ThreadName", "" + this.controlPort));
            this.controlThread.setDaemon(false);
            this.controlThread.start();
            success = true;
        }
        finally {
            if (!success) {
                this.shutdown();
            }
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook(this));
    }

    protected void spawnListener(String listenerClassName) throws IOException {
        try {
            ConnectorFactory connectorFactory = (ConnectorFactory)Class.forName(listenerClassName).newInstance();
            connectorFactory.start(this.args, this.server);
        }
        catch (Throwable err) {
            throw (IOException)new IOException("Failed to start a listener: " + listenerClassName).initCause(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean interrupted = false;
        try {
            ServerSocket controlSocket = null;
            if (this.controlPort > 0) {
                controlSocket = new ServerSocket(this.controlPort);
                controlSocket.setSoTimeout(this.CONTROL_TIMEOUT);
            }
            Logger.log(Logger.INFO, RESOURCES, "Launcher.StartupOK", RESOURCES.getString("ServerVersion"), this.controlPort > 0 ? "" + this.controlPort : RESOURCES.getString("Launcher.ControlDisabled"));
            while (!interrupted) {
                Socket accepted = null;
                try {
                    if (controlSocket != null) {
                        accepted = controlSocket.accept();
                        if (accepted == null) continue;
                        this.handleControlRequest(accepted);
                        continue;
                    }
                    Thread.sleep(this.CONTROL_TIMEOUT);
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (InterruptedException err) {
                    interrupted = true;
                }
                catch (Throwable err) {
                    Logger.log(Logger.ERROR, RESOURCES, "Launcher.ShutdownError", err);
                }
                finally {
                    if (accepted != null) {
                        try {
                            accepted.close();
                        }
                        catch (IOException err) {}
                    }
                    if (!Thread.interrupted()) continue;
                    interrupted = true;
                }
            }
            if (controlSocket != null) {
                controlSocket.close();
            }
        }
        catch (Throwable err) {
            Logger.log(Logger.ERROR, RESOURCES, "Launcher.ShutdownError", err);
        }
        Logger.log(Logger.INFO, RESOURCES, "Launcher.ControlThreadShutdownOK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleControlRequest(Socket csAccepted) throws IOException {
        InputStream inSocket = null;
        OutputStream outSocket = null;
        ObjectInputStream inControl = null;
        try {
            inSocket = csAccepted.getInputStream();
            int reqType = inSocket.read();
            if ((byte)reqType == 48) {
                Logger.log(Logger.INFO, RESOURCES, "Launcher.ShutdownRequestReceived");
                this.shutdown();
            } else if ((byte)reqType == 52) {
                inControl = new ObjectInputStream(inSocket);
                String host = inControl.readUTF();
                String prefix = inControl.readUTF();
                Logger.log(Logger.INFO, RESOURCES, "Launcher.ReloadRequestReceived", (Object)(host + prefix));
                HostConfiguration hostConfig = this.hostGroup.getHostByName(host);
                hostConfig.reloadWebApp(prefix);
            }
        }
        finally {
            if (inControl != null) {
                try {
                    inControl.close();
                }
                catch (IOException iOException) {}
            }
            if (inSocket != null) {
                try {
                    inSocket.close();
                }
                catch (IOException iOException) {}
            }
            if (outSocket != null) {
                try {
                    outSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void shutdown() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            Logger.log(Logger.INFO, RESOURCES, "Launcher.FailedShutdown", e);
        }
        if (this.controlThread != null) {
            this.controlThread.interrupt();
        }
        Thread.yield();
        Logger.log(Logger.INFO, RESOURCES, "Launcher.ShutdownOK");
    }

    public boolean isRunning() {
        return this.controlThread != null && this.controlThread.isAlive();
    }

    public static void main(String[] argv) throws IOException {
        for (Handler h : java.util.logging.Logger.getLogger("").getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            ((ConsoleHandler)h).setFormatter(new SupportLogFormatter());
        }
        Log.setLog(new JavaUtilLog());
        Map args = Launcher.getArgsFromCommandLine(argv);
        if (Option.USAGE.isIn(args) || Option.HELP.isIn(args)) {
            Launcher.printUsage();
            return;
        }
        Launcher.deployEmbeddedWarfile(args);
        if (!(Option.WEBROOT.isIn(args) || Option.WARFILE.isIn(args) || Option.WEBAPPS_DIR.isIn(args))) {
            Launcher.printUsage();
            return;
        }
        try {
            new Launcher(args);
        }
        catch (Throwable err) {
            err.printStackTrace();
            Logger.log(Logger.ERROR, RESOURCES, "Launcher.ContainerStartupError", err);
            System.exit(1);
        }
    }

    public static Map getArgsFromCommandLine(String[] argv) throws IOException {
        File webapp;
        Map<String, String> args = new CmdLineParser(Option.all(Option.class)).parse(argv, "nonSwitch");
        String firstNonSwitchArgument = args.get("nonSwitch");
        args.remove("nonSwitch");
        if (firstNonSwitchArgument != null && (webapp = new File(firstNonSwitchArgument)).exists()) {
            if (webapp.isDirectory()) {
                args.put(Option.WEBROOT.name, firstNonSwitchArgument);
            } else if (webapp.isFile()) {
                args.put(Option.WARFILE.name, firstNonSwitchArgument);
            }
        }
        return args;
    }

    protected static void deployEmbeddedWarfile(Map args) throws IOException {
        String embeddedWarfileName = RESOURCES.getString("Launcher.EmbeddedWarFile");
        InputStream embeddedWarfile = Launcher.class.getResourceAsStream(embeddedWarfileName);
        if (embeddedWarfile != null) {
            int read;
            File tempWarfile = File.createTempFile("embedded", ".war").getAbsoluteFile();
            tempWarfile.getParentFile().mkdirs();
            tempWarfile.deleteOnExit();
            String embeddedWebroot = RESOURCES.getString("Launcher.EmbeddedWebroot");
            File tempWebroot = new File(tempWarfile.getParentFile(), embeddedWebroot);
            tempWebroot.mkdirs();
            Logger.log(Logger.DEBUG, RESOURCES, "Launcher.CopyingEmbeddedWarfile", (Object)tempWarfile.getAbsolutePath());
            FileOutputStream out = new FileOutputStream(tempWarfile, true);
            byte[] buffer = new byte[2048];
            while ((read = embeddedWarfile.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
            ((OutputStream)out).close();
            embeddedWarfile.close();
            Option.WARFILE.put(args, tempWarfile.getAbsolutePath());
            Option.WARFILE.put(args, tempWebroot.getAbsolutePath());
            Option.WEBAPPS_DIR.remove(args);
        }
    }

    public static void initLogger(Map args) throws IOException {
        int logLevel = Option.intArg(args, Option.DEBUG.name, Logger.INFO.intValue());
        boolean showThrowingLineNo = Option.LOG_THROWING_LINE_NO.get(args);
        boolean showThrowingThread = Option.LOG_THROWING_THREAD.get(args);
        OutputStream logStream = args.get("logfile") != null ? new FileOutputStream((String)args.get("logfile")) : (Option.booleanArg(args, "logToStdErr", false) ? System.err : System.out);
        Logger.init(Level.parse(String.valueOf(logLevel)), logStream, showThrowingThread);
    }

    protected static void printUsage() {
        String usage = USAGE;
        String header = RESOURCES.getString("Launcher.UsageInstructions.Header", RESOURCES.getString("ServerVersion"));
        String options = RESOURCES.getString("Launcher.UsageInstructions.Options");
        String footer = RESOURCES.getString("Launcher.UsageInstructions.Options");
        usage = usage == null ? header + options + footer : usage.replace("{HEADER}", header).replace("{OPTIONS}", options).replace("{FOOTER}", footer);
        System.out.println(usage);
    }
}

