/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import winstone.ConnectorFactory;
import winstone.ServerConnectorBuilder;
import winstone.cmdline.Option;

public class HttpConnectorFactory
implements ConnectorFactory {
    @Override
    public Connector start(Map args, Server server) throws IOException {
        int listenPort = Option.HTTP_PORT.get(args);
        if (listenPort < 0) {
            return null;
        }
        ServerConnectorBuilder scb = new ServerConnectorBuilder().withServer(server).withAcceptors(Option.JETTY_ACCEPTORS.get(args)).withSelectors(Option.JETTY_SELECTORS.get(args)).withListenerPort(listenPort).withSecureListenerPort(Option.HTTPS_PORT.get(args, -1)).withListenerAddress(Option.HTTP_LISTEN_ADDRESS.get(args)).withRequestHeaderSize(Option.REQUEST_HEADER_SIZE.get(args)).withKeepAliveTimeout(Option.HTTP_KEEP_ALIVE_TIMEOUT.get(args));
        ServerConnector connector = scb.build();
        server.addConnector(connector);
        return connector;
    }
}

