/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.http2.BufferingFlowControlStrategy;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.HTTP2ServerSession;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.LifeCycle;

@ManagedObject
public abstract class AbstractHTTP2ServerConnectionFactory
extends AbstractConnectionFactory {
    private final Connection.Listener connectionListener = new ConnectionListener();
    private final HttpConfiguration httpConfiguration;
    private int maxDynamicTableSize = 4096;
    private int initialSessionRecvWindow = 0x100000;
    private int initialStreamRecvWindow = 524288;
    private int maxConcurrentStreams = 128;
    private int maxHeaderBlockFragment = 0;
    private FlowControlStrategy.Factory flowControlStrategyFactory = () -> new BufferingFlowControlStrategy(0.5f);
    private long streamIdleTimeout;

    public AbstractHTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        this(httpConfiguration, "h2");
    }

    protected AbstractHTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration, String ... protocols) {
        super(protocols);
        for (String p : protocols) {
            if (HTTP2ServerConnection.isSupportedProtocol(p)) continue;
            throw new IllegalArgumentException("Unsupported HTTP2 Protocol variant: " + p);
        }
        this.httpConfiguration = Objects.requireNonNull(httpConfiguration);
        this.addBean(httpConfiguration);
        this.setInputBufferSize(16393);
    }

    @ManagedAttribute(value="The HPACK dynamic table maximum size")
    public int getMaxDynamicTableSize() {
        return this.maxDynamicTableSize;
    }

    public void setMaxDynamicTableSize(int maxDynamicTableSize) {
        this.maxDynamicTableSize = maxDynamicTableSize;
    }

    @ManagedAttribute(value="The initial size of session's flow control receive window")
    public int getInitialSessionRecvWindow() {
        return this.initialSessionRecvWindow;
    }

    public void setInitialSessionRecvWindow(int initialSessionRecvWindow) {
        this.initialSessionRecvWindow = initialSessionRecvWindow;
    }

    @ManagedAttribute(value="The initial size of stream's flow control receive window")
    public int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    public void setInitialStreamRecvWindow(int initialStreamRecvWindow) {
        this.initialStreamRecvWindow = initialStreamRecvWindow;
    }

    @ManagedAttribute(value="The max number of concurrent streams per session")
    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    @ManagedAttribute(value="The max header block fragment")
    public int getMaxHeaderBlockFragment() {
        return this.maxHeaderBlockFragment;
    }

    public void setMaxHeaderBlockFragment(int maxHeaderBlockFragment) {
        this.maxHeaderBlockFragment = maxHeaderBlockFragment;
    }

    public FlowControlStrategy.Factory getFlowControlStrategyFactory() {
        return this.flowControlStrategyFactory;
    }

    public void setFlowControlStrategyFactory(FlowControlStrategy.Factory flowControlStrategyFactory) {
        this.flowControlStrategyFactory = flowControlStrategyFactory;
    }

    @ManagedAttribute(value="The stream idle timeout in milliseconds")
    public long getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    public void setStreamIdleTimeout(long streamIdleTimeout) {
        this.streamIdleTimeout = streamIdleTimeout;
    }

    @Deprecated
    public int getReservedThreads() {
        return -1;
    }

    @Deprecated
    public void setReservedThreads(int threads) {
        throw new UnsupportedOperationException();
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    protected Map<Integer, Integer> newSettings() {
        HashMap<Integer, Integer> settings = new HashMap<Integer, Integer>();
        settings.put(1, this.getMaxDynamicTableSize());
        settings.put(4, this.getInitialStreamRecvWindow());
        int maxConcurrentStreams = this.getMaxConcurrentStreams();
        if (maxConcurrentStreams >= 0) {
            settings.put(3, maxConcurrentStreams);
        }
        settings.put(6, this.getHttpConfiguration().getRequestHeaderSize());
        return settings;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        ServerSessionListener listener = this.newSessionListener(connector, endPoint);
        Generator generator = new Generator(connector.getByteBufferPool(), this.getMaxDynamicTableSize(), this.getMaxHeaderBlockFragment());
        FlowControlStrategy flowControl = this.getFlowControlStrategyFactory().newFlowControlStrategy();
        HTTP2ServerSession session = new HTTP2ServerSession(connector.getScheduler(), endPoint, generator, listener, flowControl);
        session.setMaxLocalStreams(this.getMaxConcurrentStreams());
        session.setMaxRemoteStreams(this.getMaxConcurrentStreams());
        long streamIdleTimeout = this.getStreamIdleTimeout();
        if (streamIdleTimeout <= 0L) {
            streamIdleTimeout = endPoint.getIdleTimeout();
        }
        session.setStreamIdleTimeout(streamIdleTimeout);
        session.setInitialSessionRecvWindow(this.getInitialSessionRecvWindow());
        session.setWriteThreshold(this.getHttpConfiguration().getOutputBufferSize());
        ServerParser parser = this.newServerParser(connector, session);
        HTTP2ServerConnection connection = new HTTP2ServerConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, this.httpConfiguration, parser, session, this.getInputBufferSize(), listener);
        connection.addListener(this.connectionListener);
        return this.configure(connection, connector, endPoint);
    }

    protected abstract ServerSessionListener newSessionListener(Connector var1, EndPoint var2);

    protected ServerParser newServerParser(Connector connector, ServerParser.Listener listener) {
        return new ServerParser(connector.getByteBufferPool(), listener, this.getMaxDynamicTableSize(), this.getHttpConfiguration().getRequestHeaderSize());
    }

    private class ConnectionListener
    implements Connection.Listener {
        private ConnectionListener() {
        }

        @Override
        public void onOpened(Connection connection) {
            AbstractHTTP2ServerConnectionFactory.this.addManaged((LifeCycle)((Object)((HTTP2Connection)connection).getSession()));
        }

        @Override
        public void onClosed(Connection connection) {
            AbstractHTTP2ServerConnectionFactory.this.removeBean(((HTTP2Connection)connection).getSession());
        }
    }
}

