/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.server.ALPNServerConnection;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.NegotiatingServerConnectionFactory;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ALPNServerConnectionFactory
extends NegotiatingServerConnectionFactory {
    private static final Logger LOG = Log.getLogger(ALPNServerConnectionFactory.class);
    private final List<ALPNProcessor.Server> processors = new ArrayList<ALPNProcessor.Server>();

    public ALPNServerConnectionFactory(@Name(value="protocols") String protocols) {
        this(protocols.trim().split(",", 0));
    }

    public ALPNServerConnectionFactory(String ... protocols) {
        super("alpn", protocols);
        IllegalStateException failure = new IllegalStateException("No Server ALPNProcessors!");
        Iterator<ALPNProcessor.Server> i = ServiceLoader.load(ALPNProcessor.Server.class).iterator();
        while (i.hasNext()) {
            ALPNProcessor.Server processor;
            try {
                processor = i.next();
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(x);
                }
                failure.addSuppressed(x);
                continue;
            }
            try {
                processor.init();
                this.processors.add(processor);
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not initialize " + processor, x);
                }
                failure.addSuppressed(x);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("protocols: {}", Arrays.asList(protocols));
            LOG.debug("processors: {}", this.processors);
        }
        if (this.processors.isEmpty()) {
            throw failure;
        }
    }

    @Override
    protected AbstractConnection newServerConnection(Connector connector, EndPoint endPoint, SSLEngine engine, List<String> protocols, String defaultProtocol) {
        for (ALPNProcessor.Server processor : this.processors) {
            if (!processor.appliesTo(engine)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} for {} on {}", processor, engine, endPoint);
            }
            ALPNServerConnection connection = new ALPNServerConnection(connector, endPoint, engine, protocols, defaultProtocol);
            processor.configure(engine, connection);
            return connection;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("No ALPNProcessor: {} {}", engine, endPoint);
        }
        throw new IllegalStateException("Connection rejected: No ALPN Processor for " + engine.getClass().getName() + " from " + this.processors);
    }
}

