/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class BoundedExecutorService
extends AbstractExecutorService {
    private final List<Runnable> tasks = new LinkedList<Runnable>();
    private final ExecutorService base;
    private final int max;
    private int current;
    private boolean isShutdown = false;

    public BoundedExecutorService(ExecutorService base, int max) {
        this.base = base;
        this.max = max;
    }

    @Override
    public synchronized void execute(Runnable r) {
        if (this.isShutdown) {
            throw new RejectedExecutionException("already shut down");
        }
        this.tasks.add(r);
        if (this.current < this.max) {
            this.scheduleNext();
        }
    }

    private synchronized void scheduleNext() {
        if (this.tasks.isEmpty()) {
            if (this.isShutdown) {
                this.base.shutdown();
            }
            return;
        }
        final Runnable task = this.tasks.remove(0);
        this.base.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    task.run();
                }
                finally {
                    BoundedExecutorService.this.done();
                }
            }
        });
        ++this.current;
    }

    private synchronized void done() {
        --this.current;
        this.scheduleNext();
    }

    @Override
    public synchronized void shutdown() {
        this.isShutdown = true;
        if (this.tasks.isEmpty()) {
            this.base.shutdown();
        }
    }

    @Override
    public synchronized List<Runnable> shutdownNow() {
        this.isShutdown = true;
        List<Runnable> r = this.base.shutdownNow();
        r.addAll(this.tasks);
        this.tasks.clear();
        return r;
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.base.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.base.awaitTermination(timeout, unit);
    }
}

