/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.hpack.HpackDecoder;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class HeaderBlockParser {
    private final ByteBufferPool byteBufferPool;
    private final HpackDecoder hpackDecoder;
    private ByteBuffer blockBuffer;

    public HeaderBlockParser(ByteBufferPool byteBufferPool, HpackDecoder hpackDecoder) {
        this.byteBufferPool = byteBufferPool;
        this.hpackDecoder = hpackDecoder;
    }

    public MetaData parse(ByteBuffer buffer, int blockLength) {
        ByteBuffer toDecode;
        int accumulated = this.blockBuffer == null ? 0 : this.blockBuffer.position();
        int remaining = blockLength - accumulated;
        if (buffer.remaining() < remaining) {
            if (this.blockBuffer == null) {
                this.blockBuffer = this.byteBufferPool.acquire(blockLength, false);
                BufferUtil.clearToFill(this.blockBuffer);
            }
            this.blockBuffer.put(buffer);
            return null;
        }
        int limit = buffer.limit();
        buffer.limit(buffer.position() + remaining);
        if (this.blockBuffer != null) {
            this.blockBuffer.put(buffer);
            BufferUtil.flipToFlush(this.blockBuffer, 0);
            toDecode = this.blockBuffer;
        } else {
            toDecode = buffer;
        }
        MetaData result = this.hpackDecoder.decode(toDecode);
        buffer.limit(limit);
        if (this.blockBuffer != null) {
            this.byteBufferPool.release(this.blockBuffer);
            this.blockBuffer = null;
        }
        return result;
    }
}

