/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import java.util.EnumMap;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.spdy.CompressionFactory;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.ControlFrameType;
import org.eclipse.jetty.spdy.generator.ControlFrameGenerator;
import org.eclipse.jetty.spdy.generator.CredentialGenerator;
import org.eclipse.jetty.spdy.generator.DataFrameGenerator;
import org.eclipse.jetty.spdy.generator.GoAwayGenerator;
import org.eclipse.jetty.spdy.generator.HeadersBlockGenerator;
import org.eclipse.jetty.spdy.generator.HeadersGenerator;
import org.eclipse.jetty.spdy.generator.NoOpGenerator;
import org.eclipse.jetty.spdy.generator.PingGenerator;
import org.eclipse.jetty.spdy.generator.RstStreamGenerator;
import org.eclipse.jetty.spdy.generator.SettingsGenerator;
import org.eclipse.jetty.spdy.generator.SynReplyGenerator;
import org.eclipse.jetty.spdy.generator.SynStreamGenerator;
import org.eclipse.jetty.spdy.generator.WindowUpdateGenerator;

public class Generator {
    static final boolean useDirectBuffers = false;
    private final EnumMap<ControlFrameType, ControlFrameGenerator> generators = new EnumMap(ControlFrameType.class);
    private final DataFrameGenerator dataFrameGenerator;

    public Generator(ByteBufferPool bufferPool, CompressionFactory.Compressor compressor) {
        HeadersBlockGenerator headersBlockGenerator = new HeadersBlockGenerator(compressor);
        this.generators.put(ControlFrameType.SYN_STREAM, new SynStreamGenerator(bufferPool, headersBlockGenerator));
        this.generators.put(ControlFrameType.SYN_REPLY, new SynReplyGenerator(bufferPool, headersBlockGenerator));
        this.generators.put(ControlFrameType.RST_STREAM, new RstStreamGenerator(bufferPool));
        this.generators.put(ControlFrameType.SETTINGS, new SettingsGenerator(bufferPool));
        this.generators.put(ControlFrameType.NOOP, new NoOpGenerator(bufferPool));
        this.generators.put(ControlFrameType.PING, new PingGenerator(bufferPool));
        this.generators.put(ControlFrameType.GO_AWAY, new GoAwayGenerator(bufferPool));
        this.generators.put(ControlFrameType.HEADERS, new HeadersGenerator(bufferPool, headersBlockGenerator));
        this.generators.put(ControlFrameType.WINDOW_UPDATE, new WindowUpdateGenerator(bufferPool));
        this.generators.put(ControlFrameType.CREDENTIAL, new CredentialGenerator(bufferPool));
        this.dataFrameGenerator = new DataFrameGenerator(bufferPool);
    }

    public ByteBuffer control(ControlFrame frame) {
        ControlFrameGenerator generator = this.generators.get((Object)frame.getType());
        return generator.generate(frame);
    }

    public ByteBuffer data(int streamId, int length, DataInfo dataInfo) {
        return this.dataFrameGenerator.generate(streamId, length, dataInfo);
    }
}

