/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPrivateKeySpec;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.CertAndKeyGen;
import sun.security.x509.X500Name;
import winstone.ConnectorFactory;
import winstone.Logger;
import winstone.WinstoneException;
import winstone.WinstoneResourceBundle;
import winstone.cmdline.Option;

public class HttpsConnectorFactory
implements ConnectorFactory {
    private static final WinstoneResourceBundle SSL_RESOURCES = new WinstoneResourceBundle("winstone.LocalStrings");
    private KeyStore keystore;
    private String keystorePassword;

    public boolean start(Map args, Server server) throws IOException {
        int listenPort = Option.HTTPS_PORT.get(args);
        String listenAddress = Option.HTTPS_LISTEN_ADDRESS.get(args);
        int keepAliveTimeout = Option.HTTPS_KEEP_ALIVE_TIMEOUT.get(args);
        if (listenPort < 0) {
            return false;
        }
        try {
            File opensslCert = Option.HTTPS_CERTIFICATE.get(args);
            File opensslKey = Option.HTTPS_PRIVATE_KEY.get(args);
            File keyStore = Option.HTTPS_KEY_STORE.get(args);
            String pwd = Option.HTTPS_KEY_STORE_PASSWORD.get(args);
            if (opensslCert != null ^ opensslKey != null) {
                throw new WinstoneException(MessageFormat.format("--{0} and --{1} need to be used together", Option.HTTPS_CERTIFICATE, Option.HTTPS_PRIVATE_KEY));
            }
            if (keyStore != null && opensslKey != null) {
                throw new WinstoneException(MessageFormat.format("--{0} and --{1} are mutually exclusive", Option.HTTPS_KEY_STORE, Option.HTTPS_PRIVATE_KEY));
            }
            if (keyStore != null) {
                if (!keyStore.exists() || !keyStore.isFile()) {
                    throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.KeyStoreNotFound", keyStore.getPath()));
                }
                this.keystorePassword = pwd;
                this.keystore = KeyStore.getInstance("JKS");
                this.keystore.load(new FileInputStream(keyStore), this.keystorePassword.toCharArray());
            } else if (opensslCert != null) {
                CertificateFactory cf = CertificateFactory.getInstance("X509");
                Certificate cert = cf.generateCertificate(new FileInputStream(opensslCert));
                PrivateKey key = HttpsConnectorFactory.readPEMRSAPrivateKey(new FileReader(opensslKey));
                this.keystorePassword = "changeit";
                this.keystore = KeyStore.getInstance("JKS");
                this.keystore.load(null);
                this.keystore.setKeyEntry("hudson", key, this.keystorePassword.toCharArray(), new Certificate[]{cert});
            } else {
                this.keystorePassword = "changeit";
                System.out.println("Using one-time self-signed certificate");
                CertAndKeyGen ckg = new CertAndKeyGen("RSA", "SHA1WithRSA", null);
                ckg.generate(1024);
                PrivateKey privKey = ckg.getPrivateKey();
                X500Name xn = new X500Name("Test site", "Unknown", "Unknown", "Unknown");
                X509Certificate cert = ckg.getSelfCertificate(xn, 315360000L);
                this.keystore = KeyStore.getInstance("JKS");
                this.keystore.load(null);
                this.keystore.setKeyEntry("hudson", privKey, this.keystorePassword.toCharArray(), new Certificate[]{cert});
            }
        }
        catch (GeneralSecurityException e) {
            throw (IOException)new IOException("Failed to handle keys").initCause(e);
        }
        ServerConnector connector = this.createConnector(server, args);
        connector.setPort(listenPort);
        connector.setHost(listenAddress);
        connector.setIdleTimeout(keepAliveTimeout);
        HttpConfiguration config = connector.getConnectionFactory(HttpConnectionFactory.class).getHttpConfiguration();
        config.addCustomizer(new ForwardedRequestCustomizer());
        config.setRequestHeaderSize(Option.REQUEST_HEADER_SIZE.get(args));
        server.addConnector(connector);
        return true;
    }

    private ServerConnector createConnector(Server server, Map args) {
        SslContextFactory sslcf = this.getSSLContext(args);
        if (Option.HTTPS_SPDY.get(args)) {
            try {
                sslcf.setIncludeProtocols("TLSv1");
                return (ServerConnector)Class.forName("org.eclipse.jetty.spdy.server.http.HTTPSPDYServerConnector").getConstructor(Server.class, SslContextFactory.class).newInstance(server, sslcf);
            }
            catch (NoClassDefFoundError e) {
                if (e.getMessage().contains("org/eclipse/jetty/npn")) {
                    throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.MissingNPN"), e);
                }
                throw e;
            }
            catch (Exception e) {
                throw new Error("Failed to enable SPDY connector", e);
            }
        }
        return new ServerConnector(server, sslcf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPEMRSAPrivateKey(Reader reader) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String line;
            BufferedReader r = new BufferedReader(reader);
            boolean in = false;
            while ((line = r.readLine()) != null) {
                if (line.startsWith("-----")) {
                    in = !in;
                    continue;
                }
                if (!in) continue;
                baos.write(B64Code.decode(line));
            }
        }
        finally {
            reader.close();
        }
        DerInputStream dis = new DerInputStream(baos.toByteArray());
        DerValue[] seq = dis.getSequence(0);
        BigInteger mod = seq[1].getBigInteger();
        BigInteger privExpo = seq[3].getBigInteger();
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(new RSAPrivateKeySpec(mod, privExpo));
    }

    SslContextFactory getSSLContext(Map args) {
        try {
            String privateKeyPassword = Option.HTTPS_PRIVATE_KEY_PASSWORD.get(args, this.keystorePassword);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(Option.HTTPS_KEY_MANAGER_TYPE.get(args));
            kmf.init(this.keystore, this.keystorePassword.toCharArray());
            Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyCount", (Object)(this.keystore.size() + ""));
            Enumeration<String> e = this.keystore.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                Logger.log(Logger.FULL_DEBUG, SSL_RESOURCES, "HttpsListener.KeyFound", alias, this.keystore.getCertificate(alias) + "");
            }
            SslContextFactory ssl = new SslContextFactory();
            ssl.setKeyStore(this.keystore);
            ssl.setKeyStorePassword(this.keystorePassword);
            ssl.setKeyManagerPassword(privateKeyPassword);
            ssl.setSslKeyManagerFactoryAlgorithm(Option.HTTPS_KEY_MANAGER_TYPE.get(args));
            ssl.setCertAlias(Option.HTTPS_CERTIFICATE_ALIAS.get(args));
            ssl.setExcludeProtocols("SSLv3", "SSLv2", "SSLv2Hello");
            ssl.setNeedClientAuth(Option.HTTPS_VERIFY_CLIENT.get(args));
            return ssl;
        }
        catch (Throwable err) {
            throw new WinstoneException(SSL_RESOURCES.getString("HttpsListener.ErrorGettingContext"), err);
        }
    }
}

