/*
 * Decompiled with CFR 0.152.
 */
package winstone.cmdline;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import winstone.realm.ArgumentsRealm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Option<T> {
    public static final OFile WEBROOT = Option.file("webroot");
    public static final OFile WARFILE = Option.file("warfile");
    public static final OFile WEBAPPS_DIR = Option.file("webappsDir");
    public static final OFile JAVA_HOME = Option.file("javaHome");
    public static final OFile TOOLS_JAR = Option.file("toolsJar");
    public static final OFile CONFIG = Option.file("config");
    public static final OString PREFIX = Option.string("prefix", "");
    public static final OFile COMMON_LIB_FOLDER = Option.file("commonLibFolder");
    public static final OFile LOGFILE = Option.file("logfile");
    public static final OBoolean LOG_THROWING_LINE_NO = Option.bool("logThrowingLineNo", false);
    public static final OBoolean LOG_THROWING_THREAD = Option.bool("logThrowingThread", false);
    public static final OBoolean DEBUG = Option.bool("debug", false);
    public static final OInt _PORT = Option.integer("Port");
    public static final OString _LISTEN_ADDRESS = Option.string("ListenAddress");
    public static final OBoolean _DO_HOSTNAME_LOOKUPS = Option.bool("DoHostnameLookups", false);
    public static final OInt _KEEP_ALIVE_TIMEOUT = Option.integer("KeepAliveTimeout", 5000);
    public static final OInt HTTP_PORT = Option.integer("http" + _PORT, 8080);
    public static final OString HTTP_LISTEN_ADDRESS = Option.string("http" + _LISTEN_ADDRESS);
    public static final OBoolean HTTP_DO_HOSTNAME_LOOKUPS = Option.bool("http" + _DO_HOSTNAME_LOOKUPS, false);
    public static final OInt HTTP_KEEP_ALIVE_TIMEOUT = Option.integer("http" + _KEEP_ALIVE_TIMEOUT, (Integer)Option._KEEP_ALIVE_TIMEOUT.defaultValue);
    public static final OInt HTTPS_PORT = Option.integer("https" + _PORT, -1);
    public static final OString HTTPS_LISTEN_ADDRESS = Option.string("https" + _LISTEN_ADDRESS);
    public static final OBoolean HTTPS_DO_HOSTNAME_LOOKUPS = Option.bool("https" + _DO_HOSTNAME_LOOKUPS, false);
    public static final OInt HTTPS_KEEP_ALIVE_TIMEOUT = Option.integer("https" + _KEEP_ALIVE_TIMEOUT, (Integer)Option._KEEP_ALIVE_TIMEOUT.defaultValue);
    public static final OFile HTTPS_KEY_STORE = Option.file("httpsKeyStore");
    public static final OString HTTPS_KEY_STORE_PASSWORD = Option.string("httpsKeyStorePassword");
    public static final OString HTTPS_PRIVATE_KEY_PASSWORD = Option.string("httpsPrivateKeyPassword");
    public static final OString HTTPS_KEY_MANAGER_TYPE = Option.string("httpsKeyManagerType", "SunX509");
    public static final OBoolean HTTPS_VERIFY_CLIENT = Option.bool("httpsVerifyClient", false);
    public static final OFile HTTPS_CERTIFICATE = Option.file("httpsCertificate");
    public static final OString HTTPS_CERTIFICATE_ALIAS = Option.string("httpsCertificateAlias");
    public static final OFile HTTPS_PRIVATE_KEY = Option.file("httpsPrivateKey");
    public static final OBoolean HTTPS_SPDY = Option.bool("spdy", false);
    public static final OInt AJP13_PORT = Option.integer("ajp13" + _PORT, -1);
    public static final OString AJP13_LISTEN_ADDRESS = Option.string("ajp13" + _LISTEN_ADDRESS);
    public static final OInt CONTROL_PORT = Option.integer("controlPort", -1);
    public static final OInt HANDLER_COUNT_STARTUP = Option.integer("handlerCountStartup", 5);
    public static final OInt HANDLER_COUNT_MAX = Option.integer("handlerCountMax", 40);
    public static final OInt HANDLER_COUNT_MAX_IDLE = Option.integer("handlerCountMaxIdle", 5);
    public static final OBoolean DIRECTORY_LISTINGS = Option.bool("directoryListings", true);
    public static final OBoolean USE_JASPER = Option.bool("useJasper", false);
    public static final OBoolean USE_SERVLET_RELOADING = Option.bool("useServletReloading", false);
    public static final OClass PREFERRED_CLASS_LOADER = Option.clazz("preferredClassLoader", Object.class);
    public static final OBoolean USE_INVOKER = Option.bool("useInvoker", false);
    public static final OString INVOKER_PREFIX = Option.string("invokerPrefix", "/servlet/");
    public static final OBoolean SIMULATE_MOD_UNIQUE_ID = Option.bool("simulateModUniqueId", false);
    public static final OBoolean USE_SAVED_SESSIONS = Option.bool("useSavedSessions", false);
    public static final OString MIME_TYPES = Option.string("mimeTypes");
    public static final OInt MAX_PARAM_COUNT = Option.integer("maxParamCount", -1);
    public static final OBoolean USAGE = Option.bool("usage", false);
    public static final OInt SESSION_TIMEOUT = Option.integer("sessionTimeout", -1);
    public static final OInt REQUEST_HEADER_SIZE = Option.integer("requestHeaderSize", 8192);
    public static final OInt REQUEST_BUFFER_SIZE = Option.integer("requestBufferSize", 16384);
    public static final OInt REQUEST_FORM_CONTENT_SIZE = Option.integer("requestFormContentSize", -1);
    public static final OBoolean HELP = Option.bool("help", false);
    public static final OClass REALM_CLASS_NAME = Option.clazz("realmClassName", ArgumentsRealm.class);
    public static final OString ARGUMENTS_REALM_PASSWORD = Option.string("argumentsRealm.passwd.");
    public static final OString ARGUMENTS_REALM_ROLES = Option.string("argumentsRealm.roles.");
    public static final OFile FILEREALM_CONFIGFILE = Option.file("fileRealm.configFile");
    public static final OClass ACCESS_LOGGER_CLASSNAME = Option.clazz("accessLoggerClassName", null);
    public static final OString SIMPLE_ACCESS_LOGGER_FORMAT = Option.string("simpleAccessLogger.format", "combined");
    public static final OString SIMPLE_ACCESS_LOGGER_FILE = Option.string("simpleAccessLogger.file", "logs/###host###/###webapp###_access.log");
    public final String name;
    public final Class<T> type;
    public final T defaultValue;

    public static List<Option<?>> all(Class<?> clazz) {
        ArrayList r = new ArrayList();
        for (Field f : clazz.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Option.class.isAssignableFrom(f.getType())) continue;
            try {
                r.add((Option)f.get(null));
            }
            catch (IllegalAccessException e) {
                throw (Error)new IllegalAccessError().initCause(e);
            }
        }
        return r;
    }

    public Option(String name, Class<T> type, T defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public void remove(Map args) {
        args.remove(this.name);
    }

    public void put(Map args, String value) {
        args.put(this.name, value);
    }

    public boolean isIn(Map args) {
        return args.containsKey(this.name);
    }

    public boolean isWildcard() {
        return this.name.endsWith(".");
    }

    public String toString() {
        return this.name;
    }

    public static OString string(String name) {
        return new OString(name, null);
    }

    public static OString string(String name, String defaultValue) {
        return new OString(name, defaultValue);
    }

    public static OBoolean bool(String name, boolean defaultValue) {
        return new OBoolean(name, defaultValue);
    }

    public static OFile file(String name) {
        return new OFile(name);
    }

    public static OClass clazz(String name, Class defaultValue) {
        return new OClass(name, defaultValue);
    }

    public static OInt integer(String name) {
        return new OInt(name, -1);
    }

    public static OInt integer(String name, int defaultValue) {
        return new OInt(name, defaultValue);
    }

    public static boolean booleanArg(Map args, String name, boolean defaultTrue) {
        String value = (String)args.get(name);
        if (defaultTrue) {
            return value == null || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
        }
        return value != null && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes"));
    }

    public static String stringArg(Map args, String name, String defaultValue) {
        return args.get(name) == null ? defaultValue : args.get(name);
    }

    public static int intArg(Map args, String name, int defaultValue) {
        return Integer.parseInt(Option.stringArg(args, name, "" + defaultValue));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OClass
    extends Option<Class> {
        public OClass(String name, Class defaultValue) {
            super(name, Class.class, defaultValue);
        }

        public <T> Class<? extends T> get(Map args, Class<T> expectedType) throws ClassNotFoundException {
            return this.get(args, expectedType, this.getClass().getClassLoader());
        }

        public <T> Class<? extends T> get(Map args, Class<T> expectedType, ClassLoader cl) throws ClassNotFoundException {
            String v = (String)args.get(this.name);
            if (v == null) {
                return (Class)this.defaultValue;
            }
            if ((v = v.trim()).length() == 0) {
                return (Class)this.defaultValue;
            }
            Class<?> c = Class.forName(v, true, cl);
            if (!expectedType.isAssignableFrom(c)) {
                throw new ClassNotFoundException("Expected a subype of " + expectedType + " but got " + c + " instead");
            }
            return c.asSubclass(expectedType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OFile
    extends Option<File> {
        public OFile(String name) {
            super(name, File.class, null);
        }

        public File get(Map args, File defaultValue) {
            String v = (String)args.get(this.name);
            return v != null ? new File(v) : defaultValue;
        }

        public File get(Map args) {
            return this.get(args, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OString
    extends Option<String> {
        public OString(String name, String defaultValue) {
            super(name, String.class, defaultValue);
        }

        public String get(Map args) {
            return this.get(args, (String)this.defaultValue);
        }

        public char[] getCharArray(Map args) {
            String v = this.get(args);
            return v != null ? v.toCharArray() : null;
        }

        public String get(Map args, String defaultValue) {
            String v = (String)args.get(this.name);
            return v != null ? v : defaultValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OInt
    extends Option<Integer> {
        public OInt(String name, int defaultValue) {
            super(name, Integer.class, defaultValue);
        }

        public int get(Map args) {
            return OInt.intArg(args, this.name, (Integer)this.defaultValue);
        }

        public int get(Map args, int defaultValue) {
            return OInt.intArg(args, this.name, defaultValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OBoolean
    extends Option<Boolean> {
        public OBoolean(String name, boolean defaultValue) {
            super(name, Boolean.class, defaultValue);
        }

        public boolean get(Map args) {
            return this.get(args, (Boolean)this.defaultValue);
        }

        public boolean get(Map args, boolean defaultValue) {
            return OBoolean.booleanArg(args, this.name, defaultValue);
        }
    }
}

