/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.api;

import org.eclipse.jetty.spdy.api.Headers;

public class HeadersInfo {
    public static final byte FLAG_CLOSE = 1;
    public static final byte FLAG_RESET_COMPRESSION = 2;
    private final boolean close;
    private final boolean resetCompression;
    private final Headers headers;

    public HeadersInfo(Headers headers, boolean close) {
        this(headers, close, false);
    }

    public HeadersInfo(Headers headers, boolean close, boolean resetCompression) {
        this.headers = headers;
        this.close = close;
        this.resetCompression = resetCompression;
    }

    public boolean isClose() {
        return this.close;
    }

    public boolean isResetCompression() {
        return this.resetCompression;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public byte getFlags() {
        byte flags = this.isClose() ? (byte)1 : 0;
        flags = (byte)(flags + (this.isResetCompression() ? 2 : 0));
        return flags;
    }

    public String toString() {
        return String.format("HEADER close=%b %s", this.close, this.headers);
    }
}

