/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.util.Locale;
import java.util.StringTokenizer;

public class VersionNumber
implements Comparable<VersionNumber> {
    private final int[] digits;

    public VersionNumber(String num) throws IllegalArgumentException {
        StringTokenizer tokens = new StringTokenizer(num, ".-");
        this.digits = new int[tokens.countTokens()];
        if (this.digits.length < 2) {
            throw new IllegalArgumentException("Failed to parse " + num + " as version number");
        }
        int i = 0;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().toLowerCase(Locale.ENGLISH);
            if (token.equals("*")) {
                this.digits[i++] = 1000;
                continue;
            }
            if (token.startsWith("snapshot")) {
                int n = i - 1;
                this.digits[n] = this.digits[n] - 1;
                this.digits[i++] = 1000;
                break;
            }
            int n = 0;
            try {
                n = Integer.parseInt(token);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.digits[i++] = n;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.digits.length; ++i) {
            if (i != 0) {
                buf.append('.');
            }
            buf.append(Integer.toString(this.digits[i]));
        }
        return buf.toString();
    }

    public boolean isOlderThan(VersionNumber rhs) {
        return this.compareTo(rhs) < 0;
    }

    public boolean isNewerThan(VersionNumber rhs) {
        return this.compareTo(rhs) > 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VersionNumber)) {
            return false;
        }
        return this.compareTo((VersionNumber)o) == 0;
    }

    public int hashCode() {
        int x = 0;
        for (int i : this.digits) {
            x = x << 1 | i;
        }
        return x;
    }

    @Override
    public int compareTo(VersionNumber rhs) {
        int i = 0;
        while (i != this.digits.length || i != rhs.digits.length) {
            if (i == this.digits.length) {
                return -1;
            }
            if (i == rhs.digits.length) {
                return 1;
            }
            int r = this.digits[i] - rhs.digits[i];
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return 0;
    }
}

