/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.IOException;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.jenkinsci.maven.plugins.hpi.AbstractHpiMojo;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JarMojo
extends AbstractHpiMojo {
    @Parameter(defaultValue="${project.build.finalName}")
    private String hpiName;
    @Parameter(defaultValue="")
    private String jarClassifier;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    protected File getOutputFile(String extension) {
        return new File(new File(this.outputDirectory), this.hpiName + extension);
    }

    public void execute() throws MojoExecutionException {
        try {
            this.performPackaging();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error assembling jar: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Error assembling jar", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error assembling jar", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error assembling jar: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    private void performPackaging() throws IOException, ArchiverException, ManifestException, DependencyResolutionRequiredException, MojoExecutionException {
        File manifestFile = new File(this.getWebappDirectory(), "META-INF/MANIFEST.MF");
        this.generateManifest(this.archive, manifestFile);
        Manifest manifest = this.loadManifest(manifestFile);
        File jarFile = this.getOutputFile(".jar");
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(jarFile);
        this.jarArchiver.addConfiguredManifest(manifest);
        this.jarArchiver.addDirectory(this.getClassesDirectory());
        archiver.createArchive(this.project, this.archive);
        this.projectHelper.attachArtifact(this.project, "jar", this.jarClassifier, jarFile);
    }
}

