/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.codehaus.plexus.util.FileUtils;
import org.jenkinsci.maven.plugins.hpi.AbstractJenkinsMojo;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;

@Mojo(name="bundle-plugins", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, threadSafe=true)
public class BundlePluginsMojo
extends AbstractJenkinsMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}/WEB-INF/plugins/")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}/WEB-INF/optional-plugins/")
    private File optionalOutputDirectory;
    @Parameter(property="hpi.ignoreOptionalDependencyConflicts")
    private boolean ignoreOptionalDependencyConflicts;
    @Component
    protected ArtifactResolver resolver;
    @Component
    protected ArtifactCollector artifactCollector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        LinkedHashSet<String> badDependencies = new LinkedHashSet<String>();
        for (Artifact a : this.project.getDependencyArtifacts()) {
            try {
                if (!StringUtils.isBlank((String)a.getType()) && (!StringUtils.equals((String)"jar", (String)a.getType()) || !this.wrap(a).isPlugin())) continue;
                String gav = String.format("%s:%s:%s", a.getGroupId(), a.getArtifactId(), a.getVersion());
                this.getLog().error((CharSequence)String.format("Dependency on plugin %s does not include <type> tag", gav));
                badDependencies.add(gav);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to check plugin dependencies", (Exception)e);
            }
        }
        if (!badDependencies.isEmpty()) {
            throw new MojoFailureException("The following plugin dependencies are missing the <type> tag required by the bundle-plugins goal:\n  " + StringUtils.join(badDependencies, (String)"\n  "));
        }
        TypeFilter typeFilter = new TypeFilter("hpi,jpi", null);
        Set artifacts = typeFilter.filter(this.project.getDependencyArtifacts());
        artifacts = typeFilter.filter(artifacts);
        Set nonOptionalArtifacts = new OptionalFilter(false).filter(artifacts);
        try {
            ArtifactResolutionResult r = this.resolver.resolveTransitively(artifacts, this.project.getArtifact(), this.remoteRepos, this.localRepository, this.artifactMetadataSource);
            ArtifactResolutionResult noR = this.resolver.resolveTransitively(nonOptionalArtifacts, this.project.getArtifact(), this.remoteRepos, this.localRepository, this.artifactMetadataSource);
            ArrayList<MavenArtifact> hpis = new ArrayList<MavenArtifact>();
            HashMap<String, MavenArtifact> selected = new HashMap<String, MavenArtifact>();
            for (Object o : r.getArtifacts()) {
                MavenArtifact a = this.wrap((Artifact)o);
                if (!a.isPlugin()) continue;
                MavenArtifact cur = (MavenArtifact)selected.get(a.getArtifactId());
                if (cur != null) {
                    if (cur.getVersionNumber().compareTo((Object)a.getVersionNumber()) < 0) {
                        cur = a;
                    }
                } else {
                    cur = a;
                }
                selected.put(a.getArtifactId(), cur);
            }
            HashSet<String> nonOptional = new HashSet<String>();
            for (Object o : noR.getArtifacts()) {
                MavenArtifact a = this.wrap((Artifact)o);
                if (!a.isPlugin()) continue;
                nonOptional.add(o.getArtifactId());
                MavenArtifact cur = (MavenArtifact)selected.get(a.getArtifactId());
                if (cur != null) {
                    if (cur.getVersionNumber().compareTo((Object)a.getVersionNumber()) < 0) {
                        cur = a;
                    }
                } else {
                    cur = a;
                }
                selected.put(a.getArtifactId(), cur);
            }
            LinkedHashSet<String> optionalDependencyIssue = new LinkedHashSet<String>();
            for (MavenArtifact a : selected.values()) {
                try {
                    MavenProject pom = a.resolvePom();
                    for (Dependency d : pom.getDependencies()) {
                        if (!d.isOptional() || !selected.containsKey(d.getArtifactId())) continue;
                        MavenArtifact matching = (MavenArtifact)selected.get(d.getArtifactId());
                        if (!StringUtils.equals((String)d.getGroupId(), (String)matching.getGroupId()) || matching.getVersionNumber().compareTo((Object)new DefaultArtifactVersion(d.getVersion())) >= 0) continue;
                        String message = String.format("%s: optional dependency of %s version %s conflicts with the bundled version %s", a.getArtifactId(), d.getArtifactId(), d.getVersion(), matching.getVersion());
                        this.getLog().error((CharSequence)message);
                        optionalDependencyIssue.add(message);
                    }
                }
                catch (ProjectBuildingException e) {
                    this.getLog().warn((CharSequence)String.format("Could not resolve pom of %s:%s:%s to check optional dependencies", a.getGroupId(), a.getArtifactId(), a.getVersion()), (Throwable)e);
                }
            }
            if (!optionalDependencyIssue.isEmpty()) {
                if (this.ignoreOptionalDependencyConflicts) {
                    this.getLog().warn((CharSequence)"Ignoring optional dependency conflicts");
                } else {
                    throw new MojoFailureException("Optional dependencies are incompatible with bundled dependencies:\n  " + StringUtils.join(optionalDependencyIssue, (String)"\n  "));
                }
            }
            this.outputDirectory.mkdirs();
            if (!nonOptional.containsAll(selected.keySet())) {
                this.optionalOutputDirectory.mkdirs();
            }
            int artifactIdLength = "Artifact ID".length();
            int groupIdLength = "Group ID".length();
            int versionLength = "Version".length();
            for (MavenArtifact a : selected.values()) {
                MavenArtifact hpi = a.getHpi();
                this.getLog().debug((CharSequence)("Copying " + hpi.getFile()));
                FileUtils.copyFile((File)hpi.getFile(), (File)new File(nonOptional.contains(hpi.getArtifactId()) ? this.outputDirectory : this.optionalOutputDirectory, hpi.getArtifactId() + ".hpi"));
                hpis.add(hpi);
                artifactIdLength = Math.max(artifactIdLength, hpi.getArtifactId().length());
                groupIdLength = Math.max(groupIdLength, hpi.getGroupId().length());
                versionLength = Math.max(versionLength, hpi.getVersion().length());
            }
            Collections.sort(hpis, new Comparator<MavenArtifact>(){

                @Override
                public int compare(MavenArtifact o1, MavenArtifact o2) {
                    return this.map(o1).compareTo(this.map(o2));
                }

                private String map(MavenArtifact a) {
                    return a.getArtifactId();
                }
            });
            File list = new File(this.project.getBuild().getOutputDirectory(), "bundled-plugins.txt");
            File manifest = new File(this.project.getBuild().getDirectory(), "plugin-manifest.txt");
            list.getParentFile().mkdirs();
            PrintWriter w = new PrintWriter(list);
            PrintWriter m = new PrintWriter(manifest);
            try {
                String format = "%" + -artifactIdLength + "s %" + -versionLength + "s %-8s %" + -groupIdLength + "s";
                String format2 = "%" + -groupIdLength + "s %" + -artifactIdLength + "s %" + -versionLength + "s %-8s%n";
                this.getLog().info((CharSequence)String.format(format, "Artifact ID", "Version", "Optional", "Group ID"));
                m.printf(format2, "Group Id", "Artifact Id", "Version", "Optional");
                m.printf(format2, StringUtils.repeat((String)"=", (int)groupIdLength), StringUtils.repeat((String)"=", (int)artifactIdLength), StringUtils.repeat((String)"=", (int)versionLength), StringUtils.repeat((String)"=", (int)8));
                this.getLog().info((CharSequence)String.format(format, StringUtils.repeat((String)"=", (int)artifactIdLength), StringUtils.repeat((String)"=", (int)versionLength), StringUtils.repeat((String)"=", (int)8), StringUtils.repeat((String)"=", (int)groupIdLength)));
                for (MavenArtifact hpi : hpis) {
                    this.getLog().info((CharSequence)String.format(format, hpi.getArtifactId(), hpi.getVersion(), nonOptional.contains(hpi.getArtifactId()) ? "" : "optional", hpi.getGroupId()));
                    m.printf(format2, hpi.getGroupId(), hpi.getArtifactId(), hpi.getVersion(), nonOptional.contains(hpi.getArtifactId()) ? "no" : "yes");
                    w.println(hpi.getId());
                }
            }
            finally {
                IOUtils.closeQuietly((Writer)w);
                IOUtils.closeQuietly((Writer)m);
            }
            this.projectHelper.attachArtifact(this.project, "txt", "bundled-plugins", list);
            this.projectHelper.attachArtifact(this.project, "txt", "plugin-manifest", manifest);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to resolve plugin dependencies", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Failed to resolve plugin dependencies", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to resolve plugin dependencies", (Exception)e);
        }
    }

    private static class OptionalFilter
    extends AbstractArtifactsFilter {
        private final boolean optional;

        private OptionalFilter(boolean optional) {
            this.optional = optional;
        }

        public Set filter(Set artifacts) {
            LinkedHashSet<Artifact> result = new LinkedHashSet<Artifact>();
            for (Artifact a : artifacts) {
                if (this.optional != a.isOptional()) continue;
                result.add(a);
            }
            return result;
        }
    }
}

