/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.maven.plugins.hpi;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.jenkinsci.maven.plugins.hpi.MavenArtifact;
import org.jenkinsci.maven.plugins.hpi.VersionNumber;

public abstract class AbstractJenkinsMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter
    protected String jenkinsCoreId;
    @Parameter
    private String jenkinsCoreVersionOverride;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    protected List<ArtifactRepository> remoteRepos;
    @Component
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Component
    protected ArtifactMetadataSource artifactMetadataSource;
    @Component
    protected ArtifactFactory artifactFactory;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    protected MavenProjectBuilder projectBuilder;
    @Component
    protected MavenProjectHelper projectHelper;

    protected String findJenkinsVersion() throws MojoExecutionException {
        for (Dependency a : this.project.getDependencies()) {
            boolean match;
            if (this.jenkinsCoreId != null) {
                match = (a.getGroupId() + ':' + a.getArtifactId()).equals(this.jenkinsCoreId);
            } else {
                boolean bl = match = !(!a.getGroupId().equals("org.jenkins-ci.main") && !a.getGroupId().equals("org.jvnet.hudson.main") || !a.getArtifactId().equals("jenkins-core") && !a.getArtifactId().equals("hudson-core"));
            }
            if (!match) continue;
            if (StringUtils.isNotBlank((String)this.jenkinsCoreVersionOverride)) {
                VersionNumber v2;
                VersionNumber v1 = new VersionNumber(a.getVersion());
                if (v1.compareTo(v2 = new VersionNumber(this.jenkinsCoreVersionOverride)) == -1) {
                    return this.jenkinsCoreVersionOverride;
                }
                this.getLog().warn((CharSequence)("Ignoring 'jenkinsCoreVersionOverride' of " + this.jenkinsCoreVersionOverride + " as the autodetected version, " + a.getVersion() + ", is newer. Please remove the redundant version override."));
            }
            return a.getVersion();
        }
        if (StringUtils.isNotBlank((String)this.jenkinsCoreVersionOverride)) {
            return this.jenkinsCoreVersionOverride;
        }
        throw new MojoExecutionException("Failed to determine Jenkins version this plugin depends on.");
    }

    protected MavenArtifact wrap(Artifact a) {
        return new MavenArtifact(a, this.artifactResolver, this.artifactFactory, this.projectBuilder, this.remoteRepos, this.localRepository);
    }
}

