/*
 * Decompiled with CFR 0.152.
 */
package net.uaznia.lukanus.hudson.plugins.gitparameter.jobs;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.scm.SCM;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.uaznia.lukanus.hudson.plugins.gitparameter.jobs.AbstractJobWrapper;
import net.uaznia.lukanus.hudson.plugins.gitparameter.jobs.Messages;

public class WorkflowJobWrapper
extends AbstractJobWrapper {
    private static final Logger LOGGER = Logger.getLogger(WorkflowJobWrapper.class.getName());

    public WorkflowJobWrapper(Job job) {
        super(job);
    }

    @Override
    public List<SCM> getScms() {
        Collection<? extends SCM> scmsFromLastBuild;
        ArrayList<SCM> scms = new ArrayList<SCM>();
        SCM scmFromDefinition = this.getSCMFromDefinition();
        if (scmFromDefinition != null) {
            scms.add(scmFromDefinition);
        }
        if ((scmsFromLastBuild = this.getSCMsFromLastBuild()) != null && !scmsFromLastBuild.isEmpty()) {
            scms.addAll(scmsFromLastBuild);
        }
        return scms;
    }

    private Collection<? extends SCM> getSCMsFromLastBuild() {
        try {
            Object scms = this.invokeGetMethodFromJob("getSCMs");
            if (scms != null && scms instanceof Collection) {
                return (Collection)scms;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, this.getCustomJobName() + " " + Messages.WorkflowJobWrapper_GetWorkflowRepoScmFail(), e);
        }
        return null;
    }

    private SCM getSCMFromDefinition() {
        try {
            Object definition = this.invokeGetMethodFromJob("getDefinition");
            Class<?> cpsScmFlowDefinitionClazz = definition.getClass();
            if (this.isNotCpsScmFlowDefinitionClass(cpsScmFlowDefinitionClazz)) {
                return null;
            }
            Method getScmMethod = cpsScmFlowDefinitionClazz.getMethod("getScm", new Class[0]);
            Object scm = getScmMethod.invoke(definition, new Object[0]);
            if (scm instanceof SCM) {
                return (SCM)scm;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, this.getCustomJobName() + " " + Messages.WorkflowJobWrapper_GetWorkflowRepoScmFail(), e);
        }
        return null;
    }

    @Override
    public FilePath getSomeWorkspace() throws IOException, InterruptedException {
        FilePath workspaceForWorkflow = Jenkins.getInstance().getWorkspaceFor((TopLevelItem)this.getJob()).withSuffix("@script");
        if (workspaceForWorkflow.exists()) {
            return workspaceForWorkflow;
        }
        return null;
    }

    @Override
    public EnvVars getSomeBuildEnvironments() {
        try {
            Object lastBuild = this.invokeGetMethodFromJob("getLastBuild");
            if (lastBuild != null) {
                Class<?> workflowRunClazz = lastBuild.getClass();
                Method getEnvironmentMethod = workflowRunClazz.getMethod("getEnvironment", TaskListener.class);
                Object envVars = getEnvironmentMethod.invoke(lastBuild, TaskListener.NULL);
                if (envVars instanceof EnvVars) {
                    return (EnvVars)envVars;
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, this.getCustomJobName() + Messages.WorkflowJobWrapper_GetEnvironmentsFromWorkflowrun(), e);
        }
        return null;
    }

    private boolean isNotCpsScmFlowDefinitionClass(Class<?> clazz) {
        return !"org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition".equals(clazz.getName());
    }

    private Object invokeGetMethodFromJob(String methodInvoke) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> workflowJobClazz = this.getJob().getClass();
        Method getDefinitionMethod = workflowJobClazz.getDeclaredMethod(methodInvoke, new Class[0]);
        return getDefinitionMethod.invoke((Object)this.getJob(), new Object[0]);
    }
}

