/*
 * Decompiled with CFR 0.152.
 */
package net.uaznia.lukanus.hudson.plugins.gitparameter.scms;

import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.scm.SCM;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.Messages;
import net.uaznia.lukanus.hudson.plugins.gitparameter.scms.SCMWrapper;

public class RepoSCM
implements SCMWrapper {
    public static final String REPO_SCM_CLASS_NAME = "hudson.plugins.repo.RepoScm";
    private static final String REPO_SCM_NAME = "repo";
    private static final String REPO_MANIFESTS_DIR = ".repo/manifests";
    private static final Logger LOGGER = Logger.getLogger(RepoSCM.class.getName());
    private SCM scm;

    public RepoSCM(SCM scm) {
        this.scm = scm;
    }

    @Override
    public List<SCM> getSCMs() {
        try {
            Class<?> clazz = this.scm.getClass();
            Method method = clazz.getDeclaredMethod("getManifestRepositoryUrl", new Class[0]);
            String repositoryUrl = (String)method.invoke((Object)this.scm, new Object[0]);
            UserRemoteConfig config = new UserRemoteConfig(repositoryUrl, REPO_SCM_NAME, null, null);
            ArrayList<UserRemoteConfig> configs = new ArrayList<UserRemoteConfig>();
            configs.add(config);
            GitSCM gitSCM = new GitSCM(configs, null, Boolean.valueOf(false), null, null, null, null);
            return Collections.singletonList(gitSCM);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, Messages.RepoSCM_getRepoScmFailed(), e);
            return null;
        }
    }

    public static boolean isRepoSCM(String repositoryName) {
        return REPO_SCM_NAME.equals(repositoryName);
    }

    public static String getRepoMainfestsDir() {
        return REPO_MANIFESTS_DIR;
    }
}

