/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.zanata;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ZanataCliBuilder
extends Builder
implements SimpleBuildStep {
    private final String projFile;
    private final boolean syncG2zanata;
    private final boolean syncZ2git;

    @DataBoundConstructor
    public ZanataCliBuilder(String projFile, boolean syncG2zanata, boolean syncZ2git) {
        this.projFile = projFile;
        this.syncG2zanata = syncG2zanata;
        this.syncZ2git = syncZ2git;
    }

    public String getProjFile() {
        return this.projFile;
    }

    public boolean getSyncG2zanata() {
        return this.syncG2zanata;
    }

    public boolean getSyncZ2git() {
        return this.syncZ2git;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) {
        listener.getLogger().println("Running Zanata Sync, project file: " + this.projFile);
        if (this.syncG2zanata) {
            String commandG2Z = this.getDescriptor().getCommandG2Z();
            listener.getLogger().println("Git to Zanata sync is enabled, running command:");
            listener.getLogger().println(commandG2Z + "\n");
            if (this.runShellCommandInBuild(commandG2Z, listener, build, workspace)) {
                listener.getLogger().println("Git to Zanata sync finished.\n");
            }
        }
        if (this.syncZ2git) {
            String commandZ2G = this.getDescriptor().getCommandZ2G();
            listener.getLogger().println("Zanata to Git sync is enabled, running command:");
            listener.getLogger().println(commandZ2G + "\n");
            if (this.runShellCommandInBuild(commandZ2G, listener, build, workspace)) {
                listener.getLogger().println("Zanata to Git sync finished.\n");
            }
        }
    }

    private boolean runShellCommandInBuild(String command, TaskListener listener, Run<?, ?> builder, FilePath workspace) {
        try {
            String line2;
            Throwable throwable;
            BufferedReader in;
            EnvVars jenkinsEnvs = builder.getEnvironment(listener);
            Map<String, String> sysEnvs = System.getenv();
            HashMap<String, String> allEnvs = new HashMap<String, String>();
            allEnvs.putAll(sysEnvs);
            allEnvs.putAll((Map<String, String>)jenkinsEnvs);
            listener.getLogger().println("workspace: " + workspace.toURI());
            Process pg = Runtime.getRuntime().exec(new String[]{"bash", "-c", command}, ((Object)allEnvs).toString().split(", "), new File(workspace.toURI()));
            try {
                in = new BufferedReader(new InputStreamReader(pg.getInputStream(), "UTF8"));
                throwable = null;
                try {
                    line2 = null;
                    while ((line2 = in.readLine()) != null) {
                        System.out.println(line2);
                        listener.getLogger().println(line2);
                    }
                    in.close();
                }
                catch (Throwable line2) {
                    throwable = line2;
                    throw line2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable line2) {
                                throwable.addSuppressed(line2);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                listener.getLogger().println("Can't generate output of command:" + command);
                e.printStackTrace();
                return false;
            }
            try {
                in = new BufferedReader(new InputStreamReader(pg.getErrorStream(), "UTF8"));
                throwable = null;
                try {
                    line2 = null;
                    while ((line2 = in.readLine()) != null) {
                        System.out.println(line2);
                        listener.getLogger().println(line2);
                    }
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                listener.getLogger().println("Can't generate error message of command:" + command);
                e.printStackTrace();
                return false;
            }
            pg.waitFor();
            listener.getLogger().println("Run command return:  " + Integer.toString(pg.exitValue()));
        }
        catch (IOException e) {
            listener.getLogger().println("Can't run command:" + command);
            e.printStackTrace();
            return false;
        }
        catch (InterruptedException e) {
            listener.getLogger().println("Can't run command - InterruptedException.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String iniLocation;
        private String iniContents;
        private String commandG2Z;
        private String commandZ2G;

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckProjFile(@QueryParameter String value, @QueryParameter boolean syncG2zanata, @QueryParameter boolean syncZ2git) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a project name such as zanata.xml");
            }
            System.out.println("Project File is : " + value);
            System.out.println(syncG2zanata);
            System.out.println(syncZ2git);
            this.save();
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Zanata Localization Sync";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.iniLocation = formData.getString("iniLocation");
            this.iniContents = formData.getString("iniContents");
            this.commandG2Z = formData.getString("commandG2Z");
            this.commandZ2G = formData.getString("commandZ2G");
            String iniFullPath = System.getProperty("JENKINS_HOME") != null ? System.getProperty("JENKINS_HOME") + "/" + this.iniLocation : (System.getProperty("user.home") != null ? System.getProperty("user.home") + "/" + this.iniLocation : "/var/lib/jenkins/" + this.iniLocation);
            File file = new File(iniFullPath);
            try {
                if (!file.exists()) {
                    if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                        throw new IOException("Unable to create directory " + iniFullPath);
                    }
                    if (!file.createNewFile()) {
                        throw new IOException("Unable to create file " + iniFullPath);
                    }
                }
            }
            catch (IOException e) {
                System.out.println("File could not be created or opened: " + iniFullPath);
                e.printStackTrace();
            }
            if (file.exists()) {
                try (OutputStreamWriter fstream = new OutputStreamWriter((OutputStream)new FileOutputStream(iniFullPath), "UTF8");){
                    fstream.write(this.iniContents);
                    ((Writer)fstream).flush();
                    ((Writer)fstream).close();
                    System.out.println("File written Succesfully: " + iniFullPath);
                }
                catch (IOException e) {
                    System.out.println("File write NOT Succesfully: " + iniFullPath);
                    e.printStackTrace();
                }
            }
            this.save();
            return super.configure(req, formData);
        }

        public String getIniLocation() {
            return this.iniLocation;
        }

        public String getIniContents() {
            return this.iniContents;
        }

        public String getCommandG2Z() {
            return this.commandG2Z;
        }

        public String getCommandZ2G() {
            return this.commandZ2G;
        }
    }
}

