/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack.youtrackapi;

import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.youtrack.youtrackapi.Suggestion;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Issue {
    private String id;
    private String state;
    private String summary;
    private String resolved;
    private String description;

    public Issue(String id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Issue issue = (Issue)o;
        return !(this.id != null ? !this.id.equals(issue.id) : issue.id != null);
    }

    public String toString() {
        return "Issue{id='" + this.id + '\'' + '}';
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getResolved() {
        return this.resolved;
    }

    public void setResolved(String resolved) {
        this.resolved = resolved;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static class IssueSearchSuggestionHandler
    extends DefaultHandler {
        private List<Suggestion> suggestions = new ArrayList<Suggestion>();
        private String prefix;
        private String suffix;
        private String option;
        private String description;
        private int completionStart;
        private int completionEnd;
        private int matchStart;
        private int matchEnd;
        private StringBuilder stringBuilder = new StringBuilder();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            this.stringBuilder.setLength(0);
            switch (qName) {
                case "item": {
                    break;
                }
                case "completion": {
                    this.completionStart = Integer.parseInt(attributes.getValue("start"));
                    this.completionEnd = Integer.parseInt(attributes.getValue("end"));
                    break;
                }
                case "match": {
                    this.matchStart = Integer.parseInt(attributes.getValue("start"));
                    this.matchEnd = Integer.parseInt(attributes.getValue("end"));
                    break;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.stringBuilder.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (qName.equals("item")) {
                Suggestion suggestion = new Suggestion();
                suggestion.setOption(this.option);
                suggestion.setDescription(this.description);
                suggestion.setSuffix(this.suffix);
                suggestion.setPrefix(this.prefix);
                suggestion.setCompletionStart(this.completionStart);
                suggestion.setCompletionEnd(this.completionEnd);
                suggestion.setMatchStart(this.matchStart);
                suggestion.setMatchEnd(this.matchEnd);
                this.suggestions.add(suggestion);
            } else if (qName.equals("suffix")) {
                this.suffix = this.stringBuilder.toString();
            } else if (qName.equals("option")) {
                this.option = this.stringBuilder.toString();
            } else if (qName.equals("description")) {
                this.description = this.stringBuilder.toString();
            } else if (qName.equals("prefix")) {
                this.prefix = this.stringBuilder.toString();
            }
        }

        public List<Suggestion> getSuggestions() {
            return this.suggestions;
        }
    }

    public static class IssueSearchHandler
    extends DefaultHandler {
        private List<Issue> issueList = new ArrayList<Issue>();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (qName.equals("issue")) {
                String issueId = attributes.getValue("id");
                this.issueList.add(new Issue(issueId));
            }
        }

        public List<Issue> getIssueList() {
            return this.issueList;
        }
    }

    public static class IssueHandler
    extends DefaultHandler {
        private String currentField;
        private StringBuilder stringBuilder = new StringBuilder();
        private Issue issue;
        private String stateFieldName;

        public IssueHandler(String stateFieldName) {
            this.stateFieldName = stateFieldName;
            if (stateFieldName == null || stateFieldName.equals("")) {
                this.stateFieldName = "State";
            }
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            this.stringBuilder.setLength(0);
            if (qName.equals("issue")) {
                this.issue = new Issue(attributes.getValue("id"));
            }
            if (qName.equals("field")) {
                this.currentField = attributes.getValue("name");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            this.stringBuilder.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (qName.equals("value")) {
                if (this.currentField.equals(this.stateFieldName)) {
                    this.issue.state = this.stringBuilder.toString();
                } else if (this.currentField.equals("summary")) {
                    this.issue.summary = this.stringBuilder.toString();
                } else if (this.currentField.equals("description")) {
                    this.issue.description = this.stringBuilder.toString();
                } else if (this.currentField.equals("resolved")) {
                    this.issue.resolved = this.stringBuilder.toString();
                }
            }
        }

        public Issue getIssue() {
            return this.issue;
        }
    }
}

