/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack.youtrackapi;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Field {
    private String name;
    private String url;
    private String type;
    private String defaultBundle;

    public Field(String name, String url) {
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getType() {
        return this.type;
    }

    public String getDefaultBundle() {
        return this.defaultBundle;
    }

    public static class FieldHandler
    extends DefaultHandler {
        private Field field;

        public FieldHandler(String name, String url) {
            this.field = new Field(name, url);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (qName.equals("customFieldPrototype")) {
                this.field.type = attributes.getValue("type");
            }
            if (qName.equals("defaultParam") && attributes.getValue("name").equals("defaultBundle")) {
                this.field.defaultBundle = attributes.getValue("value");
            }
            if (qName.equals("projectCustomField")) {
                this.field.type = attributes.getValue("type");
            }
            if (qName.equals("param") && attributes.getValue("name").equals("bundle")) {
                this.field.defaultBundle = attributes.getValue("value");
            }
        }

        public Field getField() {
            return this.field;
        }
    }

    public static class FieldListHandler
    extends DefaultHandler {
        private List<Field> fields = new ArrayList<Field>();

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
            this.fields = new ArrayList<Field>();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (qName.equals("customFieldPrototype")) {
                String fieldName = attributes.getValue("name");
                String fieldUrl = attributes.getValue("url");
                this.fields.add(new Field(fieldName, fieldUrl));
            }
        }

        public List<Field> getFields() {
            return this.fields;
        }
    }
}

