/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack.test;

import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestAction;
import java.io.IOException;
import javax.servlet.ServletException;
import org.jenkinsci.plugins.youtrack.Command;
import org.jenkinsci.plugins.youtrack.YouTrackSite;
import org.jenkinsci.plugins.youtrack.test.YoutrackTestDataPublisher;
import org.jenkinsci.plugins.youtrack.youtrackapi.User;
import org.jenkinsci.plugins.youtrack.youtrackapi.YouTrackServer;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class YouTrackTestAction
extends TestAction {
    private YoutrackTestDataPublisher.Data data;
    private CaseResult careResult;
    private final String id;
    private String youtrackIssueId;

    public YouTrackTestAction(YoutrackTestDataPublisher.Data data, CaseResult careResult, String id, String youtrackIssueId) {
        this.data = data;
        this.careResult = careResult;
        this.id = id;
        this.youtrackIssueId = youtrackIssueId;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "youtrack";
    }

    public String getYoutrackIssueId() {
        return this.youtrackIssueId;
    }

    public String getYoutrackServerUrl() {
        YouTrackSite youTrackSite = YouTrackSite.get(this.data.getBuild().getProject());
        return youTrackSite.getUrl();
    }

    public void setYoutrackIssueId(String youtrackIssueId) {
        this.youtrackIssueId = youtrackIssueId;
    }

    public String getId() {
        return this.id;
    }

    public boolean isLinked() {
        return this.youtrackIssueId != null;
    }

    public void doCreateIssue(StaplerRequest req, StaplerResponse resp) throws ServletException, IOException {
        YouTrackSite youTrackSite = YouTrackSite.get(this.data.getBuild().getProject());
        YouTrackServer youTrackServer = new YouTrackServer(youTrackSite.getUrl());
        User mainUser = youTrackServer.login(youTrackSite.getUsername(), youTrackSite.getPassword());
        Command issue = youTrackServer.createIssue(youTrackSite.getName(), mainUser, youTrackSite.getProject(), "Test case: " + this.id, this.careResult.getErrorStackTrace(), null, null);
        this.youtrackIssueId = issue.getIssueId();
        this.data.addLink(this.id, this);
        this.data.save();
        resp.forwardToPreviousPage(req);
    }

    public void doUnlinkIssue(StaplerRequest req, StaplerResponse resp) throws ServletException, IOException {
        this.youtrackIssueId = null;
        this.data.addLink(this.id, null);
        this.data.save();
        resp.forwardToPreviousPage(req);
    }

    public void doLinkIssue(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        String youtrackIssueId1;
        this.youtrackIssueId = youtrackIssueId1 = req.getParameter("youtrackIssueId");
        this.data.addLink(this.id, this);
        this.data.save();
        resp.forwardToPreviousPage(req);
    }
}

