/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class YoutrackProcessedRevisionsSaver {
    private Logger LOGGER = Logger.getLogger(YoutrackProcessedRevisionsSaver.class.getName());
    public Set<String> processedIds;
    private File file;

    public YoutrackProcessedRevisionsSaver() {
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            this.file = new File(instance.getRootDir(), "youtrack-processed");
            this.load();
        }
    }

    private void load() {
        this.processedIds = new HashSet<String>();
        if (!this.file.exists()) {
            try {
                boolean newFile = this.file.createNewFile();
                if (!newFile) {
                    this.LOGGER.log(Level.SEVERE, "Could not create youtrack processed file");
                }
            }
            catch (IOException e) {
                this.LOGGER.log(Level.SEVERE, "Could not create youtrack processed file", e);
            }
        } else {
            try (FileInputStream fileInputStream = new FileInputStream(this.file);
                 BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));){
                String l;
                while ((l = bufferedReader.readLine()) != null) {
                    this.processedIds.add(l);
                }
            }
            catch (IOException e) {
                this.LOGGER.log(Level.SEVERE, "Could not load youtrack processed file", e);
            }
        }
    }

    public synchronized boolean isProcessed(String revisionId) {
        return this.processedIds.contains(revisionId);
    }

    public synchronized void addProcessed(String revisionId) {
        this.processedIds.add(revisionId);
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file, true), StandardCharsets.UTF_8));){
            printWriter.append(revisionId).append("\n");
        }
        catch (IOException e) {
            this.LOGGER.log(Level.SEVERE, "Could not write to youtrack processed file", e);
        }
    }
}

