/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack;

import com.google.common.collect.ArrayListMultimap;
import groovy.lang.Binding;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.tasks.Mailer;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.youtrack.Command;
import org.jenkinsci.plugins.youtrack.PrefixCommandPair;
import org.jenkinsci.plugins.youtrack.YouTrackCommandAction;
import org.jenkinsci.plugins.youtrack.YouTrackIssueAction;
import org.jenkinsci.plugins.youtrack.YouTrackPlugin;
import org.jenkinsci.plugins.youtrack.YouTrackSaveFixedIssues;
import org.jenkinsci.plugins.youtrack.YouTrackSaveProjectShortNamesAction;
import org.jenkinsci.plugins.youtrack.YouTrackSite;
import org.jenkinsci.plugins.youtrack.YoutrackProcessedRevisionsSaver;
import org.jenkinsci.plugins.youtrack.youtrackapi.Issue;
import org.jenkinsci.plugins.youtrack.youtrackapi.Project;
import org.jenkinsci.plugins.youtrack.youtrackapi.User;
import org.jenkinsci.plugins.youtrack.youtrackapi.YouTrackServer;

public class YoutrackIssueUpdater {
    private static final Logger LOGGER = Logger.getLogger(YoutrackIssueUpdater.class.getName());

    private static Map<String, String> getPrefixCommands(YouTrackSite youTrackSite) {
        List<PrefixCommandPair> prefixCommandPairs = youTrackSite.getPrefixCommandPairs();
        HashMap<String, String> prefixCommandMap = new HashMap<String, String>();
        if (prefixCommandPairs == null || prefixCommandPairs.isEmpty()) {
            return null;
        }
        for (PrefixCommandPair commandPair : prefixCommandPairs) {
            if (commandPair.getPrefix() == null || commandPair.getPrefix().isEmpty() || commandPair.getCommand() == null || commandPair.getCommand().isEmpty()) continue;
            prefixCommandMap.put(commandPair.getPrefix().toLowerCase(), commandPair.getCommand());
        }
        return prefixCommandMap;
    }

    private static Set<String> getFixedValues(YouTrackSite youTrackSite) {
        HashSet<String> fixedValues = new HashSet<String>();
        if (youTrackSite.getFixedValues() != null && !youTrackSite.getFixedValues().equals("")) {
            String[] fixedValueArray;
            String values = youTrackSite.getFixedValues();
            for (String fixedValueFromArray : fixedValueArray = values.split(",")) {
                if (fixedValueFromArray.trim().equals("")) continue;
                fixedValues.add(fixedValueFromArray.trim());
            }
        } else {
            fixedValues.add("Fixed");
        }
        return fixedValues;
    }

    public void update(SCM scm, AbstractBuild<?, ?> build, BuildListener listener, ChangeLogSet<?> changeLogSet) throws InvocationTargetException, IllegalAccessException {
        YouTrackSite youTrackSite = this.getYouTrackSite(build);
        if (youTrackSite == null || !youTrackSite.isPluginEnabled()) {
            return;
        }
        Iterator changeLogIterator = changeLogSet.iterator();
        YouTrackServer youTrackServer = this.getYouTrackServer(youTrackSite);
        User user = youTrackServer.login(youTrackSite.getUsername(), youTrackSite.getPassword());
        if (user == null || !user.isLoggedIn()) {
            listener.getLogger().append("FAILED: log in with set YouTrack user");
            youTrackSite.failed(build);
        }
        this.performActions(scm, build, listener, youTrackSite, changeLogIterator, youTrackServer, user);
    }

    YouTrackServer getYouTrackServer(YouTrackSite youTrackSite) {
        return new YouTrackServer(youTrackSite.getUrl());
    }

    YouTrackSite getYouTrackSite(AbstractBuild<?, ?> build) {
        return YouTrackSite.get(build.getProject());
    }

    public void performActions(SCM scm, AbstractBuild<?, ?> build, BuildListener listener, YouTrackSite youTrackSite, Iterator<? extends ChangeLogSet.Entry> changeLogIterator, YouTrackServer youTrackServer, User user) throws IllegalAccessException, InvocationTargetException {
        build.addAction((Action)new YouTrackIssueAction(build.getProject()));
        List<Project> projects = youTrackServer.getProjects(user);
        if (projects != null) {
            build.addAction((Action)new YouTrackSaveProjectShortNamesAction(projects));
        } else {
            AbstractBuild lastSuccessfulBuild = (AbstractBuild)build.getProject().getLastStableBuild();
            YouTrackSaveProjectShortNamesAction action = (YouTrackSaveProjectShortNamesAction)lastSuccessfulBuild.getAction(YouTrackSaveProjectShortNamesAction.class);
            if (action != null) {
                List<String> shortNames = action.getShortNames();
                ArrayList<Project> previousProjects = new ArrayList<Project>();
                for (String string : shortNames) {
                    Project prevProject = new Project();
                    prevProject.setShortName(string);
                    previousProjects.add(prevProject);
                    projects = previousProjects;
                }
            } else {
                projects = new ArrayList<Project>();
            }
        }
        ArrayList<ChangeLogSet.Entry> changeLogEntries = new ArrayList<ChangeLogSet.Entry>();
        while (changeLogIterator.hasNext()) {
            changeLogEntries.add(changeLogIterator.next());
        }
        YouTrackCommandAction commandAction = new YouTrackCommandAction(build);
        ArrayList<Issue> fixedIssues = new ArrayList<Issue>();
        EnvVars environment = null;
        try {
            environment = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (youTrackSite.isCommentEnabled()) {
            ArrayListMultimap relatedChanges = ArrayListMultimap.create();
            for (ChangeLogSet.Entry entry : changeLogEntries) {
                String msg = YoutrackIssueUpdater.getMessage(scm, entry, listener, environment, build);
                List<Issue> issuesFromCommit = this.findIssuesFromCommit(msg, projects);
                for (Issue issue : issuesFromCommit) {
                    relatedChanges.put((Object)issue, (Object)entry);
                }
            }
            for (Issue relatedIssue : relatedChanges.keySet()) {
                List entries = relatedChanges.get((Object)relatedIssue);
                List<Command> commands = this.addComment(build, youTrackSite, youTrackServer, user, relatedIssue, entries, listener);
                for (Command command : commands) {
                    commandAction.addCommand(command);
                }
            }
        }
        for (ChangeLogSet.Entry entry : changeLogEntries) {
            String msg = YoutrackIssueUpdater.getMessage(scm, entry, listener, environment, build);
            if (projects == null) continue;
            ArrayList<Project> youtrackProjects = new ArrayList<Project>(projects.size());
            Set<String> includedProjects = this.getIncludedProjects(projects, youTrackSite);
            for (Project project : projects) {
                if (!includedProjects.contains(project.getShortName())) continue;
                youtrackProjects.add(project);
            }
            Jenkins instance = Jenkins.getInstance();
            YouTrackPlugin plugin = null;
            if (instance != null) {
                plugin = (YouTrackPlugin)instance.getPlugin(YouTrackPlugin.class);
            }
            YoutrackProcessedRevisionsSaver revisionsSaver = null;
            if (plugin != null) {
                revisionsSaver = plugin.getRevisionsSaver();
            }
            if ((!youTrackSite.isTrackCommits() || revisionsSaver == null || revisionsSaver.isProcessed(entry.getCommitId())) && youTrackSite.isTrackCommits()) continue;
            List<Command> commandList = this.executeCommandsIfEnabled(build, listener, youTrackSite, youTrackServer, user, youtrackProjects, fixedIssues, entry, msg);
            for (Command command : commandList) {
                commandAction.addCommand(command);
            }
            if (!youTrackSite.isTrackCommits() || commandList.isEmpty() || revisionsSaver == null) continue;
            revisionsSaver.addProcessed(entry.getCommitId());
        }
        int numCommands = commandAction.getNumCommands();
        if (numCommands > 0) {
            build.addAction((Action)commandAction);
        }
        build.addAction((Action)new YouTrackSaveFixedIssues(fixedIssues));
    }

    public static String getMessage(SCM scm, ChangeLogSet.Entry next, BuildListener listener, EnvVars environment, AbstractBuild<?, ?> build) throws IllegalAccessException, InvocationTargetException {
        String msg;
        if (scm != null && scm.getClass().getSimpleName().equals("GitSCM")) {
            try {
                Method createClient = scm.getClass().getMethod("createClient", TaskListener.class, EnvVars.class, Run.class, FilePath.class);
                GitClient gitClient = (GitClient)createClient.invoke((Object)scm, listener, environment, build, build.getWorkspace());
                List stringList = gitClient.showRevision(gitClient.revParse(next.getCommitId()));
                StringBuilder message = new StringBuilder();
                for (String line : stringList) {
                    if (!line.startsWith("   ")) continue;
                    String substring = line.substring(4);
                    message.append(substring).append("\n");
                }
                msg = message.toString();
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } else {
            msg = next.getMsg();
        }
        return msg;
    }

    private Set<String> getIncludedProjects(List<Project> projects, YouTrackSite youTrackSite) {
        String[] names;
        String executeProjectLimits = youTrackSite.getExecuteProjectLimits();
        if (executeProjectLimits == null || executeProjectLimits.trim().equals("")) {
            HashSet<String> projectIds = new HashSet<String>();
            for (Project project : projects) {
                projectIds.add(project.getShortName());
            }
            return projectIds;
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (String name : names = executeProjectLimits.split(",")) {
            if (name.trim().equals("")) continue;
            nameSet.add(name);
        }
        return nameSet;
    }

    List<Command> executeCommandsIfEnabled(AbstractBuild<?, ?> build, BuildListener listener, YouTrackSite youTrackSite, YouTrackServer youTrackServer, User user, List<Project> projects, List<Issue> fixedIssues, ChangeLogSet.Entry changeLogEntry, String msg) {
        ArrayList<Command> commands = new ArrayList<Command>();
        if (youTrackSite.isCommandsEnabled()) {
            Map<String, String> prefixCommands = YoutrackIssueUpdater.getPrefixCommands(youTrackSite);
            String[] lines = msg.split("\n");
            for (int i = 0; i < lines.length; ++i) {
                Pair<String, String> issueAndCommand;
                String line = lines[i];
                if (!line.contains("#")) continue;
                String comment = null;
                String issueStart = line.substring(line.indexOf("#") + 1);
                boolean isSilent = false;
                String extraPrefixCommand = null;
                int hashPosition = line.indexOf("#");
                if (hashPosition != 0) {
                    int prefixLength = hashPosition;
                    char charBefore = line.charAt(hashPosition - 1);
                    if (charBefore == '!') {
                        isSilent = true;
                        --prefixLength;
                    }
                    if (prefixCommands != null && prefixLength != 0) {
                        String prefix = line.substring(0, prefixLength).trim().toLowerCase();
                        for (Map.Entry<String, String> entry : prefixCommands.entrySet()) {
                            if (!prefix.endsWith(entry.getKey())) continue;
                            extraPrefixCommand = entry.getValue();
                            break;
                        }
                    }
                }
                if (i + 1 < lines.length) {
                    StringBuilder commentBuilder = new StringBuilder();
                    ++i;
                    while (i < lines.length) {
                        String nextLine = lines[i];
                        if (nextLine.contains("#")) {
                            --i;
                            break;
                        }
                        commentBuilder.append(nextLine).append("\n");
                        ++i;
                    }
                    if ((comment = commentBuilder.toString().trim()).isEmpty()) {
                        comment = null;
                    }
                }
                Project p = null;
                for (Project project : projects) {
                    if (!issueStart.startsWith(project.getShortName() + "-")) continue;
                    p = project;
                    break;
                }
                if (p == null || (issueAndCommand = YoutrackIssueUpdater.getIssueAndCommand(p, issueStart)) == null) continue;
                if (extraPrefixCommand != null) {
                    this.applyCommandToIssue(build, youTrackSite, youTrackServer, user, fixedIssues, changeLogEntry, issueAndCommand.getFirst(), extraPrefixCommand, null, listener, commands, isSilent);
                }
                if (issueAndCommand.getSecond() == null || issueAndCommand.getSecond().equals("")) continue;
                this.applyCommandToIssue(build, youTrackSite, youTrackServer, user, fixedIssues, changeLogEntry, issueAndCommand.getFirst(), issueAndCommand.getSecond(), comment, listener, commands, isSilent);
            }
        }
        return commands;
    }

    private static Pair<String, String> getIssueAndCommand(Project p, String issueStart) {
        Pattern projectPattern = Pattern.compile("(" + p.getShortName() + "-" + "(\\d+)" + ")( )?(.*)");
        Matcher matcher = projectPattern.matcher(issueStart);
        if (!matcher.find() || matcher.groupCount() < 1) {
            return null;
        }
        String issueId = p.getShortName() + "-" + matcher.group(2);
        String command = matcher.group(4);
        return new Pair<String, String>(issueId, command);
    }

    private void applyCommandToIssue(AbstractBuild<?, ?> build, YouTrackSite youTrackSite, YouTrackServer youTrackServer, User user, List<Issue> fixedIssues, ChangeLogSet.Entry next, String issueId, String command, String comment, BuildListener listener, List<Command> commands, boolean silent) {
        String address;
        User userByEmail = null;
        if (youTrackSite.isRunAsEnabled() && (userByEmail = youTrackServer.getUserByEmail(user, address = ((Mailer.UserProperty)next.getAuthor().getProperty(Mailer.UserProperty.class)).getAddress())) == null) {
            listener.getLogger().println("Failed to find user with e-mail: " + address);
            youTrackSite.failed(build);
        }
        String stateFieldName = "State";
        if (youTrackSite.getStateFieldName() != null && !youTrackSite.getStateFieldName().equals("")) {
            stateFieldName = youTrackSite.getStateFieldName();
        }
        Issue before = youTrackServer.getIssue(user, issueId, stateFieldName);
        boolean isSilent = youTrackSite.isSilentCommands() || silent;
        Command cmd = youTrackServer.applyCommand(youTrackSite.getName(), user, new Issue(issueId), command, comment, null, userByEmail, !isSilent);
        if (cmd.getStatus() == Command.Status.OK) {
            listener.getLogger().println("Applied command: " + command + " to issue: " + issueId);
        } else {
            listener.getLogger().println("FAILED: Applying command: " + command + " to issue: " + issueId);
            youTrackSite.failed(build);
        }
        commands.add(cmd);
        Issue after = youTrackServer.getIssue(user, issueId, stateFieldName);
        Set<String> fixedValues = YoutrackIssueUpdater.getFixedValues(youTrackSite);
        if (before != null && after != null && !fixedValues.contains(before.getState()) && fixedValues.contains(after.getState())) {
            fixedIssues.add(after);
        }
    }

    private List<Issue> findIssuesFromCommit(String msg, List<Project> projects) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Project project1 : projects) {
            String shortName = project1.getShortName();
            Pattern projectPattern = Pattern.compile("^(" + shortName + "-" + "(\\d+)" + ")|\\W(" + shortName + "-" + "(\\d+))");
            Matcher matcher = projectPattern.matcher(msg);
            while (matcher.find()) {
                if (matcher.groupCount() < 1) continue;
                String id = matcher.group(2);
                if (id == null) {
                    id = matcher.group(4);
                }
                String issueId = shortName + "-" + id;
                issues.add(new Issue(issueId));
            }
        }
        return issues;
    }

    private List<Command> addComment(AbstractBuild<?, ?> build, YouTrackSite youTrackSite, YouTrackServer youTrackServer, User user, Issue relatedIssue, List<ChangeLogSet.Entry> entries, BuildListener listener) {
        ArrayList<Command> commands = new ArrayList<Command>();
        SecureGroovyScript commentTextScript = youTrackSite.getCommentTextSecure();
        String commentText = "";
        if (commentTextScript == null || StringUtils.isBlank((String)commentTextScript.getScript())) {
            StringBuilder stringBuilder = new StringBuilder("Related build: " + this.getAbsoluteUrlForBuild(build));
            for (ChangeLogSet.Entry entry : entries) {
                stringBuilder.append("\nSHA: ").append(entry.getCommitId());
            }
            commentText = stringBuilder.toString();
        } else {
            try {
                String result;
                EnvVars environment = build.getEnvironment((TaskListener)listener);
                commentText = environment.expand(commentText);
                HashMap<String, Object> env = new HashMap<String, Object>();
                env.put("build", build);
                env.put("entries", entries);
                Binding binding = new Binding(env);
                commentText = result = (String)commentTextScript.evaluate(this.getClass().getClassLoader(), binding);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        Command comment = youTrackServer.comment(youTrackSite.getName(), user, relatedIssue, commentText, youTrackSite.getLinkVisibility(), youTrackSite.isSilentLinks());
        if (comment != null) {
            commands.add(comment);
            if (comment.getStatus() == Command.Status.OK) {
                listener.getLogger().println("Commented on " + relatedIssue.getId());
            } else {
                listener.getLogger().println("FAILED: Commented on " + relatedIssue.getId());
                youTrackSite.failed(build);
            }
        }
        return commands;
    }

    protected String getAbsoluteUrlForBuild(AbstractBuild build) {
        return build.getAbsoluteUrl();
    }

    private static class Pair<T, U> {
        private final T first;
        private final U second;

        @ConstructorProperties(value={"first", "second"})
        public Pair(T first, U second) {
            this.first = first;
            this.second = second;
        }

        public T getFirst() {
            return this.first;
        }

        public U getSecond() {
            return this.second;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$first = this.getFirst();
            T other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
                return false;
            }
            U this$second = this.getSecond();
            U other$second = other.getSecond();
            return !(this$second == null ? other$second != null : !this$second.equals(other$second));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Pair;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $first = this.getFirst();
            result = result * 59 + ($first == null ? 0 : $first.hashCode());
            U $second = this.getSecond();
            result = result * 59 + ($second == null ? 0 : $second.hashCode());
            return result;
        }

        public String toString() {
            return "YoutrackIssueUpdater.Pair(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
        }
    }
}

