/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Result;
import java.util.List;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.youtrack.PrefixCommandPair;
import org.jenkinsci.plugins.youtrack.YouTrackProjectProperty;
import org.jenkinsci.plugins.youtrack.YoutrackBuildFailureMode;
import org.kohsuke.stapler.DataBoundConstructor;

public class YouTrackSite {
    private String name;
    private String url;
    private String username;
    private String password;
    private transient boolean pluginEnabled;
    private transient boolean runAsEnabled;
    private transient boolean commandsEnabled;
    private transient boolean commentEnabled;
    private transient String commentText;
    private transient SecureGroovyScript commentTextSecure;
    private transient boolean annotationsEnabled;
    private transient String linkVisibility;
    private transient String stateFieldName;
    private transient String fixedValues;
    private transient boolean silentCommands;
    private transient boolean silentLinks;
    private transient String project;
    private transient String executeProjectLimits;
    private transient List<PrefixCommandPair> prefixCommandPairs;
    private boolean trackCommits;
    private YoutrackBuildFailureMode failureMode;

    @DataBoundConstructor
    public YouTrackSite(String name, String username, String password, String url) {
        this.username = username;
        this.password = password;
        this.url = url;
        this.name = name;
    }

    public static YouTrackSite get(AbstractProject<?, ?> project) {
        YouTrackSite site;
        YouTrackProjectProperty ypp = (YouTrackProjectProperty)project.getProperty(YouTrackProjectProperty.class);
        if (ypp != null && (site = ypp.getSite()) != null) {
            return site;
        }
        YouTrackSite[] sites = YouTrackProjectProperty.DESCRIPTOR.getSites();
        if (sites.length == 1) {
            return sites[0];
        }
        return null;
    }

    public void failed(AbstractBuild<?, ?> build) {
        if (this.failureMode != null) {
            switch (this.failureMode) {
                case NONE: {
                    break;
                }
                case UNSTABLE: {
                    build.setResult(Result.UNSTABLE);
                    break;
                }
                case FAILURE: {
                    build.setResult(Result.FAILURE);
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isPluginEnabled() {
        return this.pluginEnabled;
    }

    public void setPluginEnabled(boolean pluginEnabled) {
        this.pluginEnabled = pluginEnabled;
    }

    public boolean isRunAsEnabled() {
        return this.runAsEnabled;
    }

    public void setRunAsEnabled(boolean runAsEnabled) {
        this.runAsEnabled = runAsEnabled;
    }

    public boolean isCommandsEnabled() {
        return this.commandsEnabled;
    }

    public void setCommandsEnabled(boolean commandsEnabled) {
        this.commandsEnabled = commandsEnabled;
    }

    public boolean isCommentEnabled() {
        return this.commentEnabled;
    }

    public void setCommentEnabled(boolean commentEnabled) {
        this.commentEnabled = commentEnabled;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public SecureGroovyScript getCommentTextSecure() {
        return this.commentTextSecure;
    }

    public void setCommentTextSecure(SecureGroovyScript commentTextSecure) {
        this.commentTextSecure = commentTextSecure;
    }

    public boolean isAnnotationsEnabled() {
        return this.annotationsEnabled;
    }

    public void setAnnotationsEnabled(boolean annotationsEnabled) {
        this.annotationsEnabled = annotationsEnabled;
    }

    public String getLinkVisibility() {
        return this.linkVisibility;
    }

    public void setLinkVisibility(String linkVisibility) {
        this.linkVisibility = linkVisibility;
    }

    public String getStateFieldName() {
        return this.stateFieldName;
    }

    public void setStateFieldName(String stateFieldName) {
        this.stateFieldName = stateFieldName;
    }

    public String getFixedValues() {
        return this.fixedValues;
    }

    public void setFixedValues(String fixedValues) {
        this.fixedValues = fixedValues;
    }

    public boolean isSilentCommands() {
        return this.silentCommands;
    }

    public void setSilentCommands(boolean silentCommands) {
        this.silentCommands = silentCommands;
    }

    public boolean isSilentLinks() {
        return this.silentLinks;
    }

    public void setSilentLinks(boolean silentLinks) {
        this.silentLinks = silentLinks;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getExecuteProjectLimits() {
        return this.executeProjectLimits;
    }

    public void setExecuteProjectLimits(String executeProjectLimits) {
        this.executeProjectLimits = executeProjectLimits;
    }

    public List<PrefixCommandPair> getPrefixCommandPairs() {
        return this.prefixCommandPairs;
    }

    public void setPrefixCommandPairs(List<PrefixCommandPair> prefixCommandPairs) {
        this.prefixCommandPairs = prefixCommandPairs;
    }

    public boolean isTrackCommits() {
        return this.trackCommits;
    }

    public void setTrackCommits(boolean trackCommits) {
        this.trackCommits = trackCommits;
    }

    public YoutrackBuildFailureMode getFailureMode() {
        return this.failureMode;
    }

    public void setFailureMode(YoutrackBuildFailureMode failureMode) {
        this.failureMode = failureMode;
    }
}

