/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.youtrack.PrefixCommandPair;
import org.jenkinsci.plugins.youtrack.YouTrackSite;
import org.jenkinsci.plugins.youtrack.YoutrackBuildFailureMode;
import org.jenkinsci.plugins.youtrack.youtrackapi.Field;
import org.jenkinsci.plugins.youtrack.youtrackapi.Group;
import org.jenkinsci.plugins.youtrack.youtrackapi.Project;
import org.jenkinsci.plugins.youtrack.youtrackapi.State;
import org.jenkinsci.plugins.youtrack.youtrackapi.StateBundle;
import org.jenkinsci.plugins.youtrack.youtrackapi.User;
import org.jenkinsci.plugins.youtrack.youtrackapi.YouTrackServer;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class YouTrackProjectProperty
extends JobProperty<AbstractProject<?, ?>> {
    private String siteName;
    private boolean pluginEnabled;
    private boolean commentsEnabled;
    private String commentText;
    private SecureGroovyScript commentTextSecure;
    private boolean commandsEnabled;
    private boolean runAsEnabled;
    private boolean annotationsEnabled;
    private String linkVisibility;
    private String stateFieldName;
    private String fixedValues;
    private boolean silentCommands;
    private boolean silentLinks;
    private String executeProjectLimits;
    private boolean trackCommits;
    private String project;
    private List<PrefixCommandPair> prefixCommandPairs;
    private YoutrackBuildFailureMode failureMode = YoutrackBuildFailureMode.NONE;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public YouTrackProjectProperty(String siteName, boolean pluginEnabled, boolean commentsEnabled, boolean commandsEnabled, boolean runAsEnabled, boolean annotationsEnabled, String linkVisibility, String stateFieldName, String fixedValues, boolean silentCommands, boolean silentLinks, String executeProjectLimits, boolean trackCommits, String project, String commentText, YoutrackBuildFailureMode failureMode, SecureGroovyScript commentTextSecure) {
        this.siteName = siteName;
        this.pluginEnabled = pluginEnabled;
        this.commentsEnabled = commentsEnabled;
        this.commandsEnabled = commandsEnabled;
        this.runAsEnabled = runAsEnabled;
        this.annotationsEnabled = annotationsEnabled;
        this.linkVisibility = linkVisibility;
        this.stateFieldName = stateFieldName;
        this.fixedValues = fixedValues;
        this.silentCommands = silentCommands;
        this.silentLinks = silentLinks;
        this.executeProjectLimits = executeProjectLimits;
        this.trackCommits = trackCommits;
        this.project = project;
        this.commentText = commentText;
        this.commentTextSecure = commentTextSecure;
        this.failureMode = failureMode;
        this.prefixCommandPairs = new ArrayList<PrefixCommandPair>();
    }

    public JobPropertyDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    static AutoCompletionCandidates getProjects(@AncestorInPath AbstractProject project, @QueryParameter String value) {
        YouTrackServer youTrackServer;
        User user;
        YouTrackSite youTrackSite = YouTrackSite.get(project);
        AutoCompletionCandidates autoCompletionCandidates = new AutoCompletionCandidates();
        if (youTrackSite != null && (user = (youTrackServer = new YouTrackServer(youTrackSite.getUrl())).login(youTrackSite.getUsername(), youTrackSite.getPassword())) != null) {
            List<Project> projects = youTrackServer.getProjects(user);
            for (Project youtrackProject : projects) {
                if (!youtrackProject.getShortName().toLowerCase().contains(value.toLowerCase())) continue;
                autoCompletionCandidates.add(youtrackProject.getShortName());
            }
        }
        return autoCompletionCandidates;
    }

    public static AutoCompletionCandidates getFields(@AncestorInPath AbstractProject project, @QueryParameter String value) {
        YouTrackServer youTrackServer;
        User user;
        YouTrackSite youTrackSite = YouTrackSite.get(project);
        AutoCompletionCandidates autoCompletionCandidates = new AutoCompletionCandidates();
        if (youTrackSite != null && (user = (youTrackServer = new YouTrackServer(youTrackSite.getUrl())).login(youTrackSite.getUsername(), youTrackSite.getPassword())) != null) {
            List<Field> fields = youTrackServer.getFields(user);
            for (Field field : fields) {
                if (!field.getName().toLowerCase().contains(value.toLowerCase())) continue;
                autoCompletionCandidates.add(field.getName());
            }
        }
        return autoCompletionCandidates;
    }

    public static AutoCompletionCandidates getPossibleGroups(AbstractProject project, String value) {
        YouTrackServer youTrackServer;
        User user;
        YouTrackSite youTrackSite = YouTrackSite.get(project);
        AutoCompletionCandidates autoCompletionCandidates = new AutoCompletionCandidates();
        if (youTrackSite != null && (user = (youTrackServer = new YouTrackServer(youTrackSite.getUrl())).login(youTrackSite.getUsername(), youTrackSite.getPassword())) != null) {
            List<Group> groups = youTrackServer.getGroups(user);
            for (Group group : groups) {
                if (!group.getName().toLowerCase().contains(value.toLowerCase())) continue;
                autoCompletionCandidates.add(group.getName());
            }
        }
        return autoCompletionCandidates;
    }

    public YouTrackSite getSite() {
        YouTrackSite result = null;
        YouTrackSite[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            result = sites[0];
        }
        for (YouTrackSite site : sites) {
            if (site.getName() == null || !site.getName().equals(this.siteName)) continue;
            result = site;
            break;
        }
        if (result != null) {
            result.setPluginEnabled(this.pluginEnabled);
            result.setCommentEnabled(this.commentsEnabled);
            result.setCommandsEnabled(this.commandsEnabled);
            result.setAnnotationsEnabled(this.annotationsEnabled);
            result.setRunAsEnabled(this.runAsEnabled);
            result.setLinkVisibility(this.linkVisibility);
            result.setStateFieldName(this.stateFieldName);
            result.setFixedValues(this.fixedValues);
            result.setSilentCommands(this.silentCommands);
            result.setSilentLinks(this.silentLinks);
            result.setExecuteProjectLimits(this.executeProjectLimits);
            result.setTrackCommits(this.trackCommits);
            result.setProject(this.project);
            result.setPrefixCommandPairs(this.prefixCommandPairs);
            result.setCommentText(this.commentText);
            result.setCommentTextSecure(this.commentTextSecure);
            result.setFailureMode(this.failureMode);
        }
        return result;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public boolean isPluginEnabled() {
        return this.pluginEnabled;
    }

    public void setPluginEnabled(boolean pluginEnabled) {
        this.pluginEnabled = pluginEnabled;
    }

    public boolean isCommentsEnabled() {
        return this.commentsEnabled;
    }

    public void setCommentsEnabled(boolean commentsEnabled) {
        this.commentsEnabled = commentsEnabled;
    }

    public String getCommentText() {
        return this.commentText;
    }

    public void setCommentText(String commentText) {
        this.commentText = commentText;
    }

    public SecureGroovyScript getCommentTextSecure() {
        return this.commentTextSecure;
    }

    public void setCommentTextSecure(SecureGroovyScript commentTextSecure) {
        this.commentTextSecure = commentTextSecure;
    }

    public boolean isCommandsEnabled() {
        return this.commandsEnabled;
    }

    public void setCommandsEnabled(boolean commandsEnabled) {
        this.commandsEnabled = commandsEnabled;
    }

    public boolean isRunAsEnabled() {
        return this.runAsEnabled;
    }

    public void setRunAsEnabled(boolean runAsEnabled) {
        this.runAsEnabled = runAsEnabled;
    }

    public boolean isAnnotationsEnabled() {
        return this.annotationsEnabled;
    }

    public void setAnnotationsEnabled(boolean annotationsEnabled) {
        this.annotationsEnabled = annotationsEnabled;
    }

    public String getLinkVisibility() {
        return this.linkVisibility;
    }

    public void setLinkVisibility(String linkVisibility) {
        this.linkVisibility = linkVisibility;
    }

    public String getStateFieldName() {
        return this.stateFieldName;
    }

    public void setStateFieldName(String stateFieldName) {
        this.stateFieldName = stateFieldName;
    }

    public String getFixedValues() {
        return this.fixedValues;
    }

    public void setFixedValues(String fixedValues) {
        this.fixedValues = fixedValues;
    }

    public boolean isSilentCommands() {
        return this.silentCommands;
    }

    public void setSilentCommands(boolean silentCommands) {
        this.silentCommands = silentCommands;
    }

    public boolean isSilentLinks() {
        return this.silentLinks;
    }

    public void setSilentLinks(boolean silentLinks) {
        this.silentLinks = silentLinks;
    }

    public String getExecuteProjectLimits() {
        return this.executeProjectLimits;
    }

    public void setExecuteProjectLimits(String executeProjectLimits) {
        this.executeProjectLimits = executeProjectLimits;
    }

    public boolean isTrackCommits() {
        return this.trackCommits;
    }

    public void setTrackCommits(boolean trackCommits) {
        this.trackCommits = trackCommits;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public List<PrefixCommandPair> getPrefixCommandPairs() {
        return this.prefixCommandPairs;
    }

    public void setPrefixCommandPairs(List<PrefixCommandPair> prefixCommandPairs) {
        this.prefixCommandPairs = prefixCommandPairs;
    }

    public YoutrackBuildFailureMode getFailureMode() {
        return this.failureMode;
    }

    public void setFailureMode(YoutrackBuildFailureMode failureMode) {
        this.failureMode = failureMode;
    }

    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        private final CopyOnWriteList<YouTrackSite> sites = new CopyOnWriteList();

        public boolean isApplicable(Class<? extends Job> jobType) {
            return AbstractProject.class.isAssignableFrom(jobType);
        }

        public DescriptorImpl() {
            super(YouTrackProjectProperty.class);
            this.load();
        }

        public void setSites(YouTrackSite site) {
            this.sites.add((Object)site);
        }

        public YouTrackSite[] getSites() {
            return (YouTrackSite[])this.sites.toArray((Object[])new YouTrackSite[0]);
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JSONObject pluginEnabled = (JSONObject)formData.get("pluginEnabled");
            YouTrackProjectProperty ypp = null;
            if (pluginEnabled != null) {
                ypp = (YouTrackProjectProperty)((Object)req.bindJSON(YouTrackProjectProperty.class, pluginEnabled));
                if (ypp.siteName == null) {
                    return null;
                }
                ypp.commentTextSecure.configuringWithKeyItem();
                ypp.setPluginEnabled(true);
                Object prefixCommandArray = pluginEnabled.get("prefixCommandPairs");
                List commandPairs = req.bindJSONToList(PrefixCommandPair.class, prefixCommandArray);
                ypp.setPrefixCommandPairs(commandPairs);
            }
            return ypp;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.sites.replaceBy((Collection)req.bindParametersToList(YouTrackSite.class, "youtrack."));
            this.save();
            return true;
        }

        public String getDisplayName() {
            return "YouTrack Plugin";
        }

        public AutoCompletionCandidates doAutoCompleteProject(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            YouTrackServer youTrackServer;
            User user;
            YouTrackSite youTrackSite = YouTrackSite.get(project);
            AutoCompletionCandidates autoCompletionCandidates = new AutoCompletionCandidates();
            if (youTrackSite != null && (user = (youTrackServer = new YouTrackServer(youTrackSite.getUrl())).login(youTrackSite.getUsername(), youTrackSite.getPassword())) != null && user.isLoggedIn()) {
                List<Project> projects = youTrackServer.getProjects(user);
                for (Project youtrackProject : projects) {
                    if (value == null || value.equals("")) {
                        autoCompletionCandidates.add(value);
                        continue;
                    }
                    if (!youtrackProject.getShortName().toLowerCase().contains(value.toLowerCase())) continue;
                    autoCompletionCandidates.add(youtrackProject.getShortName());
                }
            }
            return autoCompletionCandidates;
        }

        public FormValidation doVersionCheck(final @QueryParameter String value) throws IOException, ServletException {
            return new FormValidation.URLCheck(){

                protected FormValidation check() throws IOException, ServletException {
                    YouTrackServer youTrackServer = new YouTrackServer(value);
                    String[] version = youTrackServer.getVersion();
                    if (version == null) {
                        return FormValidation.warning((String)"Could not get version, maybe because version is below 4.x");
                    }
                    return FormValidation.ok();
                }
            }.check();
        }

        public FormValidation doTestConnection(@QueryParameter(value="youtrack.url") String url, @QueryParameter(value="youtrack.username") String username, @QueryParameter(value="youtrack.password") String password) {
            YouTrackServer youTrackServer = new YouTrackServer(url);
            if (username != null && !username.equals("")) {
                User login = youTrackServer.login(username, password);
                if (login != null && login.isLoggedIn()) {
                    return FormValidation.ok((String)"Connection ok!");
                }
                return FormValidation.error((String)"Could not login with given options");
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteLinkVisibility(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            return YouTrackProjectProperty.getPossibleGroups(project, value);
        }

        public AutoCompletionCandidates doAutoCompleteStateFieldName(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            return YouTrackProjectProperty.getFields(project, value);
        }

        public AutoCompletionCandidates doAutoCompleteFixedValues(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            StateBundle bundle;
            YouTrackServer youTrackServer;
            User user;
            YouTrackSite youTrackSite = YouTrackSite.get(project);
            AutoCompletionCandidates autoCompletionCandidates = new AutoCompletionCandidates();
            if (youTrackSite != null && (user = (youTrackServer = new YouTrackServer(youTrackSite.getUrl())).login(youTrackSite.getUsername(), youTrackSite.getPassword())) != null && (bundle = youTrackServer.getStateBundleForField(user, youTrackSite.getStateFieldName())) != null) {
                for (State state : bundle.getStates()) {
                    if (!state.getValue().toLowerCase().contains(value.toLowerCase())) continue;
                    autoCompletionCandidates.add(state.getValue());
                }
            }
            return autoCompletionCandidates;
        }

        public AutoCompletionCandidates doAutoCompleteExecuteProjectLimits(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            return YouTrackProjectProperty.getProjects(project, value);
        }
    }
}

