/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack;

import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.plugins.youtrack.Command;
import org.jenkinsci.plugins.youtrack.YouTrackSite;

public class YouTrackCommandAction
implements Action {
    private List<Command> commands;
    private AbstractBuild build;

    public YouTrackCommandAction(AbstractBuild build) {
        this.build = build;
        this.commands = new ArrayList<Command>();
    }

    public String getIssueUrl() {
        YouTrackSite youTrackSite = YouTrackSite.get(this.build.getProject());
        return youTrackSite.getUrl() + "/issue/";
    }

    public boolean addCommand(Command command) {
        return this.commands.add(command);
    }

    public int getNumCommands() {
        return this.commands.size();
    }

    public String getIconFileName() {
        return "plugin.png";
    }

    public String getDisplayName() {
        return "YouTrack Commands";
    }

    public String getUrlName() {
        return "youtrackCommands";
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public AbstractBuild getBuild() {
        return this.build;
    }
}

