/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.youtrack;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.youtrack.Command;
import org.jenkinsci.plugins.youtrack.YouTrackCommandAction;
import org.jenkinsci.plugins.youtrack.YouTrackProjectProperty;
import org.jenkinsci.plugins.youtrack.YouTrackSaveProjectShortNamesAction;
import org.jenkinsci.plugins.youtrack.YouTrackSite;
import org.jenkinsci.plugins.youtrack.YoutrackIssueUpdater;
import org.jenkinsci.plugins.youtrack.youtrackapi.Issue;
import org.jenkinsci.plugins.youtrack.youtrackapi.Suggestion;
import org.jenkinsci.plugins.youtrack.youtrackapi.User;
import org.jenkinsci.plugins.youtrack.youtrackapi.YouTrackServer;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class ExecuteCommandAction
extends Builder {
    private static final Logger LOGGER = Logger.getLogger(ExecuteCommandAction.class.getName());
    private String command;
    private String search;
    private String issueInText;
    private String comment;
    private String commentVisibility;

    @DataBoundConstructor
    public ExecuteCommandAction(String command, String search, String issueInText, String comment, String commentVisibility) {
        this.command = command;
        this.search = search;
        this.issueInText = issueInText;
        this.comment = comment;
        this.commentVisibility = commentVisibility;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        YouTrackSite youTrackSite = this.getYouTrackSite(build);
        if (youTrackSite != null) {
            if (youTrackSite.isPluginEnabled()) {
                YouTrackServer youTrackServer = this.getYouTrackServer(youTrackSite);
                User user = youTrackServer.login(youTrackSite.getUsername(), youTrackSite.getPassword());
                if (user != null && user.isLoggedIn()) {
                    EnvVars environment = build.getEnvironment((TaskListener)listener);
                    try {
                        String changes = this.createChangesString(build, listener);
                        environment.put("YOUTRACK_CHANGES", changes);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        LOGGER.severe(e.getMessage());
                    }
                    String searchQuery = environment.expand(this.search);
                    String commandToExecute = environment.expand(this.command);
                    String expandedIssueInText = environment.expand(this.issueInText);
                    HashSet<Issue> issues = new HashSet<Issue>();
                    if (StringUtils.isNotBlank((String)searchQuery)) {
                        issues.addAll(youTrackServer.search(user, searchQuery));
                    }
                    if (StringUtils.isNotBlank((String)expandedIssueInText)) {
                        issues.addAll(this.findIssuesInText(build, environment, expandedIssueInText));
                    }
                    ArrayList<Command> appliedCommands = new ArrayList<Command>();
                    String expandedComment = environment.expand(this.comment);
                    for (Issue issue : issues) {
                        Command appliedCommand = youTrackServer.applyCommand(youTrackSite.getName(), user, issue, commandToExecute, expandedComment, this.commentVisibility, null, true);
                        appliedCommands.add(appliedCommand);
                        if (appliedCommand.getStatus() == Command.Status.OK) continue;
                        youTrackSite.failed(build);
                    }
                    if (!appliedCommands.isEmpty()) {
                        YouTrackCommandAction youTrackCommandAction = (YouTrackCommandAction)build.getAction(YouTrackCommandAction.class);
                        if (youTrackCommandAction == null) {
                            youTrackCommandAction = new YouTrackCommandAction(build);
                            build.addAction((Action)youTrackCommandAction);
                        }
                        for (Command appliedCommand : appliedCommands) {
                            youTrackCommandAction.addCommand(appliedCommand);
                        }
                    }
                    if (issues.isEmpty()) {
                        listener.getLogger().println("No issues to apply command for");
                    }
                } else {
                    youTrackSite.failed(build);
                    listener.getLogger().println("User not logged in");
                }
            } else {
                listener.getLogger().println("Plugin not enabled");
            }
        } else {
            listener.getLogger().println("No site configured");
        }
        return true;
    }

    String createChangesString(AbstractBuild<?, ?> build, BuildListener listener) throws InvocationTargetException, IllegalAccessException {
        StringBuilder stringBuilder = new StringBuilder();
        ChangeLogSet changeSet = build.getChangeSet();
        EnvVars environment = null;
        try {
            environment = build.getEnvironment((TaskListener)listener);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        if (changeSet != null) {
            for (ChangeLogSet.Entry entry : changeSet) {
                AbstractProject project = build.getProject();
                SCM scm = null;
                if (project != null) {
                    scm = project.getScm();
                }
                String message = YoutrackIssueUpdater.getMessage(scm, entry, listener, environment, build);
                stringBuilder.append(entry.getMsg());
                stringBuilder.append("\n\n");
            }
        }
        return stringBuilder.toString();
    }

    YouTrackServer getYouTrackServer(YouTrackSite youTrackSite) {
        return new YouTrackServer(youTrackSite.getUrl());
    }

    YouTrackSite getYouTrackSite(AbstractBuild<?, ?> build) {
        return YouTrackSite.get(build.getProject());
    }

    private List<Issue> findIssuesInText(AbstractBuild<?, ?> build, EnvVars environment, String issueInText) {
        String textToSearchForIssues = environment.expand(issueInText);
        YouTrackSaveProjectShortNamesAction projectShortNamesAction = (YouTrackSaveProjectShortNamesAction)build.getAction(YouTrackSaveProjectShortNamesAction.class);
        if (projectShortNamesAction != null) {
            return this.findIssuesIds(projectShortNamesAction.getShortNames(), textToSearchForIssues);
        }
        return new ArrayList<Issue>();
    }

    private List<Issue> findIssuesIds(List<String> projects, String issueText) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        String projectIds = StringUtils.join(projects, (String)"|");
        Pattern projectPattern = Pattern.compile("((" + projectIds + ")-" + "(\\d+)" + ")");
        Matcher matcher = projectPattern.matcher(issueText);
        while (matcher.find()) {
            if (matcher.groupCount() < 1) continue;
            String issueId = matcher.group(0);
            issues.add(new Issue(issueId));
        }
        return issues;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public String getIssueInText() {
        return this.issueInText;
    }

    public void setIssueInText(String issueInText) {
        this.issueInText = issueInText;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCommentVisibility() {
        return this.commentVisibility;
    }

    public void setCommentVisibility(String commentVisibility) {
        this.commentVisibility = commentVisibility;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Execute YouTrack Command";
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(ExecuteCommandAction.class, formData);
        }

        public AutoCompletionCandidates doAutoCompleteSearch(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            YouTrackServer youTrackServer;
            User user;
            YouTrackSite youTrackSite = YouTrackSite.get(project);
            AutoCompletionCandidates autoCompletionCandidates = new AutoCompletionCandidates();
            if (youTrackSite != null && (user = (youTrackServer = new YouTrackServer(youTrackSite.getUrl())).login(youTrackSite.getUsername(), youTrackSite.getPassword())) != null) {
                List<Suggestion> suggestions = youTrackServer.searchSuggestions(user, value);
                for (Suggestion suggestion : suggestions) {
                    if (suggestion.getCompletionStart() == 0) {
                        String completeSuggestion = this.emptyIfNull(suggestion.getPrefix()) + suggestion.getOption() + this.emptyIfNull(suggestion.getSuffix());
                        autoCompletionCandidates.add(completeSuggestion);
                        continue;
                    }
                    String validValue = value.substring(0, suggestion.getCompletionStart());
                    String completeSuggestion = this.emptyIfNull(suggestion.getPrefix()) + suggestion.getOption() + this.emptyIfNull(suggestion.getSuffix());
                    autoCompletionCandidates.add(validValue + completeSuggestion);
                }
            }
            return autoCompletionCandidates;
        }

        public String emptyIfNull(String text) {
            if (text == null) {
                return "";
            }
            return text;
        }

        public AutoCompletionCandidates doAutoCompleteCommentVisibility(@AncestorInPath AbstractProject project, @QueryParameter String value) {
            return YouTrackProjectProperty.getPossibleGroups(project, value);
        }
    }
}

