/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.threshold;

import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.TestResultSummary;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.kohsuke.stapler.DataBoundConstructor;

public class PassedThreshold
extends XUnitThreshold {
    @DataBoundConstructor
    public PassedThreshold() {
    }

    @Override
    public Result getResultThresholdNumber(XUnitLog log, Run<?, ?> build, TestResultSummary testResult, TestResultSummary previousTestResultAction) {
        int passedCount = testResult.getPassCount();
        int previousPassedCount = 0;
        if (previousTestResultAction != null) {
            previousPassedCount = previousTestResultAction.getPassCount();
        }
        int newPassedCount = passedCount - previousPassedCount;
        return this.getResultThresholdNumber(log, passedCount, newPassedCount);
    }

    @Override
    public Result getResultThresholdPercent(XUnitLog log, Run<?, ?> build, TestResultSummary testResult, TestResultSummary previousTestResultAction) {
        double newPassedCount;
        double count = testResult.getTotalCount();
        double passedCount = testResult.getPassCount();
        double percentPassed = passedCount == 0.0 ? 0.0 : passedCount / count * 100.0;
        double previousPassedCount = 0.0;
        if (previousTestResultAction != null) {
            previousPassedCount = previousTestResultAction.getPassCount();
        }
        double percentNewPassed = (newPassedCount = passedCount - previousPassedCount) == 0.0 ? 0.0 : newPassedCount / count * 100.0;
        return this.getResultThresholdPercent(log, percentPassed, percentNewPassed);
    }

    @Override
    public boolean isValidThreshold(double threshold, double value) {
        return value >= threshold;
    }
}

