/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.service;

import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jenkinsci.lib.dtkit.model.InputMetric;
import org.jenkinsci.lib.dtkit.util.validator.ValidationError;
import org.jenkinsci.lib.dtkit.util.validator.ValidationException;
import org.jenkinsci.plugins.xunit.service.Messages;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.service.XUnitToolInfo;

public class XUnitValidationService
implements Serializable {
    private static final long serialVersionUID = -5322330246285295896L;
    private XUnitLog xUnitLog;

    @Inject
    public XUnitValidationService(XUnitLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    public boolean checkFileIsNotEmpty(File inputFile) {
        try {
            return inputFile.getCanonicalFile().length() != 0L;
        }
        catch (IOException ex) {
            return inputFile.length() != 0L;
        }
    }

    public boolean validateInputFile(XUnitToolInfo xUnitToolInfo, File inputFile) {
        InputMetric inputMetric = xUnitToolInfo.getInputMetric();
        try {
            if (!inputMetric.validateInputFile(inputFile)) {
                this.xUnitLog.warn(Messages.XUnitValidationService_invalidInput(inputFile));
                for (ValidationError validatorError : inputMetric.getInputValidationErrors()) {
                    this.xUnitLog.warn(validatorError.toString());
                }
                return false;
            }
        }
        catch (ValidationException ve) {
            this.xUnitLog.error(ve.getMessage());
        }
        return true;
    }

    public boolean validateOutputFile(XUnitToolInfo xUnitToolInfo, File inputFile, File junitTargetFile) {
        InputMetric inputMetric = xUnitToolInfo.getInputMetric();
        try {
            boolean validateOutput = inputMetric.validateOutputFile(junitTargetFile);
            if (!validateOutput) {
                this.xUnitLog.warn(Messages.XUnitValidationService_invalidOutput(inputFile));
                for (ValidationError validatorError : inputMetric.getOutputValidationErrors()) {
                    this.xUnitLog.warn(validatorError.toString());
                }
                return false;
            }
        }
        catch (ValidationException ve) {
            this.xUnitLog.error(ve.getMessage());
        }
        return true;
    }
}

