/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultSummary;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.ChecksPublisher;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import io.jenkins.plugins.checks.api.ChecksStatus;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.xunit.XUnitProcessorResult;

class XUnitChecksPublisher {
    public static final String SEPARATOR = ", ";
    private static final int MAX_MSG_SIZE_TO_CHECKS_API = 65535;
    private final Run<?, ?> run;
    @NonNull
    private final String checksName;
    @NonNull
    private final TestResult result;
    @NonNull
    private final TestResultSummary summary;
    @NonNull
    private final Result buildResult;

    public XUnitChecksPublisher(Run<?, ?> run, @NonNull String checksName, @NonNull XUnitProcessorResult result, @NonNull Result buildResult) {
        this.run = run;
        this.checksName = checksName;
        this.result = result.getTestResult();
        this.summary = result.getTestResultSummary();
        this.buildResult = buildResult;
    }

    public void publishChecks(TaskListener listener) {
        ChecksPublisher publisher = ChecksPublisherFactory.fromRun(this.run, (TaskListener)listener);
        publisher.publish(this.extractChecksDetails());
    }

    ChecksDetails extractChecksDetails() {
        String testsURL = DisplayURLProvider.get().getTestsURL(this.run);
        ChecksOutput output = new ChecksOutput.ChecksOutputBuilder().withTitle(this.extractChecksTitle()).withSummary("<sub>Send us [feedback](https://github.com/jenkinsci/xunit-plugin/issues)").withText(this.extractChecksText(testsURL)).build();
        return new ChecksDetails.ChecksDetailsBuilder().withName(this.checksName).withStatus(ChecksStatus.COMPLETED).withConclusion(this.mapBuildResultToConclusion()).withDetailsURL(testsURL).withOutput(output).build();
    }

    private String extractChecksText(String testsURL) {
        StringBuilder builder = new StringBuilder();
        if (this.summary.getFailCount() > 0) {
            List failedTests = this.result.getFailedTests();
            for (CaseResult failedTest : failedTests) {
                String testReport = this.mapFailedTestToTestReport(failedTest);
                int messageSize = testReport.length() + builder.toString().length();
                if (messageSize > 64511) {
                    builder.append("\n").append("more test results are not shown here, view them on [Jenkins](").append(testsURL).append(")");
                    break;
                }
                builder.append(testReport);
            }
        }
        return builder.toString();
    }

    private String mapFailedTestToTestReport(CaseResult failedTest) {
        StringBuilder builder = new StringBuilder();
        builder.append("## `").append(failedTest.getTransformedFullDisplayName().trim()).append("`").append("\n");
        if (StringUtils.isNotBlank((String)failedTest.getErrorDetails())) {
            builder.append(this.codeTextFencedBlock(failedTest.getErrorDetails())).append("\n");
        }
        if (StringUtils.isNotBlank((String)failedTest.getErrorStackTrace())) {
            builder.append("<details><summary>Stack trace</summary>\n").append(this.codeTextFencedBlock(failedTest.getErrorStackTrace())).append("</details>\n");
        }
        if (StringUtils.isNotBlank((String)failedTest.getStderr())) {
            builder.append("<details><summary>Standard error</summary>\n").append(this.codeTextFencedBlock(failedTest.getStderr())).append("</details>\n");
        }
        if (StringUtils.isNotBlank((String)failedTest.getStdout())) {
            builder.append("<details><summary>Standard out</summary>\n").append(this.codeTextFencedBlock(failedTest.getStdout())).append("</details>\n");
        }
        builder.append("\n");
        return builder.toString();
    }

    private String codeTextFencedBlock(String body) {
        return "\n```text\n" + body.trim() + "\n```\n";
    }

    private String extractChecksTitle() {
        if (this.summary.getTotalCount() == 0) {
            return "No test results found";
        }
        StringBuilder builder = new StringBuilder();
        if (this.summary.getFailCount() == 1) {
            CaseResult failedTest = (CaseResult)this.result.getFailedTests().get(0);
            builder.append(failedTest.getTransformedFullDisplayName()).append(" failed");
            return builder.toString();
        }
        if (this.summary.getFailCount() > 0) {
            builder.append("failed: ").append(this.summary.getFailCount());
            if (this.summary.getSkipCount() > 0 || this.summary.getPassCount() > 0) {
                builder.append(SEPARATOR);
            }
        }
        if (this.summary.getSkipCount() > 0) {
            builder.append("skipped: ").append(this.summary.getSkipCount());
            if (this.summary.getPassCount() > 0) {
                builder.append(SEPARATOR);
            }
        }
        if (this.summary.getPassCount() > 0) {
            builder.append("passed: ").append(this.summary.getPassCount());
        }
        return builder.toString();
    }

    private ChecksConclusion mapBuildResultToConclusion() {
        return this.buildResult == Result.SUCCESS ? ChecksConclusion.SUCCESS : ChecksConclusion.FAILURE;
    }
}

