/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.AbortException;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResultSummary;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.lib.dtkit.descriptor.TestTypeDescriptor;
import org.jenkinsci.lib.dtkit.type.TestType;
import org.jenkinsci.plugins.xunit.ExtraConfiguration;
import org.jenkinsci.plugins.xunit.Messages;
import org.jenkinsci.plugins.xunit.XUnitProcessor;
import org.jenkinsci.plugins.xunit.XUnitUtil;
import org.jenkinsci.plugins.xunit.service.TransformerException;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.jenkinsci.plugins.xunit.threshold.XUnitThresholdDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class XUnitPublisher
extends Recorder
implements SimpleBuildStep {
    @XStreamAlias(value="types")
    private TestType[] tools;
    private XUnitThreshold[] thresholds;
    private int thresholdMode;
    private ExtraConfiguration extraConfiguration;
    private Collection<TestDataPublisher> testDataPublishers;

    @DataBoundConstructor
    public XUnitPublisher(@CheckForNull TestType[] tools, @CheckForNull XUnitThreshold[] thresholds, int thresholdMode, @CheckForNull String testTimeMargin) {
        this.tools = tools != null ? Arrays.copyOf(tools, tools.length) : new TestType[]{};
        this.thresholds = thresholds != null ? Arrays.copyOf(thresholds, thresholds.length) : new XUnitThreshold[]{};
        this.thresholdMode = thresholdMode;
        long longTestTimeMargin = XUnitUtil.parsePositiveLong(testTimeMargin, 3000L);
        this.extraConfiguration = new ExtraConfiguration(longTestTimeMargin, true, 10L, true);
        this.testDataPublishers = Collections.emptySet();
    }

    @DataBoundSetter
    public void setReduceLog(boolean reduceLog) {
        this.extraConfiguration = ExtraConfiguration.withConfiguration(this.extraConfiguration).reduceLog(reduceLog).build();
    }

    public boolean getReduceLog() {
        return this.extraConfiguration.isReduceLog();
    }

    @DataBoundSetter
    public void setSleepTime(long sleepTime) {
        this.extraConfiguration = ExtraConfiguration.withConfiguration(this.extraConfiguration).sleepTime(sleepTime > 0L ? sleepTime : 0L).build();
    }

    public boolean getSleepTime() {
        return this.extraConfiguration.isReduceLog();
    }

    @DataBoundSetter
    public void setFollowSymlink(boolean followSymlink) {
        this.extraConfiguration = ExtraConfiguration.withConfiguration(this.extraConfiguration).followSymlink(followSymlink).build();
    }

    public boolean getFollowSymlink() {
        return this.extraConfiguration.isFollowSymlink();
    }

    @Nonnull
    public TestType[] getTools() {
        return this.tools;
    }

    @Nonnull
    public String getTestTimeMargin() {
        return String.valueOf(this.getExtraConfiguration().getTestTimeMargin());
    }

    @Nonnull
    public XUnitThreshold[] getThresholds() {
        return this.thresholds;
    }

    public int getThresholdMode() {
        return this.thresholdMode;
    }

    @Nonnull
    public ExtraConfiguration getExtraConfiguration() {
        if (this.extraConfiguration == null) {
            this.extraConfiguration = new ExtraConfiguration(3000L, true, 10L, true);
        }
        return this.extraConfiguration;
    }

    @Nonnull
    public Collection<TestDataPublisher> getTestDataPublishers() {
        return this.testDataPublishers != null ? this.testDataPublishers : Collections.emptyList();
    }

    @DataBoundSetter
    public void setTestDataPublishers(@CheckForNull Collection<TestDataPublisher> testDataPublishers) {
        this.testDataPublishers = testDataPublishers != null ? new LinkedList<TestDataPublisher>(testDataPublishers) : Collections.emptyList();
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        JUnitResultArchiver jUnitResultArchiver = (JUnitResultArchiver)project.getPublishersList().get(JUnitResultArchiver.class);
        if (jUnitResultArchiver == null) {
            return new TestResultProjectAction(project);
        }
        return null;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        try {
            XUnitProcessor xUnitProcessor = new XUnitProcessor(this.getTools(), this.getThresholds(), this.getThresholdMode(), this.getExtraConfiguration());
            TestResultSummary testResult = xUnitProcessor.process(build, workspace, listener, launcher, this.getTestDataPublishers(), null);
            XUnitLog logger = new XUnitLog(listener);
            if (testResult.getTotalCount() == 0) {
                logger.warn(Messages.xUnitProcessor_emptyReport());
            }
            Result result = xUnitProcessor.getBuildStatus(testResult, build);
            logger.info("Setting the build status to " + result);
            build.setResult(result);
        }
        catch (AbortException e) {
            build.setResult(Result.FAILURE);
            throw e;
        }
        catch (TransformerException e) {
            build.setResult(Result.FAILURE);
            throw new AbortException(e.getMessage());
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class XUnitDescriptorPublisher
    extends BuildStepDescriptor<Publisher> {
        public XUnitDescriptorPublisher() {
            super(XUnitPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.xUnit_PublisherName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/xunit/help.html";
        }

        public DescriptorExtensionList<TestType, TestTypeDescriptor<?>> getListXUnitTypeDescriptors() {
            return TestTypeDescriptor.all();
        }

        public DescriptorExtensionList<TestDataPublisher, Descriptor<TestDataPublisher>> getListTestDataPublisherDescriptors() {
            return TestDataPublisher.all();
        }

        public DescriptorExtensionList<XUnitThreshold, XUnitThresholdDescriptor<?>> getListXUnitThresholdDescriptors() {
            return XUnitThresholdDescriptor.all();
        }

        public FormValidation doCheckSleepTime(@QueryParameter long sleepTime) {
            if (sleepTime < 0L) {
                return FormValidation.error((String)Messages.xUnitProcessor_checkSleepTime());
            }
            return FormValidation.ok();
        }
    }
}

