/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.service;

import com.google.inject.Inject;
import hudson.Util;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.plugins.xunit.service.Messages;
import org.jenkinsci.plugins.xunit.service.NoNewTestReportException;
import org.jenkinsci.plugins.xunit.service.NoTestFoundException;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.service.XUnitToolInfo;

public class XUnitReportProcessorService
implements Serializable {
    private static final long serialVersionUID = 2640258179567685368L;
    private XUnitLog xUnitLog;

    @Inject
    public XUnitReportProcessorService(XUnitLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    public boolean isEmptyPattern(String pattern) {
        return Util.fixEmptyAndTrim((String)pattern) == null;
    }

    public List<String> findReports(XUnitToolInfo xUnitToolInfo, File parentPath, String pattern) throws NoTestFoundException {
        String toolName = xUnitToolInfo.getInputMetric().getLabel();
        FileSet fs = Util.createFileSet((File)parentPath, (String)pattern);
        DirectoryScanner ds = fs.getDirectoryScanner();
        String[] xunitFiles = ds.getIncludedFiles();
        if (xunitFiles.length == 0) {
            String msg = Messages.XUnitReportProcessorService_reportsNotFound(toolName, pattern, parentPath);
            throw new NoTestFoundException(msg);
        }
        String msg = Messages.XUnitReportProcessorService_reportsFound(toolName, xunitFiles.length, pattern, parentPath);
        this.xUnitLog.info(msg);
        return Arrays.asList(xunitFiles);
    }

    public void checkIfFindsFilesNewFiles(XUnitToolInfo xUnitToolInfo, List<String> files, File workspace) throws NoNewTestReportException {
        if (xUnitToolInfo.isFailIfNotNew()) {
            ArrayList<File> oldResults = new ArrayList<File>();
            for (String value : files) {
                File reportFile = new File(workspace, value);
                if (xUnitToolInfo.getBuildTime() - xUnitToolInfo.getTestTimeMargin() <= reportFile.lastModified()) continue;
                oldResults.add(reportFile);
            }
            if (!oldResults.isEmpty()) {
                long localTime = System.currentTimeMillis();
                if (localTime < xUnitToolInfo.getBuildTime() - 1000L) {
                    throw new NoNewTestReportException(Messages.XUnitReportProcessorService_clockOutOfSync());
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("Test reports were found but not all of them are new. Did all the tests run?%n", new Object[0]));
                for (File f : oldResults) {
                    stringBuilder.append(String.format("  * %s is %s old%n", f, Util.getTimeSpanString((long)(xUnitToolInfo.getBuildTime() - f.lastModified()))));
                }
                String msg = stringBuilder.toString();
                throw new NoNewTestReportException(msg);
            }
        }
    }

    public File getCurrentReport(File root, String name) {
        return new File(root, name);
    }

    public boolean isStopProcessingIfError(XUnitToolInfo xUnitToolInfo) {
        return xUnitToolInfo.isStopProcessingIfError();
    }
}

