/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Singleton;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.junit.TestDataPublisher;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.PipelineTestDetails;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.SlaveToMasterFileCallable;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.lib.dtkit.model.InputMetric;
import org.jenkinsci.lib.dtkit.model.InputMetricXSL;
import org.jenkinsci.lib.dtkit.type.TestType;
import org.jenkinsci.plugins.xunit.ExtraConfiguration;
import org.jenkinsci.plugins.xunit.Messages;
import org.jenkinsci.plugins.xunit.service.NoTestFoundException;
import org.jenkinsci.plugins.xunit.service.TransformerException;
import org.jenkinsci.plugins.xunit.service.XUnitConversionService;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.service.XUnitReportProcessorService;
import org.jenkinsci.plugins.xunit.service.XUnitToolInfo;
import org.jenkinsci.plugins.xunit.service.XUnitTransformerCallable;
import org.jenkinsci.plugins.xunit.service.XUnitValidationService;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.jenkinsci.plugins.xunit.types.CustomType;
import org.jenkinsci.plugins.xunit.util.DownloadableResourceUtil;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class XUnitProcessor {
    private final TestType[] tools;
    private final XUnitThreshold[] thresholds;
    private final int thresholdMode;
    private final ExtraConfiguration extraConfiguration;
    private final String processorId;
    private XUnitLog logger;

    public XUnitProcessor(@Nonnull TestType[] tools, @CheckForNull XUnitThreshold[] thresholds, int thresholdMode, @Nonnull ExtraConfiguration extraConfiguration) {
        if (tools == null) {
            throw new IllegalArgumentException("The tools section is required.");
        }
        if (extraConfiguration == null) {
            throw new IllegalArgumentException("The extra configuration is required.");
        }
        this.tools = Arrays.copyOf(tools, tools.length);
        this.thresholds = thresholds != null ? Arrays.copyOf(thresholds, thresholds.length) : new XUnitThreshold[]{};
        this.thresholdMode = thresholdMode;
        this.extraConfiguration = extraConfiguration;
        this.processorId = UUID.randomUUID().toString();
    }

    public void process(Run<?, ?> build, FilePath workspace, TaskListener listener, Launcher launcher, @Nonnull Collection<TestDataPublisher> testDataPublishers, @CheckForNull PipelineTestDetails pipelineTestDetails) throws IOException, InterruptedException {
        this.logger = new XUnitLog(listener);
        this.logger.info("Starting to record.");
        int processedReports = this.processTestsReport(build, workspace, listener);
        if (processedReports == 0) {
            this.logger.info("Skipping tests recording.");
            return;
        }
        TestResult testResult = this.recordTestResult(build, workspace, listener, launcher, testDataPublishers, pipelineTestDetails);
        if (testResult != null) {
            this.processDeletion(workspace);
            if (pipelineTestDetails == null) {
                Result result = this.getBuildStatus(testResult, build);
                this.logger.info("Setting the build status to " + result);
                build.setResult(result);
            }
        }
        this.logger.info("Stopping recording.");
    }

    private int processTestsReport(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        int processedReports = 0;
        XUnitReportProcessorService xUnitReportService = new XUnitReportProcessorService(this.logger);
        for (TestType tool : this.tools) {
            this.logger.info("Processing " + tool.getDescriptor().getDisplayName());
            if (this.isEmptyGivenPattern(xUnitReportService, tool)) continue;
            XUnitToolInfo xUnitToolInfo = this.buildXUnitToolInfo(tool, build, workspace, listener);
            XUnitTransformerCallable xUnitTransformer = this.newXUnitTransformer(xUnitToolInfo);
            try {
                processedReports += ((Integer)workspace.act((FilePath.FileCallable)xUnitTransformer)).intValue();
            }
            catch (IOException e) {
                Throwable nested = this.unwrapSlaveException(e);
                if (nested instanceof NoTestFoundException) {
                    if (xUnitToolInfo.isSkipNoTestFiles()) {
                        this.logger.info(e.getMessage());
                        continue;
                    }
                    throw (NoTestFoundException)nested;
                }
                throw e;
            }
        }
        return processedReports;
    }

    private Throwable unwrapSlaveException(IOException e) {
        Throwable nested = e.getCause();
        while (nested != null && !(nested instanceof TransformerException)) {
            nested = e.getCause();
        }
        if (nested == null) {
            nested = e;
        }
        return nested;
    }

    private boolean isEmptyGivenPattern(XUnitReportProcessorService xUnitReportService, TestType tool) {
        return xUnitReportService.isEmptyPattern(tool.getPattern());
    }

    private String getExpandedResolvedPattern(TestType tool, Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        String newExpandedPattern = tool.getPattern();
        newExpandedPattern = newExpandedPattern.replaceAll("[\t\r\n]+", " ");
        return Util.replaceMacro((String)newExpandedPattern, (Map)build.getEnvironment(listener));
    }

    protected XUnitToolInfo buildXUnitToolInfo(TestType tool, Run<?, ?> build, FilePath workspace, final TaskListener listener) throws IOException, InterruptedException {
        InputMetric inputMetric = tool.getInputMetric();
        inputMetric = (InputMetric)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(TaskListener.class).toInstance((Object)listener);
                this.bind(XUnitLog.class).in(Singleton.class);
                this.bind(XUnitValidationService.class).in(Singleton.class);
                this.bind(XUnitConversionService.class).in(Singleton.class);
            }
        }}).getInstance(inputMetric.getClass());
        String xslContent = null;
        if (tool instanceof CustomType) {
            xslContent = this.getCustomStylesheet(tool, build, workspace, listener);
        } else if (inputMetric instanceof InputMetricXSL) {
            xslContent = this.getUserStylesheet(tool);
        }
        String pattern = this.getExpandedResolvedPattern(tool, build, listener);
        return new XUnitToolInfo(inputMetric, pattern, tool.isSkipNoTestFiles(), tool.isFailIfNotNew(), tool.isDeleteOutputFiles(), tool.isStopProcessingIfError(), build.getTimeInMillis(), this.extraConfiguration.getTestTimeMargin(), xslContent);
    }

    private String getUserStylesheet(TestType tool) throws IOException, InterruptedException {
        InputMetricXSL inputMetricXSL;
        File userContent = new File(Jenkins.getInstance().getRootDir(), "userContent");
        FilePath xslUserContent = new FilePath(new File(userContent, (inputMetricXSL = (InputMetricXSL)tool.getInputMetric()).getUserContentXSLDirRelativePath()));
        if (!xslUserContent.exists()) {
            return null;
        }
        for (FilePath stylesheet : xslUserContent.list("*.xsl")) {
            if (stylesheet.isDirectory()) continue;
            this.logger.info("Using the custom user stylesheet " + stylesheet.getName() + " in JENKINS_HOME.");
            try (InputStream is = stylesheet.read();){
                String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
                return string;
            }
        }
        return null;
    }

    private String getCustomStylesheet(TestType tool, Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        String customXSLPath = Util.replaceMacro((String)((CustomType)tool).getCustomXSL(), (Map)build.getEnvironment(listener));
        if (DownloadableResourceUtil.isURL(customXSLPath)) {
            return DownloadableResourceUtil.download(customXSLPath);
        }
        FilePath customXSLFilePath = new FilePath(new File(customXSLPath));
        if (!(customXSLFilePath.exists() || (customXSLFilePath = new FilePath(workspace.getChannel(), customXSLPath)).exists() || (customXSLFilePath = workspace.child(customXSLPath)).exists())) {
            throw new FileNotFoundException(Messages.xUnitProcessor_xslFileNotFound(customXSLPath));
        }
        try (InputStream is = customXSLFilePath.read();){
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
    }

    private XUnitTransformerCallable newXUnitTransformer(final XUnitToolInfo xUnitToolInfo) {
        XUnitTransformerCallable transformer = (XUnitTransformerCallable)((Object)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(XUnitToolInfo.class).toInstance((Object)xUnitToolInfo);
                this.bind(XUnitValidationService.class).in(Singleton.class);
                this.bind(XUnitConversionService.class).in(Singleton.class);
                this.bind(XUnitLog.class).toInstance((Object)XUnitProcessor.this.logger);
                this.bind(XUnitReportProcessorService.class).in(Singleton.class);
            }
        }}).getInstance(XUnitTransformerCallable.class));
        transformer.setProcessorId(this.processorId);
        return transformer;
    }

    private TestResult getPreviousTestResult(Run<?, ?> build) {
        Run previousBuild = build.getPreviousCompletedBuild();
        if (previousBuild == null) {
            return null;
        }
        TestResultAction previousAction = (TestResultAction)previousBuild.getAction(TestResultAction.class);
        if (previousAction == null) {
            return null;
        }
        return previousAction.getResult();
    }

    private TestResult recordTestResult(Run<?, ?> build, FilePath workspace, TaskListener listener, Launcher launcher, Collection<TestDataPublisher> testDataPublishers, PipelineTestDetails pipelineTestDetails) throws IOException, InterruptedException {
        long nowMaster;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        long buildTime = build.getTimestamp().getTimeInMillis();
        TestResult result = this.getTestResult(workspace, "**/TEST-*.xml", buildTime, nowMaster = System.currentTimeMillis(), pipelineTestDetails);
        if (result != null) {
            TestResultAction action;
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                result.freeze(action);
                action.mergeResult(result, listener);
            }
            result.tally();
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                this.logger.warn(Messages.xUnitProcessor_emptyReport());
            }
            for (TestDataPublisher tdp : testDataPublishers) {
                TestResultAction.Data d = tdp.contributeTestData(build, workspace, launcher, listener, result);
                if (d == null) continue;
                action.addData(d);
            }
            if (existingAction == null) {
                build.addAction((Action)action);
            }
        }
        return result;
    }

    private TestResult getTestResult(FilePath workspace, String junitFilePattern, long buildTime, long nowMaster, PipelineTestDetails pipelineTestDetails) throws IOException, InterruptedException {
        return (TestResult)workspace.act((FilePath.FileCallable)new ReportParserCallable(buildTime, junitFilePattern, nowMaster, this.processorId, pipelineTestDetails));
    }

    @Restricted(value={NoExternalUse.class})
    @Nonnull
    public Result getBuildStatus(TestResult result, Run<?, ?> build) {
        Result curResult = this.processResultThreshold(result, build);
        Result previousResultStep = build.getResult();
        if (previousResultStep == null) {
            return curResult;
        }
        if (previousResultStep != Result.NOT_BUILT && previousResultStep.isWorseOrEqualTo(curResult)) {
            curResult = previousResultStep;
        }
        return curResult;
    }

    @Nonnull
    private Result processResultThreshold(TestResult testResult, Run<?, ?> build) {
        TestResult previousTestResult = this.getPreviousTestResult(build);
        if (this.thresholds != null) {
            for (XUnitThreshold threshold : this.thresholds) {
                this.logger.info(Messages.xUnitProcessor_checkThreshold(threshold.getDescriptor().getDisplayName()));
                Result result = 2 == this.thresholdMode ? threshold.getResultThresholdPercent(this.logger, build, testResult, previousTestResult) : threshold.getResultThresholdNumber(this.logger, build, testResult, previousTestResult);
                if (!result.isWorseThan(Result.SUCCESS)) continue;
                return result;
            }
        }
        return Result.SUCCESS;
    }

    private void processDeletion(FilePath workspace) throws IOException, InterruptedException {
        FilePath generatedJUnitDir = workspace.child("generatedJUnitFiles").child(this.processorId);
        boolean keepJUnitDirectory = false;
        for (TestType tool : this.tools) {
            InputMetric inputMetric = tool.getInputMetric();
            if (tool.isDeleteOutputFiles()) {
                generatedJUnitDir.child(inputMetric.getToolName()).deleteRecursive();
                continue;
            }
            keepJUnitDirectory = true;
        }
        if (!keepJUnitDirectory) {
            generatedJUnitDir.deleteRecursive();
        }
    }

    private static final class ReportParserCallable
    extends SlaveToMasterFileCallable<TestResult> {
        private static final long serialVersionUID = 1L;
        private final String junitFilePattern;
        private final long buildTime;
        private final long nowMaster;
        private final String processorId;
        private final PipelineTestDetails pipelineTestDetails;

        public ReportParserCallable(long buildTime, @Nonnull String junitFilePattern, long nowMaster, String processorId, PipelineTestDetails pipelineTestDetails) {
            this.buildTime = buildTime;
            this.junitFilePattern = junitFilePattern;
            this.nowMaster = nowMaster;
            this.processorId = processorId;
            this.pipelineTestDetails = pipelineTestDetails;
        }

        public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
            long nowSlave = System.currentTimeMillis();
            File generatedJUnitDir = new File(new File(ws, "generatedJUnitFiles"), this.processorId);
            FileUtils.forceMkdir((File)generatedJUnitDir);
            FileSet fs = Util.createFileSet((File)generatedJUnitDir, (String)this.junitFilePattern);
            DirectoryScanner ds = fs.getDirectoryScanner();
            String[] files = ds.getIncludedFiles();
            if (files.length == 0) {
                return null;
            }
            return new TestResult(this.buildTime + (nowSlave - this.nowMaster), ds, true, this.pipelineTestDetails);
        }
    }
}

