/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.service;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.inject.Inject;
import org.jenkinsci.lib.dtkit.model.InputMetric;
import org.jenkinsci.lib.dtkit.util.validator.ValidationError;
import org.jenkinsci.lib.dtkit.util.validator.ValidationException;
import org.jenkinsci.plugins.xunit.exception.XUnitException;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.service.XUnitToolInfo;

public class XUnitValidationService
implements Serializable {
    private XUnitLog xUnitLog;

    @Inject
    public XUnitValidationService(XUnitLog xUnitLog) {
        this.xUnitLog = xUnitLog;
    }

    public boolean checkFileIsNotEmpty(File inputFile) {
        try {
            return inputFile.getCanonicalFile().length() != 0L;
        }
        catch (IOException ex) {
            return inputFile.length() != 0L;
        }
    }

    public boolean validateInputFile(XUnitToolInfo xUnitToolInfo, File inputFile) throws XUnitException {
        InputMetric inputMetric = xUnitToolInfo.getInputMetric();
        try {
            if (!inputMetric.validateInputFile(inputFile)) {
                this.xUnitLog.warn("The file '" + inputFile + "' is an invalid file.");
                for (ValidationError validatorError : inputMetric.getInputValidationErrors()) {
                    this.xUnitLog.warn(validatorError.toString());
                }
                return false;
            }
        }
        catch (ValidationException ve) {
            throw new XUnitException("Validation error on input", ve);
        }
        return true;
    }

    public boolean validateOutputFile(XUnitToolInfo xUnitToolInfo, File inputFile, File junitTargetFile) throws XUnitException {
        InputMetric inputMetric = xUnitToolInfo.getInputMetric();
        try {
            boolean validateOutput = inputMetric.validateOutputFile(junitTargetFile);
            if (!validateOutput) {
                this.xUnitLog.warn("The converted file for the input file '" + inputFile + "' doesn't match the JUnit format");
                for (ValidationError validatorError : inputMetric.getOutputValidationErrors()) {
                    this.xUnitLog.warn(validatorError.toString());
                }
                return false;
            }
        }
        catch (ValidationException ve) {
            throw new XUnitException("Validation error on output", ve);
        }
        return true;
    }
}

