/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.thalesgroup.dtkit.metrics.hudson.api.descriptor.TestTypeDescriptor;
import com.thalesgroup.dtkit.metrics.hudson.api.type.TestType;
import com.thalesgroup.dtkit.metrics.model.InputMetric;
import com.thalesgroup.hudson.plugins.xunit.exception.XUnitException;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitConversionService;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitLog;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitReportProcessorService;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitToolInfo;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitTransformer;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitValidationService;
import com.thalesgroup.hudson.plugins.xunit.types.CustomType;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.junit.JUnitResultArchiver;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.lib.dryrun.DryRun;
import org.jenkinsci.plugins.xunit.Messages;
import org.jenkinsci.plugins.xunit.SkipTestException;
import org.jenkinsci.plugins.xunit.threshold.FailedThreshold;
import org.jenkinsci.plugins.xunit.threshold.SkippedThreshold;
import org.jenkinsci.plugins.xunit.threshold.XUnitThreshold;
import org.jenkinsci.plugins.xunit.threshold.XUnitThresholdDescriptor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitPublisher
extends Recorder
implements DryRun,
Serializable {
    public static final String GENERATED_JUNIT_DIR = "generatedJUnitFiles";
    private TestType[] types;
    private XUnitThreshold[] thresholds;
    private int thresholdMode;
    private static final int MODE_NUMBER = 1;
    private static final int MODE_PERCENT = 2;

    public XUnitPublisher(TestType[] types, XUnitThreshold[] thresholds) {
        this.types = types;
        this.thresholds = thresholds;
    }

    public XUnitPublisher(TestType[] types, XUnitThreshold[] thresholds, int thresholdMode) {
        this.types = types;
        this.thresholds = thresholds;
        this.thresholdMode = thresholdMode;
    }

    public TestType[] getTypes() {
        return this.types;
    }

    public XUnitThreshold[] getThresholds() {
        return this.thresholds;
    }

    public int getThresholdMode() {
        return this.thresholdMode;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        JUnitResultArchiver jUnitResultArchiver = (JUnitResultArchiver)project.getPublishersList().get(JUnitResultArchiver.class);
        if (jUnitResultArchiver == null) {
            return new TestResultProjectAction(project);
        }
        return null;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this.performXUnit(false, build, listener);
    }

    public boolean performDryRun(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        try {
            this.performXUnit(true, build, listener);
        }
        catch (Throwable t) {
            listener.getLogger().println("[ERROR] - There is an error: " + t.getCause().getMessage());
        }
        build.setResult(Result.SUCCESS);
        return true;
    }

    private boolean performXUnit(boolean dryRun, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        XUnitLog xUnitLog = this.getXUnitLogObject(listener);
        try {
            boolean continueTestProcessing;
            xUnitLog.infoConsoleLogger("Starting to record.");
            try {
                continueTestProcessing = this.performTests(xUnitLog, build, listener);
            }
            catch (StopTestProcessingException e) {
                build.setResult(Result.FAILURE);
                xUnitLog.infoConsoleLogger("There are errors when processing test results.");
                xUnitLog.infoConsoleLogger("Skipping tests recording.");
                xUnitLog.infoConsoleLogger("Stop build.");
                return true;
            }
            if (!continueTestProcessing) {
                xUnitLog.infoConsoleLogger("There are errors when processing test results.");
                xUnitLog.infoConsoleLogger("Skipping tests recording.");
                return true;
            }
            this.recordTestResult(build, listener, xUnitLog);
            this.processDeletion(dryRun, build, xUnitLog);
            Result result = this.getBuildStatus(build, xUnitLog);
            if (result != null) {
                if (!dryRun) {
                    xUnitLog.infoConsoleLogger("Setting the build status to " + result);
                    build.setResult(result);
                } else {
                    xUnitLog.infoConsoleLogger("Through the xUnit plugin, the build status will be set to " + result.toString());
                }
            }
            xUnitLog.infoConsoleLogger("Stopping recording.");
            return true;
        }
        catch (XUnitException xe) {
            xUnitLog.errorConsoleLogger("The plugin hasn't been performed correctly: " + xe.getMessage());
            build.setResult(Result.FAILURE);
            return false;
        }
    }

    private XUnitLog getXUnitLogObject(final BuildListener listener) {
        return (XUnitLog)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(BuildListener.class).toInstance((Object)listener);
            }
        }}).getInstance(XUnitLog.class);
    }

    private XUnitReportProcessorService getXUnitReportProcessorServiceObject(final BuildListener listener) {
        return (XUnitReportProcessorService)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(BuildListener.class).toInstance((Object)listener);
            }
        }}).getInstance(XUnitReportProcessorService.class);
    }

    private boolean performTests(XUnitLog xUnitLog, AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException, StopTestProcessingException {
        XUnitReportProcessorService xUnitReportService = this.getXUnitReportProcessorServiceObject(listener);
        boolean continueTestProcessing = true;
        for (TestType tool : this.types) {
            continueTestProcessing = true;
            xUnitLog.infoConsoleLogger("Processing " + tool.getDescriptor().getDisplayName());
            if (this.isEmptyGivenPattern(xUnitReportService, tool)) continue;
            String expandedPattern = this.getExpandedResolvedPattern(tool, build, listener);
            XUnitToolInfo xUnitToolInfo = this.getXUnitToolInfoObject(tool, expandedPattern, build, listener);
            XUnitTransformer xUnitTransformer = this.getXUnitTransformerObject(xUnitToolInfo, listener);
            boolean result = false;
            try {
                result = (Boolean)this.getWorkspace(build).act((FilePath.FileCallable)xUnitTransformer);
            }
            catch (SkipTestException se) {
                xUnitLog.infoConsoleLogger("Skipping the metric tool processing.");
                continueTestProcessing = false;
            }
            if (result) continue;
            if (xUnitToolInfo.isStopProcessingIfError()) {
                xUnitLog.infoConsoleLogger("Fail BUILD because 'set build failed if errors' option is activated.");
                throw new StopTestProcessingException();
            }
            continueTestProcessing = false;
        }
        return continueTestProcessing;
    }

    private boolean isEmptyGivenPattern(XUnitReportProcessorService xUnitReportService, TestType tool) {
        return xUnitReportService.isEmptyPattern(tool.getPattern());
    }

    private String getExpandedResolvedPattern(TestType tool, AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
        String newExpandedPattern = tool.getPattern();
        newExpandedPattern = newExpandedPattern.replaceAll("[\t\r\n]+", " ");
        return Util.replaceMacro((String)newExpandedPattern, (Map)build.getEnvironment((TaskListener)listener));
    }

    private XUnitToolInfo getXUnitToolInfoObject(TestType tool, String expandedPattern, AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
        return new XUnitToolInfo(new FilePath(new File(Hudson.getInstance().getRootDir(), "userContent")), tool.getInputMetric(), expandedPattern, tool.isSkipNoTestFiles(), tool.isFailIfNotNew(), tool.isDeleteOutputFiles(), tool.isStopProcessingIfError(), build.getTimeInMillis(), tool instanceof CustomType ? this.getWorkspace(build).child(Util.replaceMacro((String)((CustomType)tool).getCustomXSL(), (Map)build.getEnvironment((TaskListener)listener))) : null);
    }

    private FilePath getWorkspace(AbstractBuild build) {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            workspace = build.getProject().getSomeWorkspace();
        }
        return workspace;
    }

    private XUnitTransformer getXUnitTransformerObject(final XUnitToolInfo xUnitToolInfo, final BuildListener listener) {
        return (XUnitTransformer)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.bind(BuildListener.class).toInstance((Object)listener);
                this.bind(XUnitToolInfo.class).toInstance((Object)xUnitToolInfo);
                this.bind(XUnitValidationService.class).in(Singleton.class);
                this.bind(XUnitConversionService.class).in(Singleton.class);
                this.bind(XUnitLog.class).in(Singleton.class);
                this.bind(XUnitReportProcessorService.class).in(Singleton.class);
            }
        }}).getInstance(XUnitTransformer.class);
    }

    private TestResultAction getTestResultAction(AbstractBuild<?, ?> build) {
        return (TestResultAction)build.getAction(TestResultAction.class);
    }

    private TestResultAction getPreviousTestResultAction(AbstractBuild<?, ?> build) {
        AbstractBuild previousBuild = (AbstractBuild)build.getPreviousBuild();
        if (previousBuild == null) {
            return null;
        }
        return this.getTestResultAction(previousBuild);
    }

    private void recordTestResult(AbstractBuild<?, ?> build, BuildListener listener, XUnitLog xUnitLog) throws XUnitException {
        TestResult result;
        TestResultAction existingAction = (TestResultAction)build.getAction(TestResultAction.class);
        long buildTime = build.getTimestamp().getTimeInMillis();
        long nowMaster = System.currentTimeMillis();
        TestResult existingTestResults = null;
        if (existingAction != null) {
            existingTestResults = existingAction.getResult();
        }
        if ((result = this.getTestResult(build, "**/TEST-*.xml", existingTestResults, buildTime, nowMaster)) != null) {
            TestResultAction action;
            if (existingAction == null) {
                action = new TestResultAction(build, result, listener);
            } else {
                action = existingAction;
                action.setResult(result, listener);
            }
            if (result.getPassCount() == 0 && result.getFailCount() == 0) {
                xUnitLog.warningConsoleLogger("All test reports are empty.");
            }
            if (existingAction == null) {
                build.getActions().add(action);
            }
        }
    }

    private TestResult getTestResult(AbstractBuild<?, ?> build, final String junitFilePattern, final TestResult existingTestResults, final long buildTime, final long nowMaster) throws XUnitException {
        try {
            return (TestResult)this.getWorkspace(build).act((FilePath.FileCallable)new FilePath.FileCallable<TestResult>(){

                public TestResult invoke(File ws, VirtualChannel channel) throws IOException {
                    long nowSlave = System.currentTimeMillis();
                    File generatedJunitDir = new File(ws, XUnitPublisher.GENERATED_JUNIT_DIR);
                    generatedJunitDir.mkdirs();
                    FileSet fs = Util.createFileSet((File)generatedJunitDir, (String)junitFilePattern);
                    DirectoryScanner ds = fs.getDirectoryScanner();
                    String[] files = ds.getIncludedFiles();
                    if (files.length == 0) {
                        return null;
                    }
                    try {
                        if (existingTestResults == null) {
                            return new TestResult(buildTime + (nowSlave - nowMaster), ds, true);
                        }
                        existingTestResults.parse(buildTime + (nowSlave - nowMaster), ds);
                        return existingTestResults;
                    }
                    catch (IOException ioe) {
                        throw new IOException(ioe);
                    }
                }
            });
        }
        catch (IOException ioe) {
            throw new XUnitException(ioe.getMessage(), ioe);
        }
        catch (InterruptedException ie) {
            throw new XUnitException(ie.getMessage(), ie);
        }
    }

    private Result getBuildStatus(AbstractBuild<?, ?> build, XUnitLog xUnitLog) {
        Result curResult = this.getResultWithThreshold(xUnitLog, build);
        Result previousResultStep = build.getResult();
        if (curResult != null && previousResultStep != null) {
            if (previousResultStep.isWorseOrEqualTo(curResult)) {
                curResult = previousResultStep;
            }
            return curResult;
        }
        return null;
    }

    private Result getResultWithThreshold(XUnitLog log, AbstractBuild<?, ?> build) {
        TestResultAction testResultAction = this.getTestResultAction(build);
        TestResultAction previousTestResultAction = this.getPreviousTestResultAction(build);
        if (testResultAction == null) {
            return Result.FAILURE;
        }
        return this.processResultThreshold(log, build, testResultAction, previousTestResultAction);
    }

    private Result processResultThreshold(XUnitLog log, AbstractBuild<?, ?> build, TestResultAction testResultAction, TestResultAction previousTestResultAction) {
        if (this.thresholds != null) {
            for (XUnitThreshold threshold : this.thresholds) {
                log.infoConsoleLogger(String.format("Check '%s' threshold.", threshold.getDescriptor().getDisplayName()));
                Result result = 2 == this.thresholdMode ? threshold.getResultThresholdPercent(log, build, testResultAction, previousTestResultAction) : threshold.getResultThresholdNumber(log, build, testResultAction, previousTestResultAction);
                if (!result.isWorseThan(Result.SUCCESS)) continue;
                return result;
            }
        }
        return Result.SUCCESS;
    }

    private void processDeletion(boolean dryRun, AbstractBuild<?, ?> build, XUnitLog xUnitLog) throws XUnitException {
        try {
            boolean keepJUnitDirectory = false;
            for (TestType tool : this.types) {
                InputMetric inputMetric = tool.getInputMetric();
                if (dryRun || tool.isDeleteOutputFiles()) {
                    this.getWorkspace(build).child("generatedJUnitFiles/" + inputMetric.getToolName()).deleteRecursive();
                    continue;
                }
                keepJUnitDirectory = true;
            }
            if (!keepJUnitDirectory) {
                this.getWorkspace(build).child(GENERATED_JUNIT_DIR).deleteRecursive();
            }
        }
        catch (IOException ioe) {
            throw new XUnitException("Problem on deletion", ioe);
        }
        catch (InterruptedException ie) {
            throw new XUnitException("Problem on deletion", ie);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class XUnitDescriptorPublisher
    extends BuildStepDescriptor<Publisher> {
        public XUnitDescriptorPublisher() {
            super(XUnitPublisher.class);
            this.load();
        }

        public String getDisplayName() {
            return Messages.xUnit_PublisherName();
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public String getHelpFile() {
            return "/plugin/xunit/help.html";
        }

        public DescriptorExtensionList<TestType, TestTypeDescriptor<?>> getListXUnitTypeDescriptors() {
            return TestTypeDescriptor.all();
        }

        public DescriptorExtensionList<XUnitThreshold, XUnitThresholdDescriptor<?>> getListXUnitThresholdDescriptors() {
            return XUnitThresholdDescriptor.all();
        }

        public XUnitThreshold[] getListXUnitThresholdInstance() {
            return new XUnitThreshold[]{new FailedThreshold(), new SkippedThreshold()};
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            List types = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"tools", this.getListXUnitTypeDescriptors());
            List thresholds = Descriptor.newInstancesFromHeteroList((StaplerRequest)req, (JSONObject)formData, (String)"thresholds", this.getListXUnitThresholdDescriptors());
            int thresholdMode = 0;
            try {
                thresholdMode = formData.getInt("thresholdMode");
            }
            catch (JSONException e) {
                // empty catch block
            }
            return new XUnitPublisher(types.toArray(new TestType[types.size()]), thresholds.toArray(new XUnitThreshold[thresholds.size()]), thresholdMode);
        }
    }

    private class StopTestProcessingException
    extends Exception {
        private StopTestProcessingException() {
        }
    }
}

