/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.xunit.service;

import com.google.inject.Inject;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitConversionService;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitLog;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitReportProcessingService;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitService;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitToolInfo;
import com.thalesgroup.hudson.plugins.xunit.service.XUnitValidationService;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import hudson.util.IOException2;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XUnitTransformer
extends XUnitService
implements FilePath.FileCallable<Boolean>,
Serializable {
    private XUnitReportProcessingService xUnitReportProcessingService;
    private XUnitConversionService xUnitConversionService;
    private XUnitValidationService xUnitValidationService;
    private XUnitToolInfo xUnitToolInfo;
    private XUnitLog xUnitLog;

    @Inject
    void load(XUnitReportProcessingService xUnitReportProcessingService, XUnitConversionService xUnitConversionService, XUnitValidationService xUnitValidationService, XUnitToolInfo xUnitToolInfo, XUnitLog xUnitLog) {
        this.xUnitReportProcessingService = xUnitReportProcessingService;
        this.xUnitValidationService = xUnitValidationService;
        this.xUnitConversionService = xUnitConversionService;
        this.xUnitToolInfo = xUnitToolInfo;
        this.xUnitLog = xUnitLog;
    }

    public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
        try {
            File junitOuputDir = new File(ws, "generatedJUnitFiles");
            if (!junitOuputDir.mkdirs()) {
                String msg = "Can't create the path " + junitOuputDir + ". Maybe the directory already exists.";
                this.xUnitLog.warningConsoleLogger(msg);
                this.warningSystemLogger(msg);
            }
            String metricName = this.xUnitToolInfo.getInputMetric().getToolName();
            List<String> resultFiles = this.xUnitReportProcessingService.findReports(this.xUnitToolInfo, ws, this.xUnitToolInfo.getExpandedPattern());
            if (resultFiles.size() == 0) {
                String msg = "No test reports found for the metric '" + metricName + "' with the resolved pattern '" + this.xUnitToolInfo.getExpandedPattern() + "'. Configuration error?.";
                this.xUnitLog.errorConsoleLogger(msg);
                this.errorSystemLogger(msg);
                return false;
            }
            if (!this.xUnitReportProcessingService.checkIfFindsFilesNewFiles(this.xUnitToolInfo, resultFiles, ws)) {
                return false;
            }
            boolean atLeastOneWarningOrError = false;
            for (String curFileName : resultFiles) {
                String msg;
                File curFile = this.xUnitReportProcessingService.getCurrentReport(ws, curFileName);
                boolean isStopProcessingIfError = this.xUnitReportProcessingService.isStopProcessingIfError(this.xUnitToolInfo);
                if (!this.xUnitValidationService.checkFileIsNotEmpty(curFile)) {
                    msg = "The result file '" + curFile.getPath() + "' for the metric '" + metricName + "' is empty. The result file has been skipped.";
                    if (isStopProcessingIfError) {
                        this.xUnitLog.errorConsoleLogger(msg);
                        this.errorSystemLogger(msg);
                        return false;
                    }
                    atLeastOneWarningOrError = true;
                    this.errorSystemLogger(msg);
                    continue;
                }
                if (!this.xUnitValidationService.validateInputFile(this.xUnitToolInfo, curFile)) {
                    msg = "The result file '" + curFile + "' for the metric '" + metricName + "' is not valid. The result file has been skipped.";
                    if (isStopProcessingIfError) {
                        this.xUnitLog.errorConsoleLogger(msg);
                        this.errorSystemLogger(msg);
                        return false;
                    }
                    atLeastOneWarningOrError = true;
                    this.errorSystemLogger(msg);
                    continue;
                }
                File junitTargetFile = this.xUnitConversionService.convert(this.xUnitToolInfo, curFile, ws, junitOuputDir);
                if (this.xUnitValidationService.validateOutputFile(this.xUnitToolInfo, curFile, junitTargetFile)) continue;
                String msg2 = "The converted file for the result file '" + curFile + "' (during conversion process for the metric '" + metricName + "') is not valid. The report file has been skipped.";
                if (isStopProcessingIfError) {
                    this.xUnitLog.errorConsoleLogger(msg2);
                    this.errorSystemLogger(msg2);
                    return false;
                }
                atLeastOneWarningOrError = true;
                this.errorSystemLogger(msg2);
            }
            if (atLeastOneWarningOrError) {
                String msg = "There is at least one problem. Check the Jenkins system log for more information. (if you don't have configured yet the system log before, you have to rebuild).";
                this.xUnitLog.errorConsoleLogger(msg);
                return false;
            }
        }
        catch (Exception xe) {
            String msg = xe.getMessage();
            if (msg != null) {
                this.xUnitLog.errorConsoleLogger(msg);
            }
            xe.printStackTrace();
            throw new IOException2("There are some problems during the conversion into JUnit reports: ", (Throwable)xe);
        }
        return true;
    }
}

