/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.xunit.threshold;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.TestResultAction;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.xunit.service.XUnitLog;
import org.jenkinsci.plugins.xunit.threshold.XUnitThresholdDescriptor;

public abstract class XUnitThreshold
implements ExtensionPoint,
Serializable,
Describable<XUnitThreshold> {
    private String unstableThreshold;
    private String unstableNewThreshold;
    private String failureThreshold;
    private String failureNewThreshold;

    protected XUnitThreshold() {
    }

    public XUnitThreshold(String unstableThreshold, String unstableNewThreshold, String failureThreshold, String failureNewThreshold) {
        this.unstableThreshold = unstableThreshold;
        this.unstableNewThreshold = unstableNewThreshold;
        this.failureThreshold = failureThreshold;
        this.failureNewThreshold = failureNewThreshold;
    }

    public Descriptor<XUnitThreshold> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<XUnitThreshold, XUnitThresholdDescriptor<?>> all() {
        return Jenkins.getActiveInstance().getDescriptorList(XUnitThreshold.class);
    }

    public String getUnstableThreshold() {
        return this.unstableThreshold;
    }

    public String getUnstableNewThreshold() {
        return this.unstableNewThreshold;
    }

    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    public String getFailureNewThreshold() {
        return this.failureNewThreshold;
    }

    public abstract Result getResultThresholdNumber(XUnitLog var1, Run<?, ?> var2, TestResultAction var3, TestResultAction var4);

    public abstract Result getResultThresholdPercent(XUnitLog var1, Run<?, ?> var2, TestResultAction var3, TestResultAction var4);

    public Result getResultThresholdNumber(XUnitLog log, int testCount, int newTestCount) {
        String thresholdErrorMessage = "The %s number of tests for this category exceeds the specified '%s' threshold value.";
        if (this.isValid(this.getFailureThreshold()) && this.convertToInteger(this.getFailureThreshold()) < testCount) {
            log.infoConsoleLogger(String.format(thresholdErrorMessage, "total", "failure"));
            return Result.FAILURE;
        }
        if (this.isValid(this.getFailureNewThreshold()) && this.convertToInteger(this.getFailureNewThreshold()) < newTestCount) {
            log.infoConsoleLogger(String.format(thresholdErrorMessage, "new", "new failure"));
            return Result.FAILURE;
        }
        if (this.isValid(this.getUnstableThreshold()) && this.convertToInteger(this.getUnstableThreshold()) < testCount) {
            log.infoConsoleLogger(String.format(thresholdErrorMessage, "total", "unstable"));
            return Result.UNSTABLE;
        }
        if (this.isValid(this.getUnstableNewThreshold()) && this.convertToInteger(this.getUnstableNewThreshold()) < newTestCount) {
            log.infoConsoleLogger(String.format(thresholdErrorMessage, "new", "new unstable"));
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    public Result getResultThresholdPercent(XUnitLog log, double testPercent, double newTestPercent) {
        String thresholdErrorMessage = "The percent %s tests for this category exceeds the specified '%s' threshold percent value.";
        if (this.isValid(this.getFailureThreshold()) && (double)this.convertToIntegerPercent(this.getFailureThreshold()) < testPercent) {
            log.infoConsoleLogger(String.format(thresholdErrorMessage, "of the total number of", "failure"));
            return Result.FAILURE;
        }
        if (this.isValid(this.getFailureNewThreshold()) && (double)this.convertToIntegerPercent(this.getFailureNewThreshold()) < newTestPercent) {
            log.infoConsoleLogger(String.format(thresholdErrorMessage, "of the new number of", "new failure"));
            return Result.FAILURE;
        }
        if (this.isValid(this.getUnstableThreshold()) && (double)this.convertToIntegerPercent(this.getUnstableThreshold()) < testPercent) {
            log.infoConsoleLogger(String.format(thresholdErrorMessage, "of", "unstable"));
            return Result.UNSTABLE;
        }
        if (this.isValid(this.getUnstableNewThreshold()) && (double)this.convertToIntegerPercent(this.getUnstableNewThreshold()) < newTestPercent) {
            log.infoConsoleLogger(String.format(thresholdErrorMessage, "of the new number of", "new unstable"));
            return Result.UNSTABLE;
        }
        return Result.SUCCESS;
    }

    private int convertToInteger(String threshold) {
        return Integer.parseInt(threshold);
    }

    private int convertToIntegerPercent(String threshold) {
        String thresholdRemoved = threshold.replace("%", "");
        return Integer.parseInt(thresholdRemoved);
    }

    private boolean isValid(String threshold) {
        if (threshold == null) {
            return false;
        }
        if (threshold.trim().length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(threshold);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

