/*
 * Decompiled with CFR 0.152.
 */
package maps.hudson.plugin.xfpanel;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.TopLevelItem;
import hudson.model.ViewDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import maps.hudson.plugin.xfpanel.XFPanelEntry;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFPanelView
extends ListView {
    private Integer numColumns = 2;
    private Integer refresh = 3;
    private Boolean fullHD = false;
    private Integer guiHeight = 205;
    private Integer guiJobFont = 80;
    private Integer guiFailFont = 150;
    private Integer guiInfoFont = 30;
    private Integer guiBuildFont = 30;
    private Integer guiClaimFont = 20;
    private Boolean showDescription = false;
    private Boolean showBrokenBuildCount = false;
    private Boolean showZeroTestCounts = true;
    private Boolean sortDescending = false;
    private Boolean showTimeStamp = true;
    private Boolean enableAutomaticSort = true;
    private Boolean manualSort = false;
    private Boolean showClaimInfo = true;
    private Boolean showWarningIcon = false;
    private Boolean replaceResponsibles = true;
    private Boolean autoResizeEntryHeight = true;
    private Boolean hideSuccessfulBuilds = false;
    private Boolean replaceNumberOfTestCases = true;
    private Boolean showClaimInfoInUnstable = true;
    private transient List<XFPanelEntry> entries;
    protected XFPanelColors colors;
    protected transient Map<Queue.Item, Integer> placeInQueue = new HashMap<Queue.Item, Integer>();
    protected Map<String, Integer> priorityPerJob = new HashMap<String, Integer>();
    protected Blame BlameState = Blame.EVERYINVOLVED;
    private Integer maxAmmountOfResponsibles = 1;
    private String responsiblesTopic = "Responsible(s): ";
    private String lastBuildTimePreFix = "last successful: ";
    private String successfulBuildColor = "#7E7EFF";
    private String unstableBuildColor = "#FFC130";
    private String brokenBuildColor = "#FF0000";
    private String otherBuildColor = "#CCCCCC";
    private String buildFontColor = "#FFFFFF";

    @DataBoundConstructor
    public XFPanelView(String name, Integer numColumns) {
        super(name);
        this.numColumns = numColumns != null ? numColumns : 2;
    }

    public XFPanelColors getColors() {
        XFPanelColors obj = new XFPanelColors(this.successfulBuildColor, this.buildFontColor, this.unstableBuildColor, this.buildFontColor, this.brokenBuildColor, this.buildFontColor, this.otherBuildColor, this.buildFontColor);
        if (this.colors == null || !this.colors.equals(obj)) {
            this.colors = obj;
        }
        return this.colors;
    }

    public Integer getGuiHeight() {
        if (this.autoResizeEntryHeight.booleanValue()) {
            Integer entryHeight = this.guiJobFont + this.guiInfoFont;
            if (this.showClaimInfo.booleanValue()) {
                entryHeight = this.BlameState != Blame.NOTATALL ? (this.replaceResponsibles.booleanValue() ? Integer.valueOf(entryHeight + this.guiClaimFont) : Integer.valueOf(entryHeight + (this.guiClaimFont + this.guiInfoFont + this.guiInfoFont / 2))) : Integer.valueOf(entryHeight + this.guiClaimFont);
                if (this.showClaimInfoInUnstable.booleanValue()) {
                    entryHeight = entryHeight + this.guiClaimFont;
                }
            } else if (this.BlameState != Blame.NOTATALL) {
                entryHeight = entryHeight + this.guiInfoFont;
            }
            if (this.showTimeStamp.booleanValue()) {
                entryHeight = entryHeight + (this.guiInfoFont + this.guiInfoFont / 2);
            }
            entryHeight = Math.max(entryHeight, this.guiFailFont);
            entryHeight = Math.max(entryHeight, this.guiJobFont);
            if (this.showZeroTestCounts.booleanValue() && this.showTimeStamp.booleanValue()) {
                entryHeight = Math.max(entryHeight, this.guiJobFont + this.guiInfoFont * 3);
            }
            Integer padding = 15;
            return entryHeight + padding;
        }
        return this.guiHeight;
    }

    public Integer getGuiJobFont() {
        return this.guiJobFont;
    }

    public Integer getGuiFailFont() {
        return this.guiFailFont;
    }

    public Integer getGuiInfoFont() {
        return this.guiInfoFont;
    }

    public Integer getGuiBuildFont() {
        return this.guiBuildFont;
    }

    public Integer getGuiClaimFont() {
        return this.guiClaimFont;
    }

    public Integer getMaxAmmountOfResponsibles() {
        return this.maxAmmountOfResponsibles;
    }

    public Boolean getFullHD() {
        return this.fullHD;
    }

    public Boolean getShowDescription() {
        if (this.showDescription == null) {
            this.showDescription = false;
        }
        return this.showDescription;
    }

    public Boolean getShowBrokenBuildCount() {
        if (this.showBrokenBuildCount == null) {
            this.showBrokenBuildCount = Boolean.FALSE;
        }
        return this.showBrokenBuildCount;
    }

    public Boolean getSortDescending() {
        if (this.sortDescending == null) {
            this.sortDescending = Boolean.FALSE;
        }
        return this.sortDescending;
    }

    public Boolean getShowZeroTestCounts() {
        if (this.showZeroTestCounts == null) {
            this.showZeroTestCounts = Boolean.TRUE;
        }
        return this.showZeroTestCounts;
    }

    public Boolean getShowTimeStamp() {
        return this.showTimeStamp;
    }

    public Boolean getShowClaimInfo() {
        return this.showClaimInfo;
    }

    public Boolean getShowClaimInfoInUnstable() {
        return this.showClaimInfoInUnstable;
    }

    public Boolean getShowWarningIcon() {
        return this.showWarningIcon;
    }

    public Boolean getReplaceResponsibles() {
        return this.replaceResponsibles;
    }

    public Integer getBlameState() {
        return this.BlameState.ordinal();
    }

    public Boolean getAutomaticSortState() {
        return this.enableAutomaticSort;
    }

    public Boolean getManualSortState() {
        return this.manualSort;
    }

    public String getResponsiblesTopic() {
        if (this.responsiblesTopic == null) {
            return "";
        }
        return this.responsiblesTopic;
    }

    public Boolean getHideSuccessfulBuilds() {
        return this.hideSuccessfulBuilds;
    }

    private String validateColor(String current, String defaultColor) {
        if (current != null && current.length() == 7 && current.startsWith("#")) {
            return current.substring(1);
        }
        return defaultColor;
    }

    public String getSuccessfulBuildColor() {
        return this.validateColor(this.successfulBuildColor, "7E7EFF");
    }

    public String getUnstableBuildColor() {
        return this.validateColor(this.unstableBuildColor, "FFC130");
    }

    public String getBrokenBuildColor() {
        return this.validateColor(this.brokenBuildColor, "FF0000");
    }

    public String getOtherBuildColor() {
        return this.validateColor(this.otherBuildColor, "CCCCCC");
    }

    public String getBuildFontColor() {
        return this.validateColor(this.buildFontColor, "FFFFFF");
    }

    public Boolean getPriorityPerJob() {
        return this.priorityPerJob != null;
    }

    public Boolean getIsClaimPluginInstalled() {
        return Hudson.getInstance().getPlugin("claim") != null;
    }

    public Boolean getReplaceNumberOfTestCases() {
        if (this.getIsClaimPluginInstalled().booleanValue()) {
            return this.replaceNumberOfTestCases;
        }
        return false;
    }

    public Boolean getAutoResizeEntryHeight() {
        return this.autoResizeEntryHeight;
    }

    public Collection<XFPanelEntry> sort(Collection<Job<?, ?>> jobs) {
        this.placeInQueue = new HashMap<Queue.Item, Integer>();
        int j = 1;
        for (Queue.Item i : Hudson.getInstance().getQueue().getItems()) {
            this.placeInQueue.put(i, j++);
        }
        if (jobs != null) {
            ArrayList<XFPanelEntry> ents = new ArrayList<XFPanelEntry>();
            Collection<Job<?, ?>> sortedJobs = this.getPrioritySortedJobs(jobs, false);
            for (Job<?, ?> job : sortedJobs) {
                ents.add(new XFPanelEntry(this, job));
            }
            if (this.enableAutomaticSort.booleanValue()) {
                Collections.sort(ents, new selectComparator());
            }
            if (this.getSortDescending().booleanValue()) {
                Collections.reverse(ents);
            }
            this.entries = ents;
            return this.entries;
        }
        return Collections.emptyList();
    }

    public Collection<Job<?, ?>> getPrioritySortedJobs(Collection<Job<?, ?>> jobs) {
        return this.getPrioritySortedJobs(jobs, true);
    }

    public Collection<Job<?, ?>> getPrioritySortedJobs(Collection<Job<?, ?>> jobs, final boolean isConfiguration) {
        if (jobs != null) {
            ArrayList sortedJobs = new ArrayList(jobs);
            final List allItems = this.getItems();
            final Integer lastPriority = Integer.MAX_VALUE;
            if (this.manualSort.booleanValue() || !this.enableAutomaticSort.booleanValue()) {
                Collections.sort(sortedJobs, new Comparator<Job<?, ?>>(){

                    @Override
                    public int compare(Job<?, ?> o1, Job<?, ?> o2) {
                        String n1 = o1.getName();
                        String n2 = o2.getName();
                        if (XFPanelView.this.manualSort.booleanValue() && XFPanelView.this.priorityPerJob != null) {
                            int c;
                            Integer p2;
                            Integer p1 = isConfiguration && !this.containsJob(o1) ? lastPriority : XFPanelView.this.priorityPerJob.get(n1);
                            Integer n = p2 = isConfiguration && !this.containsJob(o2) ? lastPriority : XFPanelView.this.priorityPerJob.get(n2);
                            if (p1 == null) {
                                p1 = lastPriority;
                            }
                            if (p2 == null) {
                                p2 = lastPriority;
                            }
                            if ((c = p1.compareTo(p2)) == 0) {
                                return this.compareNames(o1, o2);
                            }
                            return c;
                        }
                        return this.compareNames(o1, o2);
                    }

                    private int compareNames(Job<?, ?> o1, Job<?, ?> o2) {
                        if (isConfiguration) {
                            Boolean cont1 = this.containsJob(o1);
                            Boolean cont2 = this.containsJob(o2);
                            int c = cont2.compareTo(cont1);
                            if (c != 0) {
                                return c;
                            }
                        }
                        return o1.getName().compareToIgnoreCase(o2.getName());
                    }

                    private boolean containsJob(Job<?, ?> j) {
                        if (j instanceof TopLevelItem) {
                            return allItems.contains((TopLevelItem)j);
                        }
                        return false;
                    }
                });
            }
            return sortedJobs;
        }
        return Collections.emptyList();
    }

    public Integer getRefresh() {
        return this.refresh;
    }

    public Integer getNumColumns() {
        return this.numColumns;
    }

    public String getLastBuildTimePreFix() {
        return this.lastBuildTimePreFix != null ? this.lastBuildTimePreFix : "";
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException, IOException {
        super.submit(req);
        this.numColumns = this.asInteger(req, "numColumns");
        this.refresh = this.asInteger(req, "refresh");
        this.fullHD = Boolean.parseBoolean(req.getParameter("fullHD"));
        this.guiHeight = this.asInteger(req, "guiHeight");
        this.guiJobFont = this.asInteger(req, "guiJobFont");
        this.guiFailFont = this.asInteger(req, "guiFailFont");
        this.guiInfoFont = this.asInteger(req, "guiInfoFont");
        this.guiBuildFont = this.asInteger(req, "guiBuildFont");
        this.showDescription = Boolean.parseBoolean(req.getParameter("showDescription"));
        this.sortDescending = Boolean.parseBoolean(req.getParameter("sortDescending"));
        this.showTimeStamp = Boolean.parseBoolean(req.getParameter("showTimeStamp"));
        this.showZeroTestCounts = Boolean.parseBoolean(req.getParameter("showZeroTestCounts"));
        this.showWarningIcon = Boolean.parseBoolean(req.getParameter("showWarningIcon"));
        this.maxAmmountOfResponsibles = this.asInteger(req, "maxAmmountOfResponsibles");
        this.autoResizeEntryHeight = Boolean.parseBoolean(req.getParameter("autoResizeEntryHeight"));
        this.hideSuccessfulBuilds = Boolean.parseBoolean(req.getParameter("hideSuccessfulBuilds"));
        this.showBrokenBuildCount = Boolean.parseBoolean(req.getParameter("showBrokenBuildCount"));
        if (this.getIsClaimPluginInstalled().booleanValue()) {
            this.guiClaimFont = this.asInteger(req, "guiClaimFont");
            this.showClaimInfo = Boolean.parseBoolean(req.getParameter("showClaimInfo"));
            this.showClaimInfoInUnstable = Boolean.parseBoolean(req.getParameter("showClaimInfoInUnstable"));
            this.replaceResponsibles = Boolean.parseBoolean(req.getParameter("replaceResponsibles"));
            this.replaceNumberOfTestCases = Boolean.parseBoolean(req.getParameter("replaceNumberOfTestCases"));
        }
        this.successfulBuildColor = "#" + req.getParameter("successfulBuildColor");
        this.unstableBuildColor = "#" + req.getParameter("unstableBuildColor");
        this.brokenBuildColor = "#" + req.getParameter("brokenBuildColor");
        this.otherBuildColor = "#" + req.getParameter("otherBuildColor");
        this.buildFontColor = "#" + req.getParameter("buildFontColor");
        if (this.priorityPerJob == null) {
            this.priorityPerJob = new HashMap<String, Integer>();
        }
        int priority = 0;
        this.priorityPerJob.clear();
        for (TopLevelItem i : Hudson.getInstance().getItems()) {
            String itemName = i.getName();
            if (itemName != null) {
                String paramName = itemName + "_priority";
                try {
                    String priorityStr = req.getParameter(paramName);
                    priority = priorityStr != null ? Integer.parseInt(priorityStr) : 0;
                }
                catch (NumberFormatException e) {
                    ++priority;
                }
                catch (Exception e) {
                    ++priority;
                }
                this.priorityPerJob.put(itemName, priority);
                continue;
            }
            throw new Descriptor.FormException("Couldn't read jobs from the config file. Generate a new config-file: jenkins_job_url/configure", "");
        }
        String SortType = req.getParameter("sort");
        if (SortType != null) {
            this.enableAutomaticSort = false;
            this.manualSort = false;
            if (SortType.equals("sort.automatic")) {
                this.enableAutomaticSort = true;
            } else if (SortType.equals("sort.manual")) {
                this.manualSort = true;
            }
        }
        this.lastBuildTimePreFix = req.getParameter("lastBuildTimePreFix");
        this.responsiblesTopic = req.getParameter("responsiblesTopic");
        String blameType = req.getParameter("responsibles");
        if (blameType == null) {
            System.out.println("WARNING: Show responsibles == null --> Show responsibles disabled");
            this.BlameState = Blame.NOTATALL;
        } else if (blameType.equals("blame.notAtAll")) {
            this.BlameState = Blame.NOTATALL;
        } else if (blameType.equals("blame.onlyFirstFailedBuild")) {
            this.BlameState = Blame.ONLYFIRSTFAILEDBUILD;
        } else if (blameType.equals("blame.onlyLastFailedBuild")) {
            this.BlameState = Blame.ONLYLASTFAILEDBUILD;
        } else if (blameType.equals("blame.everyInvolved")) {
            this.BlameState = Blame.EVERYINVOLVED;
        }
    }

    private Integer asInteger(StaplerRequest request, String parameterName) throws Descriptor.FormException {
        try {
            return Integer.parseInt(request.getParameter(parameterName));
        }
        catch (NumberFormatException e) {
            throw new Descriptor.FormException(parameterName + " must be a positive integer", parameterName);
        }
    }

    public static final class XFPanelColors {
        private String okBG;
        private String okFG;
        private String failedBG;
        private String failedFG;
        private String brokenBG;
        private String brokenFG;
        private String otherBG;
        private String otherFG;
        public static final XFPanelColors DEFAULT = new XFPanelColors("#7E7EFF", "#FFFFFF", "#FFC130", "#FFFFFF", "#FF0000", "#FFFFFF", "#CCCCCC", "#FFFFFF");

        public XFPanelColors(String okBG, String okFG, String failedBG, String failedFG, String brokenBG, String brokenFG, String otherBG, String otherFG) {
            this.okBG = okBG;
            this.okFG = okFG;
            this.failedBG = failedBG;
            this.failedFG = failedFG;
            this.brokenBG = brokenBG;
            this.brokenFG = brokenFG;
            this.otherBG = otherBG;
            this.otherFG = otherFG;
        }

        public String getOkBG() {
            return this.okBG;
        }

        public String getOkFG() {
            return this.okFG;
        }

        public String getFailedBG() {
            return this.failedBG;
        }

        public String getFailedFG() {
            return this.failedFG;
        }

        public String getBrokenBG() {
            return this.brokenBG;
        }

        public String getBrokenFG() {
            return this.brokenFG;
        }

        public String getOtherBG() {
            return this.otherBG;
        }

        public String getOtherFG() {
            return this.otherFG;
        }
    }

    @Extension
    public static final class XFPanelViewDescriptor
    extends ViewDescriptor {
        public static final String REFRESH_MSG = "Refresh time must be a positive integer.";
        public static final String MSG = "Number of columns currently supported is 1 or 2.";

        public String getDisplayName() {
            return "eXtreme Feedback Panel";
        }

        public FormValidation doCheckNumColumns(@QueryParameter String value) {
            try {
                int i = Integer.parseInt(value);
                if (i < 1 || i > 6) {
                    return FormValidation.error((String)MSG);
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)MSG);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRefresh(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiHeight(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiJobFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiFailFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiInfoFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiBuildFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        private FormValidation isPositiveInteger(String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class selectComparator
    implements Comparator<XFPanelEntry> {
        selectComparator() {
        }

        private int getPriority(AbstractBuild<?, ?> build) {
            if (build == null) {
                return 1;
            }
            if (build.isBuilding()) {
                build = (AbstractBuild)build.getPreviousBuild();
                return this.getPriority(build);
            }
            Result result = build.getResult();
            if (result != null) {
                Result[] allResults = new Result[]{Result.SUCCESS, Result.ABORTED, Result.NOT_BUILT, Result.UNSTABLE, Result.FAILURE};
                int[] resultValues = new int[]{0, 1, 1, 2, 3};
                for (int i = 0; i < allResults.length; ++i) {
                    if (result != allResults[i]) continue;
                    return resultValues[i];
                }
            }
            return 1;
        }

        @Override
        public int compare(XFPanelEntry a, XFPanelEntry b) {
            AbstractBuild<?, ?> buildA = a.getLastBuild();
            AbstractBuild<?, ?> buildB = b.getLastBuild();
            int result = this.getPriority(buildB) - this.getPriority(buildA);
            if (result == 0) {
                if (buildA == null || buildB == null) {
                    return buildA == null ? 1 : 0;
                }
                if (buildA.isBuilding() || buildB.isBuilding()) {
                    return buildA.isBuilding() ? 0 : 1;
                }
                return b.getCompletionTimestamp().compareTo(a.getCompletionTimestamp());
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Blame {
        NOTATALL,
        ONLYLASTFAILEDBUILD,
        ONLYFIRSTFAILEDBUILD,
        EVERYINVOLVED;

    }
}

