/*
 * Decompiled with CFR 0.152.
 */
package maps.hudson.plugin.xfpanel;

import hudson.Extension;
import hudson.Functions;
import hudson.model.AbstractBuild;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.ListView;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.ViewDescriptor;
import hudson.plugins.claim.ClaimBuildAction;
import hudson.plugins.claim.ClaimTestAction;
import hudson.scm.ChangeLogSet;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.util.FormValidation;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XFPanelView
extends ListView {
    private XFColors colors;
    private Integer numColumns = 2;
    private Integer refresh = 3;
    private Boolean fullHD = false;
    private Integer guiHeight = 205;
    private Integer guiImgHeight = 180;
    private Integer guiJobFont = 80;
    private Integer guiFailFont = 150;
    private Integer guiInfoFont = 30;
    private Integer guiBuildFont = 30;
    private Integer guiClaimFont = 30;
    private Boolean showDescription = false;
    private Boolean showZeroTestCounts = true;
    private Boolean sortDescending = false;
    private Boolean showTimeStamp = true;
    private Boolean enableAutomaticSort = true;
    private Boolean showClaimInfo = true;
    private Boolean showWarningIcon = false;
    private Boolean replaceResponsibles = true;
    private Boolean autoResizeEntryHeight = true;
    private Boolean hideSuccessfulBuilds = false;
    private Boolean replaceNumberOfTestCases = true;
    private transient List<XFPanelEntry> entries;
    private transient Map<Queue.Item, Integer> placeInQueue = new HashMap<Queue.Item, Integer>();
    protected Blame BlameState = Blame.EVERYINVOLVED;
    private Integer maxAmmountOfResponsibles = 1;
    private String responsiblesTopic = "Responsible(s): ";

    @DataBoundConstructor
    public XFPanelView(String name, Integer numColumns) {
        super(name);
        this.numColumns = numColumns != null ? numColumns : 2;
    }

    public XFColors getColors() {
        if (this.colors == null) {
            this.colors = XFColors.DEFAULT;
        }
        return this.colors;
    }

    public Integer getGuiHeight() {
        if (this.autoResizeEntryHeight.booleanValue()) {
            Integer entryHeight = this.guiJobFont + this.guiInfoFont;
            if (this.showClaimInfo.booleanValue()) {
                entryHeight = this.BlameState != Blame.NOTATALL ? (this.replaceResponsibles.booleanValue() ? Integer.valueOf(entryHeight + this.guiClaimFont) : Integer.valueOf(entryHeight + (this.guiClaimFont + this.guiInfoFont + this.guiInfoFont / 2))) : Integer.valueOf(entryHeight + this.guiClaimFont);
            } else if (this.BlameState != Blame.NOTATALL) {
                entryHeight = entryHeight + this.guiInfoFont;
            }
            if (this.showTimeStamp.booleanValue()) {
                entryHeight = entryHeight + (this.guiInfoFont + this.guiInfoFont / 2);
            }
            entryHeight = Math.max(entryHeight, this.guiFailFont);
            entryHeight = Math.max(entryHeight, this.guiJobFont);
            if (this.showWarningIcon.booleanValue() || this.showClaimInfo.booleanValue()) {
                entryHeight = Math.max(entryHeight, this.guiImgHeight);
            }
            if (this.showZeroTestCounts.booleanValue() && this.showTimeStamp.booleanValue()) {
                entryHeight = Math.max(entryHeight, this.guiJobFont + this.guiInfoFont * 3);
            }
            Integer padding = 15;
            return entryHeight + padding;
        }
        return this.guiHeight;
    }

    public Integer getGuiImgHeight() {
        return this.guiImgHeight;
    }

    public Integer getGuiJobFont() {
        return this.guiJobFont;
    }

    public Integer getGuiFailFont() {
        return this.guiFailFont;
    }

    public Integer getGuiInfoFont() {
        return this.guiInfoFont;
    }

    public Integer getGuiBuildFont() {
        return this.guiBuildFont;
    }

    public Integer getGuiClaimFont() {
        return this.guiClaimFont;
    }

    public Integer getMaxAmmountOfResponsibles() {
        return this.maxAmmountOfResponsibles;
    }

    public Boolean getFullHD() {
        return this.fullHD;
    }

    public Boolean getShowDescription() {
        if (this.showDescription == null) {
            this.showDescription = false;
        }
        return this.showDescription;
    }

    public Boolean getSortDescending() {
        if (this.sortDescending == null) {
            this.sortDescending = Boolean.FALSE;
        }
        return this.sortDescending;
    }

    public Boolean getShowZeroTestCounts() {
        if (this.showZeroTestCounts == null) {
            this.showZeroTestCounts = Boolean.TRUE;
        }
        return this.showZeroTestCounts;
    }

    public Boolean getShowTimeStamp() {
        return this.showTimeStamp;
    }

    public Boolean getShowClaimInfo() {
        return this.showClaimInfo;
    }

    public Boolean getShowWarningIcon() {
        return this.showWarningIcon;
    }

    public Boolean getReplaceResponsibles() {
        return this.replaceResponsibles;
    }

    public String getResponsiblesTopic() {
        if (this.responsiblesTopic == null) {
            return "";
        }
        return this.responsiblesTopic;
    }

    public Boolean getHideSuccessfulBuilds() {
        return this.hideSuccessfulBuilds;
    }

    public Boolean getIsClaimPluginInstalled() {
        return Hudson.getInstance().getPlugin("claim") != null;
    }

    public Boolean getReplaceNumberOfTestCases() {
        if (this.getIsClaimPluginInstalled().booleanValue()) {
            return this.replaceNumberOfTestCases;
        }
        return false;
    }

    public Collection<XFPanelEntry> sort(Collection<Job<?, ?>> jobs) {
        this.placeInQueue = new HashMap<Queue.Item, Integer>();
        int j = 1;
        for (Queue.Item i : Hudson.getInstance().getQueue().getItems()) {
            this.placeInQueue.put(i, j++);
        }
        if (jobs != null) {
            ArrayList<XFPanelEntry> ents = new ArrayList<XFPanelEntry>();
            for (Job<?, ?> job : jobs) {
                ents.add(new XFPanelEntry(job));
            }
            if (this.enableAutomaticSort.booleanValue()) {
                Collections.sort(ents, new selectComparator());
            }
            if (this.getSortDescending().booleanValue()) {
                Collections.reverse(ents);
            }
            this.entries = ents;
            return this.entries;
        }
        return Collections.emptyList();
    }

    public Integer getRefresh() {
        return this.refresh;
    }

    public Integer getNumColumns() {
        return this.numColumns;
    }

    protected void submit(StaplerRequest req) throws ServletException, Descriptor.FormException, IOException {
        String SortType;
        super.submit(req);
        this.numColumns = this.asInteger(req, "numColumns");
        this.refresh = this.asInteger(req, "refresh");
        this.fullHD = Boolean.parseBoolean(req.getParameter("fullHD"));
        this.guiHeight = this.asInteger(req, "guiHeight");
        this.guiImgHeight = this.asInteger(req, "guiImgHeight");
        this.guiJobFont = this.asInteger(req, "guiJobFont");
        this.guiFailFont = this.asInteger(req, "guiFailFont");
        this.guiInfoFont = this.asInteger(req, "guiInfoFont");
        this.guiBuildFont = this.asInteger(req, "guiBuildFont");
        this.showDescription = Boolean.parseBoolean(req.getParameter("showDescription"));
        this.sortDescending = Boolean.parseBoolean(req.getParameter("sortDescending"));
        this.showTimeStamp = Boolean.parseBoolean(req.getParameter("showTimeStamp"));
        this.showZeroTestCounts = Boolean.parseBoolean(req.getParameter("showZeroTestCounts"));
        this.showWarningIcon = Boolean.parseBoolean(req.getParameter("showWarningIcon"));
        this.maxAmmountOfResponsibles = this.asInteger(req, "maxAmmountOfResponsibles");
        this.autoResizeEntryHeight = Boolean.parseBoolean(req.getParameter("autoResizeEntryHeight"));
        this.hideSuccessfulBuilds = Boolean.parseBoolean(req.getParameter("hideSuccessfulBuilds"));
        if (this.getIsClaimPluginInstalled().booleanValue()) {
            this.guiClaimFont = this.asInteger(req, "guiClaimFont");
            this.showClaimInfo = Boolean.parseBoolean(req.getParameter("showClaimInfo"));
            this.replaceResponsibles = Boolean.parseBoolean(req.getParameter("replaceResponsibles"));
            this.replaceNumberOfTestCases = Boolean.parseBoolean(req.getParameter("replaceNumberOfTestCases"));
        }
        this.enableAutomaticSort = (SortType = req.getParameter("sort")) != null && SortType.equals("sort.automatic") ? Boolean.valueOf(true) : Boolean.valueOf(false);
        this.responsiblesTopic = req.getParameter("responsiblesTopic");
        String blameType = req.getParameter("responsibles");
        if (blameType == null) {
            System.out.println("WARNING: Show responsibles == null --> Show responsibles disabled");
            this.BlameState = Blame.NOTATALL;
        } else if (blameType.equals("blame.notAtAll")) {
            this.BlameState = Blame.NOTATALL;
        } else if (blameType.equals("blame.onlyFirstFailedBuild")) {
            this.BlameState = Blame.ONLYFIRSTFAILEDBUILD;
        } else if (blameType.equals("blame.onlyLastFailedBuild")) {
            this.BlameState = Blame.ONLYLASTFAILEDBUILD;
        } else if (blameType.equals("blame.everyInvolved")) {
            this.BlameState = Blame.EVERYINVOLVED;
        }
    }

    private Integer asInteger(StaplerRequest request, String parameterName) throws Descriptor.FormException {
        try {
            return Integer.parseInt(request.getParameter(parameterName));
        }
        catch (NumberFormatException e) {
            throw new Descriptor.FormException(parameterName + " must be a positive integer", parameterName);
        }
    }

    public static final class XFColors {
        private String okBG;
        private String okFG;
        private String failedBG;
        private String failedFG;
        private String brokenBG;
        private String brokenFG;
        private String otherBG;
        private String otherFG;
        public static final XFColors DEFAULT = new XFColors("#7E7EFF", "#FFFFFF", "#FFC130", "#FFFFFF", "#FF0000", "#FFFFFF", "#CCCCCC", "#FFFFFF");

        public XFColors(String okBG, String okFG, String failedBG, String failedFG, String brokenBG, String brokenFG, String otherBG, String otherFG) {
            this.okBG = okBG;
            this.okFG = okFG;
            this.failedBG = failedBG;
            this.failedFG = failedFG;
            this.brokenBG = brokenBG;
            this.brokenFG = brokenFG;
            this.otherBG = otherBG;
            this.otherFG = otherFG;
        }

        public String getOkBG() {
            return this.okBG;
        }

        public String getOkFG() {
            return this.okFG;
        }

        public String getFailedBG() {
            return this.failedBG;
        }

        public String getFailedFG() {
            return this.failedFG;
        }

        public String getBrokenBG() {
            return this.brokenBG;
        }

        public String getBrokenFG() {
            return this.brokenFG;
        }

        public String getOtherBG() {
            return this.otherBG;
        }

        public String getOtherFG() {
            return this.otherFG;
        }
    }

    @Extension
    public static final class XFPanelViewDescriptor
    extends ViewDescriptor {
        public static final String REFRESH_MSG = "Refresh time must be a positive integer.";
        public static final String MSG = "Number of columns currently supported is 1 or 2.";

        public String getDisplayName() {
            return "eXtreme Feedback Panel";
        }

        public FormValidation doCheckNumColumns(@QueryParameter String value) {
            try {
                int i = Integer.parseInt(value);
                if (i < 1 || i > 2) {
                    return FormValidation.error((String)MSG);
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)MSG);
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRefresh(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiHeight(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiImgHeight(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiJobFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiFailFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiInfoFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        public FormValidation doCheckGuiBuildFont(@QueryParameter String value) {
            return this.isPositiveInteger(value);
        }

        private FormValidation isPositiveInteger(String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class XFPanelEntry {
        private Job<?, ?> job;
        private String backgroundColor;
        private String color;
        private Boolean broken;
        private Boolean building = false;
        private Boolean queued = false;
        private Integer queueNumber;
        private String completionTimestampString = "";
        private Calendar completionTimestamp;

        public XFPanelEntry(Job<?, ?> job) {
            this.job = job;
            this.findStatus();
            this.setTimes();
        }

        public Job<?, ?> getJob() {
            return this.job;
        }

        public String getName() {
            String label = this.job.getName().toUpperCase();
            if (XFPanelView.this.getShowDescription().booleanValue() && !this.job.getDescription().isEmpty()) {
                label = label + ": " + this.job.getDescription();
            }
            return label;
        }

        public Boolean getQueued() {
            return this.job.isInQueue();
        }

        public Integer getQueueNumber() {
            return XFPanelView.this.placeInQueue == null ? null : (Integer)XFPanelView.this.placeInQueue.get(this.job.getQueueItem());
        }

        private void setTimes() {
            AbstractBuild lastBuild = (AbstractBuild)this.job.getLastCompletedBuild();
            if (lastBuild != null) {
                this.completionTimestamp = lastBuild.getTimestamp();
                this.completionTimestampString = lastBuild.getTimestampString();
            }
        }

        public void setCompletionTimestamp(Calendar completionTimestamp) {
            this.completionTimestamp = completionTimestamp;
        }

        public Calendar getCompletionTimestamp() {
            return this.completionTimestamp;
        }

        public void setCompletionTimestampString(String completionTimestampString) {
            this.completionTimestampString = completionTimestampString;
        }

        public String getCompletionTimestampString() {
            return this.completionTimestampString;
        }

        public String getBackgroundColor() {
            return this.backgroundColor;
        }

        public String getColor() {
            return this.color;
        }

        public Boolean getBroken() {
            return this.broken;
        }

        public Boolean getShowResponsibles() {
            if (XFPanelView.this.BlameState == Blame.NOTATALL) {
                return false;
            }
            return true;
        }

        public Boolean getBuilding() {
            return this.building;
        }

        public String getUrl() {
            return this.job.getUrl() + "lastBuild";
        }

        public List<Run<?, ?>> getBuildsInProgress() {
            ArrayList runs = new ArrayList();
            Run run = this.job.getLastBuild();
            if (run.isBuilding()) {
                runs.add(run);
            }
            for (Run prev = run.getPreviousBuildInProgress(); prev != null; prev = prev.getPreviousBuildInProgress()) {
                runs.add(prev);
            }
            return runs;
        }

        public int getTestCount() {
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                return tests != null ? tests.getTotalCount() : 0;
            }
            return 0;
        }

        public int getFailCount() {
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                return tests != null ? tests.getFailCount() : 0;
            }
            return 0;
        }

        public int getSuccessCount() {
            return this.getTestCount() - this.getFailCount();
        }

        public int getLastCompletedBuildNumber() {
            return this.job.getLastCompletedBuild().getNumber();
        }

        public String getLastCompletedBuildTimestampString() {
            return this.job.getLastCompletedBuild().getTimestampString();
        }

        public String getDiff() {
            Run<?, ?> previous;
            Run run = this.job.getLastSuccessfulBuild();
            if (run != null && (previous = this.getLastSuccessfulFrom(run)) != null) {
                AbstractTestResultAction tests = (AbstractTestResultAction)run.getAction(AbstractTestResultAction.class);
                AbstractTestResultAction prevTests = (AbstractTestResultAction)previous.getAction(AbstractTestResultAction.class);
                if (tests != null && prevTests != null) {
                    int currentSuccess = tests.getTotalCount() - tests.getFailCount();
                    int prevSuccess = prevTests.getTotalCount() - prevTests.getFailCount();
                    return Functions.getDiffString((int)(currentSuccess - prevSuccess));
                }
            }
            return "";
        }

        private Run<?, ?> getLastSuccessfulFrom(Run<?, ?> run) {
            Run r;
            for (r = run.getPreviousBuild(); r != null && (r.isBuilding() || r.getResult() == null || r.getResult().isWorseThan(Result.UNSTABLE)); r = r.getPreviousBuild()) {
            }
            return r;
        }

        public HashSet<User> getCulpritFromBuild(AbstractBuild<?, ?> build) {
            HashSet<User> r = new HashSet<User>();
            for (ChangeLogSet.Entry e : build.getChangeSet()) {
                r.add(e.getAuthor());
            }
            return r;
        }

        public String convertCulpritsToString(HashSet<User> input) {
            String output = "";
            Iterator<User> it = input.iterator();
            int i = 0;
            while (it.hasNext()) {
                if (i < XFPanelView.this.getMaxAmmountOfResponsibles()) {
                    output = output + it.next().getFullName() + (it.hasNext() ? ", " : "");
                } else {
                    it.next();
                }
                ++i;
            }
            if (i > XFPanelView.this.getMaxAmmountOfResponsibles()) {
                output = output + "... <" + (i - XFPanelView.this.getMaxAmmountOfResponsibles()) + " more>";
            }
            if (!output.isEmpty()) {
                return output;
            }
            return " - ";
        }

        public String getCulprits() {
            Run run;
            if (XFPanelView.this.BlameState == Blame.ONLYFIRSTFAILEDBUILD) {
                Run run2 = this.job.getLastStableBuild();
                run2 = run2 == null ? this.job.getFirstBuild() : run2.getNextBuild();
                if (run2 instanceof AbstractBuild) {
                    AbstractBuild firstFailedBuild = (AbstractBuild)run2;
                    return this.convertCulpritsToString(this.getCulpritFromBuild(firstFailedBuild));
                }
            } else if (XFPanelView.this.BlameState == Blame.ONLYLASTFAILEDBUILD) {
                Run run3 = this.job.getLastFailedBuild();
                if (run3 instanceof AbstractBuild) {
                    AbstractBuild lastFailedBuild = (AbstractBuild)run3;
                    return this.convertCulpritsToString(this.getCulpritFromBuild(lastFailedBuild));
                }
            } else if (XFPanelView.this.BlameState == Blame.EVERYINVOLVED && (run = this.job.getLastBuild()) instanceof AbstractBuild) {
                AbstractBuild build = (AbstractBuild)run;
                HashSet<User> BlameList = new HashSet<User>(build.getCulprits());
                return this.convertCulpritsToString(BlameList);
            }
            return " -";
        }

        private ClaimBuildAction getClaimAction() {
            ClaimBuildAction claimAction = null;
            if (Hudson.getInstance().getPlugin("claim") != null) {
                List claimActionList;
                Run lastBuild = this.job.getLastBuild();
                if (lastBuild != null && lastBuild.isBuilding()) {
                    lastBuild = lastBuild.getPreviousBuild();
                }
                if (lastBuild != null && (claimActionList = lastBuild.getActions(ClaimBuildAction.class)).size() == 1) {
                    claimAction = (ClaimBuildAction)claimActionList.get(0);
                }
            }
            return claimAction;
        }

        public boolean isClaimed() {
            ClaimBuildAction cba = this.getClaimAction();
            if (cba != null) {
                return cba.isClaimed();
            }
            return false;
        }

        public String getClaimInfo() {
            ClaimBuildAction claimAction = this.getClaimAction();
            if (claimAction != null && claimAction.isClaimed()) {
                String name = claimAction.getClaimedByName();
                return name;
            }
            return "";
        }

        public int getNumClaimedTests() {
            if (Hudson.getInstance().getPlugin("claim") != null) {
                Run lastBuild = this.job.getLastBuild();
                if (lastBuild == null) {
                    return 0;
                }
                List claimTestActionList = lastBuild.getActions();
                List results = lastBuild.getActions(TestResultAction.class);
                if (results == null || claimTestActionList == null || results.size() == 0) {
                    return 0;
                }
                int numClaimedTests = 0;
                TestResult testResult = ((TestResultAction)results.get(0)).getResult();
                for (CaseResult result : testResult.getFailedTests()) {
                    ClaimTestAction claimTestAction = (ClaimTestAction)result.getTestAction(ClaimTestAction.class);
                    if (claimTestAction == null || !claimTestAction.isClaimed()) continue;
                    ++numClaimedTests;
                }
                return numClaimedTests;
            }
            return -1;
        }

        public String getNumberOfTests() {
            int claimedTests;
            int failedTests = this.getFailCount();
            if (failedTests == 0 && !XFPanelView.this.getShowZeroTestCounts().booleanValue()) {
                return "";
            }
            if (XFPanelView.this.getReplaceNumberOfTestCases().booleanValue() && (claimedTests = this.getNumClaimedTests()) >= 0) {
                return Integer.toString(failedTests - claimedTests);
            }
            return Integer.toString(failedTests);
        }

        public String getDiffColor() {
            String diff = this.getDiff().trim();
            if (diff.length() > 0) {
                if (diff.startsWith("-")) {
                    return "#FF0000";
                }
                return "#00FF00";
            }
            return "#FFFFFF";
        }

        public String getSuccessPercentage() {
            if (this.getTestCount() > 0) {
                Double perc = (double)this.getSuccessCount() / ((double)this.getTestCount() * 1.0);
                return NumberFormat.getPercentInstance().format(perc);
            }
            return "";
        }

        public String getBuildStatus() {
            Run run = this.job.getLastBuild();
            if (run == null) {
                return "UNBUILT";
            }
            if (run instanceof AbstractBuild) {
                AbstractBuild build = (AbstractBuild)run;
                if (build == null) {
                    return "UNBUILT";
                }
                Result result = build.getResult();
                if (result != null) {
                    Result[] allResults = new Result[]{Result.SUCCESS, Result.ABORTED, Result.NOT_BUILT, Result.UNSTABLE, Result.FAILURE};
                    String[] resultStr = new String[]{"SUCCESS", "ABORTED", "NOT_BUILT", "UNSTABLE", "FAILURE"};
                    for (int i = 0; i < allResults.length; ++i) {
                        if (result != allResults[i]) continue;
                        return resultStr[i];
                    }
                }
            }
            return "UNKNOWN";
        }

        public boolean isBuildSuccessful() {
            return this.getBuildStatus().equals("SUCCESS");
        }

        private void findStatus() {
            switch (this.job.getIconColor()) {
                case BLUE_ANIME: {
                    this.building = true;
                }
                case BLUE: {
                    this.backgroundColor = XFPanelView.this.getColors().getOkBG();
                    this.color = XFPanelView.this.colors.getOkFG();
                    this.broken = false;
                    break;
                }
                case YELLOW_ANIME: {
                    this.building = true;
                }
                case YELLOW: {
                    this.backgroundColor = XFPanelView.this.getColors().getFailedBG();
                    this.color = XFPanelView.this.colors.getFailedFG();
                    this.broken = false;
                    break;
                }
                case RED_ANIME: {
                    this.building = true;
                }
                case RED: {
                    this.backgroundColor = XFPanelView.this.getColors().getBrokenBG();
                    this.color = XFPanelView.this.colors.getBrokenFG();
                    this.broken = true;
                    break;
                }
                case GREY_ANIME: 
                case DISABLED_ANIME: {
                    this.building = true;
                }
                default: {
                    this.backgroundColor = XFPanelView.this.getColors().getOtherBG();
                    this.color = XFPanelView.this.colors.getOtherFG();
                    this.broken = true;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class selectComparator
    implements Comparator<XFPanelEntry> {
        selectComparator() {
        }

        private int getPriority(AbstractBuild build) {
            if (build == null) {
                return 1;
            }
            if (build.isBuilding()) {
                build = (AbstractBuild)build.getPreviousBuild();
                return this.getPriority(build);
            }
            Result result = build.getResult();
            if (result != null) {
                Result[] allResults = new Result[]{Result.SUCCESS, Result.ABORTED, Result.NOT_BUILT, Result.UNSTABLE, Result.FAILURE};
                int[] resultValues = new int[]{0, 1, 1, 2, 3};
                for (int i = 0; i < allResults.length; ++i) {
                    if (result != allResults[i]) continue;
                    return resultValues[i];
                }
            }
            return 1;
        }

        @Override
        public int compare(XFPanelEntry a, XFPanelEntry b) {
            AbstractBuild buildA = (AbstractBuild)a.job.getLastBuild();
            AbstractBuild buildB = (AbstractBuild)b.job.getLastBuild();
            int result = this.getPriority(buildB) - this.getPriority(buildA);
            if (result == 0) {
                if (buildA == null || buildB == null) {
                    return buildA == null ? 1 : 0;
                }
                if (buildA.isBuilding() || buildB.isBuilding()) {
                    return buildA.isBuilding() ? 0 : 1;
                }
                return b.completionTimestamp.compareTo(a.completionTimestamp);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Blame {
        NOTATALL,
        ONLYLASTFAILEDBUILD,
        ONLYFIRSTFAILEDBUILD,
        EVERYINVOLVED;

    }
}

