/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh;

import au.com.rayh.BuildConfiguration;
import au.com.rayh.InfoPlist;
import au.com.rayh.ProjectScheme;
import au.com.rayh.ProjectTarget;
import au.com.rayh.XcodeProject;
import au.com.rayh.XcodeSchemeFileFilter;
import com.dd.plist.NSArray;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import hudson.FilePath;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XcodeProjectParser {
    public static HashMap<String, ProjectScheme> listXcodeSchemes(FilePath projectLocation) {
        String currentUser = System.getProperty("user.name");
        HashMap<String, ProjectScheme> schemeList = new HashMap<String, ProjectScheme>();
        ArrayList<FilePath> schemeFilesDirList = new ArrayList<FilePath>();
        try {
            if (projectLocation.child("xcuserdata/" + currentUser + ".xcuserdatad/xcschemes").exists()) {
                schemeFilesDirList.add(projectLocation.child("xcuserdata/" + currentUser + ".xcuserdatad/xcschemes"));
            }
            if (projectLocation.child("xcshareddata/xcschemes").exists()) {
                schemeFilesDirList.add(projectLocation.child("xcshareddata/xcschemes"));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            schemeList = null;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            schemeList = null;
        }
        for (FilePath schemeFilesDir : schemeFilesDirList) {
            try {
                List files = schemeFilesDir.list((FileFilter)new XcodeSchemeFileFilter());
                if (files == null) {
                    return null;
                }
                for (FilePath file : files) {
                    ProjectScheme scheme = XcodeProjectParser.parseXcodeScheme(file);
                    String schemeName = file.getBaseName().replaceAll(".xcscheme$", "");
                    schemeList.put(schemeName, scheme);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                schemeList = null;
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                schemeList = null;
            }
        }
        return schemeList;
    }

    public static ProjectScheme parseXcodeScheme(FilePath schemeFile) {
        ProjectScheme projectScheme = new ProjectScheme();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(schemeFile.read());
            Element root = document.getDocumentElement();
            if (root.getNodeName().equals("Scheme")) {
                NodeList schemeNodes = root.getChildNodes();
                for (int i = 0; i < schemeNodes.getLength(); ++i) {
                    Element element;
                    Node node = schemeNodes.item(i);
                    if (node.getNodeType() != 1 || !(element = (Element)node).getNodeName().equals("BuildAction")) continue;
                    NodeList buildActionNodes = element.getChildNodes();
                    for (int j = 0; j < buildActionNodes.getLength(); ++j) {
                        node = buildActionNodes.item(j);
                        if (node.getNodeType() != 1 || !(element = (Element)node).getNodeName().equals("BuildActionEntries")) continue;
                        NodeList buildActionEntriesNodes = element.getChildNodes();
                        for (int k = 0; k < buildActionEntriesNodes.getLength(); ++k) {
                            node = buildActionEntriesNodes.item(k);
                            if (node.getNodeType() != 1 || !(element = (Element)node).getNodeName().equals("BuildActionEntry")) continue;
                            NodeList buildActionEntryNodes = element.getChildNodes();
                            for (int l = 0; l < buildActionEntryNodes.getLength(); ++l) {
                                node = buildActionEntryNodes.item(l);
                                if (node.getNodeType() != 1 || !(element = (Element)node).getNodeName().equals("BuildableReference")) continue;
                                projectScheme.blueprintName = element.getAttribute("BlueprintName");
                                projectScheme.referencedContainer = element.getAttribute("ReferencedContainer");
                            }
                        }
                    }
                }
            }
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            projectScheme = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            projectScheme = null;
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            projectScheme = null;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            projectScheme = null;
        }
        return projectScheme;
    }

    public static List<String> parseXcodeWorkspace(FilePath workspaceFileLocation) {
        ArrayList<String> projectList = new ArrayList<String>();
        try {
            FilePath workspaceFilePath = workspaceFileLocation.child("contents.xcworkspacedata");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.parse(workspaceFilePath.read());
            Element root = document.getDocumentElement();
            if (root.getNodeName().equals("Workspace")) {
                NodeList rootChildren = root.getChildNodes();
                for (int i = 0; i < rootChildren.getLength(); ++i) {
                    String projectLocation;
                    Element element;
                    Node node = rootChildren.item(i);
                    if (node.getNodeType() != 1 || !(element = (Element)node).getNodeName().equals("FileRef") || !(projectLocation = element.getAttribute("location")).startsWith("group:")) continue;
                    projectLocation = projectLocation.replaceAll("^group:", "");
                    projectList.add(projectLocation);
                }
            }
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            projectList = null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            projectList = null;
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            projectList = null;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            projectList = null;
        }
        return projectList;
    }

    public static InfoPlist parseInfoPlist(FilePath infoPlistFile) {
        InfoPlist infoPlist = null;
        try {
            NSDictionary rootDict = (NSDictionary)PropertyListParser.parse((InputStream)infoPlistFile.read());
            String cfBundleIdentifier = rootDict.objectForKey("CFBundleIdentifier").toString();
            String cfBundleVersion = rootDict.objectForKey("CFBundleVersion").toString();
            String cfBundleShortVersionString = rootDict.objectForKey("CFBundleShortVersionString").toString();
            infoPlist = new InfoPlist(infoPlistFile, cfBundleIdentifier, cfBundleVersion, cfBundleShortVersionString);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return infoPlist;
    }

    public static XcodeProject parseXcodeProject(FilePath projectLocation) {
        XcodeProject project = new XcodeProject();
        FilePath xcodeProjectFile = projectLocation.child("project.pbxproj");
        try {
            NSObject[] projectTargetUUIDs;
            NSDictionary rootDict = (NSDictionary)PropertyListParser.parse((InputStream)xcodeProjectFile.read());
            String rootObjectsUUID = rootDict.objectForKey("rootObject").toString();
            NSDictionary objectsDict = (NSDictionary)rootDict.objectForKey("objects");
            NSDictionary pbxProjectSectionDict = (NSDictionary)objectsDict.objectForKey(rootObjectsUUID);
            for (NSObject projectTargetUUID : projectTargetUUIDs = ((NSArray)pbxProjectSectionDict.objectForKey("targets")).getArray()) {
                ProjectTarget target = new ProjectTarget();
                NSDictionary projectTargetDict = (NSDictionary)objectsDict.objectForKey(projectTargetUUID.toString());
                target.uuid = projectTargetUUID.toString();
                String targetName = projectTargetDict.objectForKey("name").toString();
                String buildConfigurationListUUID = projectTargetDict.objectForKey("buildConfigurationList").toString();
                target.productType = projectTargetDict.objectForKey("productType").toString();
                if (target.productType.equals("com.apple.product-type.application") || target.productType.equals("com.apple.product-type.bundle.unit-test") || target.productType.equals("com.apple.product-type.bundle.ui-testing") || target.productType.equals("com.apple.product-type.watchkit-extension") || target.productType.equals("com.apple.product-type.application.watchapp") || target.productType.equals("com.apple.product-type.watchkit2-extension") || target.productType.equals("com.apple.product-type.application.watchapp2")) {
                    NSDictionary buildConfigurationList;
                    NSDictionary attributesDict = (NSDictionary)pbxProjectSectionDict.objectForKey("attributes");
                    NSDictionary targetAttributesDict = (NSDictionary)attributesDict.objectForKey("TargetAttributes");
                    NSDictionary attributeDict = (NSDictionary)targetAttributesDict.objectForKey(target.uuid);
                    target.provisioningStyle = attributeDict.objectForKey("ProvisioningStyle") != null ? attributeDict.objectForKey("ProvisioningStyle").toString() : "Automatic";
                    if (attributeDict.objectForKey("TestTargetID") != null) {
                        target.testTargetID = attributeDict.objectForKey("TestTargetID").toString();
                    }
                    if ((buildConfigurationList = (NSDictionary)objectsDict.objectForKey(buildConfigurationListUUID)) != null) {
                        NSObject[] buildConfigurationUUIDs;
                        if (buildConfigurationList.objectForKey("defaultConfigurationName") != null) {
                            target.defaultConfigurationName = buildConfigurationList.objectForKey("defaultConfigurationName").toString();
                        }
                        for (NSObject buildConfigurationUUID : buildConfigurationUUIDs = ((NSArray)buildConfigurationList.objectForKey("buildConfigurations")).getArray()) {
                            BuildConfiguration buildConfiguration = new BuildConfiguration(objectsDict, buildConfigurationUUID.toString(), target.provisioningStyle.equals("Automatic"));
                            target.buildConfiguration.put(buildConfiguration.name, buildConfiguration);
                        }
                    }
                    project.projectTarget.put(targetName, target);
                    continue;
                }
                if (!target.productType.equals("com.apple.product-type.framework")) continue;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            project = null;
        }
        catch (PropertyListFormatException ex) {
            ex.printStackTrace();
            project = null;
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            project = null;
        }
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
            project = null;
        }
        catch (SAXException ex) {
            ex.printStackTrace();
            project = null;
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
            project = null;
        }
        return project;
    }
}

