/*
 * Decompiled with CFR 0.152.
 */
package au.com.rayh;

import au.com.rayh.KeychainPasswordAndPath;
import au.com.rayh.Messages;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.Secret;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class KeychainPasswordAndPathImpl
extends BaseStandardCredentials
implements KeychainPasswordAndPath {
    @NonNull
    private String keychainPath;
    @NonNull
    private Secret password;
    @Nullable
    private String inSearchPath;

    @DataBoundConstructor
    public KeychainPasswordAndPathImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @CheckForNull String keychainPath, @CheckForNull String password, @CheckForNull String inSearchPath) {
        super(scope, id, description);
        this.keychainPath = Util.fixNull((String)keychainPath);
        this.password = Secret.fromString((String)password);
        this.inSearchPath = inSearchPath;
    }

    @Override
    public Secret getPassword() {
        return this.password;
    }

    @DataBoundSetter
    public void setPassword(Secret password) {
        this.password = password;
    }

    @Override
    @NonNull
    public String getKeychainPath() {
        return this.keychainPath;
    }

    @DataBoundSetter
    public void setKeychainPath(String keychainPath) {
        this.keychainPath = keychainPath;
    }

    @Override
    public String getInSearchPath() {
        return this.inSearchPath;
    }

    @DataBoundSetter
    public void setInSearchPath(String inSearchPath) {
        this.inSearchPath = inSearchPath;
    }

    @Override
    public boolean isInSearchPath() {
        return this.inSearchPath == null ? false : this.inSearchPath.equals("true");
    }

    public static List<KeychainPasswordAndPathImpl> getAllKeycainInfo() {
        return CredentialsProvider.lookupCredentials(KeychainPasswordAndPathImpl.class, (Item)null, (Authentication)ACL.SYSTEM, Collections.emptyList());
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return Messages.KeychainPasswordAndPath_DisplayName();
        }
    }
}

