/*
 * Decompiled with CFR 0.152.
 */
package com.worksoft.jenkinsci.plugins.em.model;

import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.worksoft.jenkinsci.plugins.em.model.EmAuth;
import com.worksoft.jenkinsci.plugins.em.model.EmResult;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import jodd.http.HttpException;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.runtime.StackTraceUtils;

public class ExecutionManagerServer {
    private static final Logger log = Logger.getLogger("jenkins.ExecutionManager");
    private final String url;
    private final UsernamePasswordCredentials credentials;
    private EmAuth auth;
    private EmResult lastEMResult;

    public EmResult getLastEMResult() {
        return this.lastEMResult;
    }

    public ExecutionManagerServer(String url, UsernamePasswordCredentials credentials) {
        if (credentials == null) {
            throw new RuntimeException("Credentials must be provided!");
        }
        try {
            URL uRL = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Execution Manager URL is invalid " + e.getMessage());
        }
        this.url = !url.endsWith("/") ? url + "/" : url;
        this.credentials = credentials;
    }

    public boolean login() throws UnsupportedEncodingException {
        HttpRequest httpRequest = (HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.post((String)(this.url + "api/Token")).contentType("application/x-www-form-urlencoded")).header("Authorization", "OAuth2")).form("grant_type", (Object)"password", new Object[]{"username", this.credentials.getUsername(), "password", this.credentials.getPassword().getPlainText()});
        EmResult result = this.sendRequest(httpRequest);
        if (result.is200()) {
            this.auth = new EmAuth();
            this.auth.save(result.getJsonData());
        }
        return result.is200();
    }

    public JSONObject bookmarks() {
        HttpRequest httpRequest = (HttpRequest)HttpRequest.get((String)(this.url + "api/Bookmarks")).header("jsonOrXml", "json");
        httpRequest.body("");
        EmResult result = this.sendRequest(httpRequest);
        if (result.is200()) {
            return result.getJsonData();
        }
        return null;
    }

    public JSONObject requests() {
        HttpRequest httpRequest = (HttpRequest)HttpRequest.get((String)(this.url + "api/Requests")).header("jsonOrXml", "json");
        httpRequest.body("");
        EmResult result = this.sendRequest(httpRequest);
        if (result.is200()) {
            return result.getJsonData();
        }
        return null;
    }

    public String escapeParameter(String value) {
        value = value.replaceAll("\\\\", "\\\\\\\\");
        value = value.replaceAll("\"", "\\\\\"");
        return value;
    }

    public String sanitizeParameter(String value) {
        value = value.replaceAll("\\|", "");
        value = value.replaceAll("[{}]", "");
        return value;
    }

    private String formatParameters(Map<String, String> parameters) {
        String params = "";
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            params = params + "{" + key + "}";
            params = params + "{" + this.escapeParameter(this.sanitizeParameter(value)) + "}";
        }
        return params;
    }

    public String executeRequest(String request, Map<String, String> parameters) {
        HttpRequest httpRequest = (HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.put((String)(this.url + "api/ExecuteRequest")).header("id", request)).header("parameters", this.formatParameters(parameters))).header("jsonOrXml", "json");
        httpRequest.body("");
        String guid = null;
        EmResult result = this.sendRequest(httpRequest);
        if (result.is200()) {
            String response = result.getResponseData();
            guid = response.length() >= 2 && response.charAt(0) == '\"' && response.charAt(response.length() - 1) == '\"' ? response.substring(1, response.length() - 1) : response;
        }
        return guid;
    }

    public String executeBookmark(String bookmark, String folder, Map<String, String> parameters) {
        HttpRequest httpRequest = (HttpRequest)((HttpRequest)HttpRequest.put((String)(this.url + "api/Bookmarks/" + bookmark + "/Execute" + (StringUtils.isNotEmpty((String)folder) ? "?folder=" + folder : ""))).header("parameters", this.formatParameters(parameters))).header("jsonOrXml", "json");
        httpRequest.body("");
        String guid = null;
        EmResult result = this.sendRequest(httpRequest);
        if (result.is200()) {
            String response = result.getResponseData();
            guid = response.length() >= 2 && response.charAt(0) == '\"' && response.charAt(response.length() - 1) == '\"' ? response.substring(1, response.length() - 1) : response;
        }
        return guid;
    }

    public String executeProcesses(JSONObject processes, Map<String, String> parameters) {
        HttpRequest httpRequest = (HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.put((String)(this.url + "api/Processes/Execute")).header("parameters", this.formatParameters(parameters))).header("jsonOrXml", "json")).header("content-type", "application/json");
        httpRequest.body(JSONUtils.valueToString((Object)processes, (int)4, (int)0));
        String guid = null;
        EmResult result = this.sendRequest(httpRequest);
        if (result.is200()) {
            String response = result.getResponseData();
            guid = response.length() >= 2 && response.charAt(0) == '\"' && response.charAt(response.length() - 1) == '\"' ? response.substring(1, response.length() - 1) : response;
        }
        return guid;
    }

    public EmResult executionStatus(String guid) {
        HttpRequest httpRequest = (HttpRequest)((HttpRequest)HttpRequest.get((String)(this.url + "api/ExecutionStatus")).header("APIRequestID ", guid)).header("jsonOrXml", "json");
        EmResult result = this.sendRequest(httpRequest);
        return result;
    }

    public EmResult executionAbort(String guid) {
        HttpRequest httpRequest = (HttpRequest)((HttpRequest)HttpRequest.put((String)(this.url + "api/Execution/" + guid + "/Abort")).header("id", guid)).header("jsonOrXml", "json");
        httpRequest.body("");
        EmResult result = this.sendRequest(httpRequest);
        return result;
    }

    private EmResult sendRequest(HttpRequest request) throws HttpException {
        EmResult result;
        try {
            HttpResponse response;
            if (this.auth != null) {
                request.tokenAuthentication(this.auth.getAccess_token());
            }
            if (!(result = (this.lastEMResult = new EmResult(response = request.send()))).is200()) {
                if (result.statusCode() == 401) {
                    throw new Exception("Unauthorized");
                }
                log.warning("ExecutionManager request failed " + response.toString(true));
            }
        }
        catch (Throwable t) {
            EmResult result2 = new EmResult(null);
            log.severe("ERROR: unexpected error while processing request: " + request);
            log.severe("ERROR: exception: " + t);
            log.severe("ERROR: exception: " + t.getMessage());
            log.severe("ERROR: stack trace:  ");
            StackTraceUtils.printSanitizedStackTrace((Throwable)t.getCause());
            throw new HttpException(t);
        }
        return result;
    }
}

