/*
 * Decompiled with CFR 0.152.
 */
package com.worksoft.jenkinsci.plugins.em.model;

import jodd.http.HttpResponse;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;

public class EmResult {
    private static final char OPEN_CURLY = '{';
    private static final char CLOSE_CURLY = '}';
    private static final char OPEN_BRACKET = '[';
    private final HttpResponse response;
    private JSONObject jsonData = null;
    private static HttpResponse nullResponse = new HttpResponse();

    public EmResult(HttpResponse response) {
        if (response != null) {
            this.response = response;
            if (this.isJson(response.bodyText())) {
                String jsonText = response.bodyText();
                if (jsonText.startsWith("[")) {
                    jsonText = "{\"objects\": " + jsonText + '}';
                }
                this.jsonData = (JSONObject)JSONSerializer.toJSON((Object)jsonText);
            }
        } else {
            this.response = nullResponse;
        }
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public JSONObject getJsonData() {
        return this.jsonData;
    }

    public boolean is200() {
        return this.response.statusCode() == 200;
    }

    public String getResponseData() {
        return this.response.bodyText();
    }

    public boolean isOkAndHasResponse() {
        return this.response.statusCode() == 200 && this.response.bodyText() != null && this.response.bodyText().length() > 0;
    }

    private boolean isJson(String text) {
        char token;
        boolean json = false;
        if (text != null && text.length() > 0 && ((token = text.charAt(0)) == '{' || token == '[')) {
            json = true;
        }
        return json;
    }

    public int statusCode() {
        return this.response.statusCode();
    }

    public boolean isUnauthorized() {
        return this.response.statusCode() == 401;
    }

    public String dumpDebug() {
        return this.response.toString(true);
    }

    static {
        nullResponse.statusCode(-1);
        nullResponse.statusPhrase("null response");
    }
}

