/*
 * Decompiled with CFR 0.152.
 */
package com.worksoft.jenkinsci.plugins.em;

import com.google.common.primitives.Ints;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public final class ExecuteRequestWaitConfig
extends AbstractDescribableImpl<ExecuteRequestWaitConfig> {
    @Exported
    public String pollInterval;
    @Exported
    public String maxRunTime;

    @DataBoundConstructor
    public ExecuteRequestWaitConfig(String pollInterval, String maxRunTime) {
        this.pollInterval = pollInterval;
        this.maxRunTime = maxRunTime;
    }

    public String getPollInterval() {
        return this.pollInterval;
    }

    public String getMaxRunTime() {
        return this.maxRunTime;
    }

    private Long stringSecondsToMillis(String sVal) {
        Integer val;
        Long retVal = null;
        if (!StringUtils.isEmpty((String)sVal) && (val = Ints.tryParse((String)sVal)) != null && (retVal = Long.valueOf(val.intValue())) <= 0L) {
            retVal = null;
        }
        if (retVal != null) {
            retVal = TimeUnit.MILLISECONDS.convert(retVal, TimeUnit.SECONDS);
        }
        return retVal;
    }

    public Long pollIntervalInMillis() {
        return this.stringSecondsToMillis(this.getPollInterval());
    }

    public Long maxRunTimeInMillis() {
        return this.stringSecondsToMillis(this.getMaxRunTime());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ExecuteRequestWaitConfig> {
        public String getDisplayName() {
            return "ExecuteRequestWaitConfig";
        }

        public FormValidation doCheckPollInterval(@QueryParameter String pollInterval) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isEmpty((String)pollInterval)) {
                ret = FormValidation.error((String)"A polling interval must be specified!");
            } else {
                Integer val = Ints.tryParse((String)pollInterval);
                if (val == null) {
                    ret = FormValidation.error((String)"The polling interval must be an integer!");
                } else if (val <= 0) {
                    ret = FormValidation.error((String)"The polling interval must be a positive integer!");
                }
            }
            return ret;
        }

        public FormValidation doCheckMaxRunTime(@QueryParameter String maxRunTime) {
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isEmpty((String)maxRunTime)) {
                ret = FormValidation.error((String)"A maximum run time must be specified!");
            } else {
                Integer val = Ints.tryParse((String)maxRunTime);
                if (val == null) {
                    ret = FormValidation.error((String)"The maximum run time must be an integer!");
                } else if (val <= 0) {
                    ret = FormValidation.error((String)"The maximum run time must be a positive integer!");
                }
            }
            return ret;
        }
    }
}

